/*
 * Decompiled with CFR 0.152.
 */
package hiro.yoshioka.job;

import hiro.yoshioka.csveditor.dialog.CSVConfigDialog;
import hiro.yoshioka.sdh.DatabaseType;
import hiro.yoshioka.sql.DataBaseFactory;
import hiro.yoshioka.sql.engine.SQLServerThread;
import hiro.yoshioka.sql.params.ConnectionProperties;
import hiro.yoshioka.sql.resource.IDBColumn;
import hiro.yoshioka.sql.resource.IDBSchema;
import hiro.yoshioka.sql.resource.IDBTable;
import hiro.yoshioka.util.SQLDataType;
import hiro.yoshioka.wolfdbmanager.resource.ResourceMarker;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.io.Writer;
import java.sql.SQLException;
import jp.sf.orangesignal.csv.CsvConfig;
import jp.sf.orangesignal.csv.CsvWriter;
import jp.sf.orangesignal.csv.handlers.ResultSetHandler;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.Job;

public class ExportTable2CSVJob
extends Job {
    protected transient Log fLogger = LogFactory.getLog(((Object)((Object)this)).getClass());
    private CSVConfigDialog.MyCsvConfig csvCfg;
    private ConnectionProperties connectionProperties;
    IFolder fOutDir;
    IDBTable[] fExportTable;
    IProgressMonitor monitor;

    public ExportTable2CSVJob(IFolder outDir, IDBSchema schema, CSVConfigDialog.MyCsvConfig config) {
        super("CSV Export");
        this.csvCfg = config;
        this.fOutDir = outDir;
        this.fExportTable = schema.getTableOrViews();
    }

    public ExportTable2CSVJob(IFolder outDir, IDBTable[] tbls, CSVConfigDialog.MyCsvConfig config) {
        super("CSV Export");
        this.csvCfg = config;
        this.fOutDir = outDir;
        this.fExportTable = tbls;
    }

    protected IStatus run(IProgressMonitor monitor) {
        IStatus ret = Status.OK_STATUS;
        this.monitor = monitor;
        try {
            int i = 0;
            while (i < this.fExportTable.length) {
                this.doWork(this.fExportTable[i]);
                ++i;
            }
        }
        catch (Throwable e) {
            this.fLogger.error((Object)"", e);
            ret = Status.CANCEL_STATUS;
        }
        return ret;
    }

    private void doWork(IDBTable table) throws SQLException, IOException {
        if (table.getUName().indexOf("$") >= 0) {
            return;
        }
        PrintWriter out = null;
        String name = String.valueOf(table.getUName()) + "." + ResourceMarker.csvFolder;
        IFolder folder = ResourceMarker.getFolder(null, ResourceMarker.csvFolder);
        folder = ResourceMarker.getFolder(folder, this.fOutDir.getName(), true);
        IFile iFile = ResourceMarker.createFile(folder, name);
        File file = ResourceMarker.cnvFile(iFile);
        StringBuffer select = new StringBuffer("");
        select.append("SELECT ");
        IDBColumn[] columns = table.getColumns();
        boolean[] quot = new boolean[columns.length];
        int m = 0;
        while (m < columns.length) {
            quot[m] = true;
            switch (columns[m].getDataType()) {
                case DATE: 
                case TIMESTAMP: {
                    select.append(DataBaseFactory.getStringFormat((SQLDataType)columns[m].getDataType(), (DatabaseType)this.connectionProperties.getDatabaseType(), (String)columns[m].getName()));
                    select.append(" AS ");
                    select.append(columns[m].getName()).append(",");
                    quot[m] = false;
                    break;
                }
                case TIME: {
                    select.append(DataBaseFactory.getStringFormatHH24MI((DatabaseType)this.connectionProperties.getDatabaseType(), (String)columns[m].getName()));
                    select.append(" AS ");
                    select.append(columns[m].getName()).append(",");
                    quot[m] = false;
                    break;
                }
                case TINYINT: 
                case SMALLINT: 
                case INTEGER: 
                case BIGINT: 
                case REAL: 
                case NUMERIC: 
                case DECIMAL: {
                    quot[m] = false;
                    select.append(columns[m].getName()).append(",");
                    break;
                }
                default: {
                    select.append(columns[m].getName()).append(",");
                }
            }
            ++m;
        }
        select.setLength(select.length() - 1);
        select.append(" FROM ");
        if (table.getParent().getName().trim().length() > 0) {
            select.append(String.valueOf(table.getParent().getName()) + ".");
        }
        select.append(table.getName());
        out = new PrintWriter(new OutputStreamWriter((OutputStream)new FileOutputStream(file), this.csvCfg.getEncoding()));
        ResultSetHandler handler = new ResultSetHandler();
        CsvWriter writer = new CsvWriter((Writer)out, (CsvConfig)this.csvCfg);
        SQLServerThread.getSQLServer().getTransactionSQL(this.connectionProperties).saveCsv(select.toString(), handler, writer);
        out.close();
        try {
            NullProgressMonitor np = new NullProgressMonitor();
            iFile.setCharset(this.csvCfg.getEncoding(), (IProgressMonitor)np);
            iFile.refreshLocal(0, (IProgressMonitor)np);
        }
        catch (CoreException coreException) {}
        Runtime.getRuntime().gc();
    }

    public void setConnectionProperties(ConnectionProperties selectedConnectionProperties) {
        this.connectionProperties = selectedConnectionProperties;
    }
}

