/*
 * Decompiled with CFR 0.152.
 */
package hiro.yoshioka.job;

import hiro.yoshioka.job.PoiDateUtil;
import hiro.yoshioka.preferences.PreferenceUtil;
import java.awt.Dimension;
import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.math.BigDecimal;
import java.util.HashMap;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.poi.hssf.usermodel.HSSFCell;
import org.apache.poi.hssf.usermodel.HSSFCellStyle;
import org.apache.poi.hssf.usermodel.HSSFClientAnchor;
import org.apache.poi.hssf.usermodel.HSSFDataFormatter;
import org.apache.poi.hssf.usermodel.HSSFFont;
import org.apache.poi.hssf.usermodel.HSSFPatriarch;
import org.apache.poi.hssf.usermodel.HSSFPicture;
import org.apache.poi.hssf.usermodel.HSSFRow;
import org.apache.poi.hssf.usermodel.HSSFSheet;
import org.apache.poi.hssf.usermodel.HSSFWorkbook;
import org.eclipse.swt.graphics.FontData;

public abstract class AbsBasicPoiWriter {
    protected FontData fd = PreferenceUtil.getFont("EXCEL_FONT_NAME");
    protected Log fLogger = LogFactory.getLog(this.getClass());
    Pattern P_ALPFA_NUM = Pattern.compile("([a-zA-Z]+)([0-9]+)");
    HSSFFont fontBule;
    HSSFFont fontGray;
    HSSFFont fontRed;
    HSSFCellStyle styleHeader;
    HSSFCellStyle styleBorderLeftBottom;
    HSSFCellStyle styleBorderBottom;
    HSSFCellStyle styleBordered;
    HSSFCellStyle styleLinkedBorderLeftBottom;
    HSSFCellStyle styleLinkedBorderBottom;
    HSSFCellStyle styleLinkedBordered;
    HSSFCellStyle styleErrorBordered;
    HSSFCellStyle styleErrorBorderedTopDashed;
    protected static final String EXTENSION = ".xls";
    HSSFFont black_font_8;
    HSSFFont white_font_8;
    HSSFFont white_bold_font_8;
    short format_h_m_s;
    short format_h_m;
    short format_y_m_d;
    short format_y_m;
    short format_y_m_d_h_m_s;
    HSSFFont link_font_8;
    HSSFFont link_font;
    HSSFCellStyle link_style;
    File xlsFile;
    InputStream xlsFileInputStream;
    Map beans;
    protected HSSFWorkbook fHSSFWorkbook;
    OutputStream output_stream;
    Map<String, HSSFCellStyle> cellStyleMap = new HashMap<String, HSSFCellStyle>();
    Map<String, HSSFFont> fontMap = new HashMap<String, HSSFFont>();
    Map<String, byte[]> bar_code_image_map = new HashMap<String, byte[]>();
    Map<String, byte[]> picture_image_map = new HashMap<String, byte[]>();
    private BufferedInputStream fFileInputStream;
    protected File fFile;
    protected HashMap<String, HSSFCellStyle> fStyleMap = new HashMap();
    static final Pattern fRowNumPattern = Pattern.compile("([a-zA-Z]+)(\\d+)");

    public AbsBasicPoiWriter(File file) {
        this.fFile = file;
    }

    public AbsBasicPoiWriter() {
        this.fHSSFWorkbook = new HSSFWorkbook();
        this.initFonts();
        this.initStyles();
    }

    public AbsBasicPoiWriter(BufferedInputStream stream) {
        this.fFileInputStream = stream;
    }

    public boolean init() {
        try {
            if (this.fFileInputStream == null) {
                this.fFileInputStream = new BufferedInputStream(new FileInputStream(this.fFile));
            }
            this.fHSSFWorkbook = new HSSFWorkbook((InputStream)this.fFileInputStream);
            this.initFonts();
            this.initStyles();
            return true;
        }
        catch (IOException ex) {
            this.fLogger.warn((Object)"Excel ", (Throwable)ex);
        }
        finally {
            try {
                this.fFileInputStream.close();
            }
            catch (IOException e) {
                this.fLogger.warn((Object)"", (Throwable)e);
            }
        }
        return false;
    }

    public void initFonts() {
        this.fontBule = this.fHSSFWorkbook.createFont();
        this.fontBule.setItalic(true);
        this.fontBule.setUnderline((byte)1);
        this.fontBule.setColor((short)12);
        this.fontGray = this.fHSSFWorkbook.createFont();
        this.fontGray.setItalic(true);
        this.fontGray.setColor((short)55);
        this.fontRed = this.fHSSFWorkbook.createFont();
        this.fontRed.setItalic(true);
        this.fontRed.setColor((short)10);
    }

    public void initStyles() {
        this.styleHeader = this.fHSSFWorkbook.createCellStyle();
        this.styleHeader.setWrapText(true);
        this.setBorderThin(this.styleHeader, (short)1);
        this.styleHeader.setBorderBottom((short)6);
        this.styleHeader.setFillForegroundColor((short)44);
        this.styleHeader.setFillPattern((short)1);
        this.styleBordered = this.fHSSFWorkbook.createCellStyle();
        this.setBorderThin(this.styleBordered, (short)1);
        this.styleBorderLeftBottom = this.fHSSFWorkbook.createCellStyle();
        this.styleBorderLeftBottom.setBorderLeft((short)1);
        this.styleBorderLeftBottom.setBorderBottom((short)1);
        this.styleBorderBottom = this.fHSSFWorkbook.createCellStyle();
        this.styleBorderBottom.setBorderBottom((short)1);
        this.styleLinkedBordered = this.fHSSFWorkbook.createCellStyle();
        this.styleLinkedBordered.setFont(this.fontBule);
        this.setBorderThin(this.styleLinkedBordered, (short)1);
        this.styleLinkedBorderLeftBottom = this.fHSSFWorkbook.createCellStyle();
        this.styleLinkedBorderLeftBottom.setFont(this.fontBule);
        this.styleLinkedBorderLeftBottom.setBorderLeft((short)1);
        this.styleLinkedBorderLeftBottom.setBorderBottom((short)1);
        this.styleLinkedBorderBottom = this.fHSSFWorkbook.createCellStyle();
        this.styleLinkedBorderBottom.setFont(this.fontBule);
        this.styleLinkedBorderBottom.setBorderBottom((short)1);
        this.styleErrorBordered = this.fHSSFWorkbook.createCellStyle();
        this.styleErrorBordered.setFont(this.fontRed);
        this.setBorderThin(this.styleErrorBordered, (short)1);
        this.styleErrorBorderedTopDashed = this.fHSSFWorkbook.createCellStyle();
        this.styleErrorBorderedTopDashed.setFont(this.fontRed);
        this.setBorderThin(this.styleErrorBorderedTopDashed, (short)1);
        this.styleErrorBorderedTopDashed.setBorderTop((short)3);
    }

    public static String num2Alpha(int index) {
        int numA26 = index % 26;
        int div26 = index / 26;
        if (div26 > 0) {
            return String.valueOf(String.valueOf((char)(div26 + 65 - 1)) + String.valueOf((char)(numA26 + 65)));
        }
        return String.valueOf((char)(numA26 + 65));
    }

    protected short getIndexByColAlphName(String col) {
        int icol = 0;
        if ((col = col.toLowerCase()).length() == 1) {
            char c = col.charAt(0);
            icol = c - 97;
        } else if (col.length() == 2) {
            char c = col.charAt(0);
            if (c == 'a') {
                icol = 26 + (col.charAt(1) - 97);
            }
        } else {
            throw new IllegalArgumentException("Out of range.");
        }
        return (short)icol;
    }

    protected HSSFCellStyle cloneCellStyle(HSSFCellStyle originalStyle) {
        HSSFCellStyle newStyle = this.fHSSFWorkbook.createCellStyle();
        newStyle.setAlignment(originalStyle.getAlignment());
        newStyle.setBorderBottom(originalStyle.getBorderBottom());
        newStyle.setBorderLeft(originalStyle.getBorderLeft());
        newStyle.setBorderRight(originalStyle.getBorderRight());
        newStyle.setBorderTop(originalStyle.getBorderTop());
        newStyle.setBottomBorderColor(originalStyle.getBottomBorderColor());
        newStyle.setDataFormat(originalStyle.getDataFormat());
        newStyle.setFillBackgroundColor(originalStyle.getFillBackgroundColor());
        newStyle.setFillForegroundColor(originalStyle.getFillForegroundColor());
        newStyle.setFillPattern(originalStyle.getFillPattern());
        newStyle.setFont(this.fHSSFWorkbook.getFontAt(originalStyle.getFontIndex()));
        newStyle.setHidden(originalStyle.getHidden());
        newStyle.setIndention(originalStyle.getIndention());
        newStyle.setLeftBorderColor(originalStyle.getLeftBorderColor());
        newStyle.setLocked(originalStyle.getLocked());
        newStyle.setRightBorderColor(originalStyle.getRightBorderColor());
        newStyle.setRotation(originalStyle.getRotation());
        newStyle.setTopBorderColor(originalStyle.getTopBorderColor());
        newStyle.setVerticalAlignment(originalStyle.getVerticalAlignment());
        newStyle.setWrapText(originalStyle.getWrapText());
        return newStyle;
    }

    private void setBorderThin(HSSFCellStyle style, short bkind) {
        style.setBorderTop(bkind);
        style.setBorderBottom(bkind);
        style.setBorderLeft(bkind);
        style.setBorderRight(bkind);
    }

    protected HSSFCellStyle getHSSFCellStyle(boolean wrap, short border, String font, short fontsize, boolean fItalic, short fg, short cell_color, short fill_pattern) {
        return this.getHSSFCellStyle(wrap, border, font, fontsize, fItalic, fg, cell_color, fill_pattern, (short)0);
    }

    protected HSSFCellStyle getHSSFCellStyle(boolean wrap, short border, String font, short fontsize, boolean fItalic, short fg, short cell_color, short fill_pattern, short rotation) {
        String key = String.valueOf(wrap) + "/" + border + "/" + font + "/" + fontsize + "/" + fg + "/" + cell_color + "/" + fill_pattern + "/" + rotation;
        HSSFCellStyle style = this.fStyleMap.get(key);
        if (style == null) {
            style = this.fHSSFWorkbook.createCellStyle();
            style.setWrapText(wrap);
            this.setBorderThin(style, border);
            if (font != null && fontsize > 0) {
                HSSFFont font2 = this.fHSSFWorkbook.createFont();
                try {
                    font2.setFontName(font);
                }
                catch (Exception e) {
                    this.fLogger.warn((Object)"", (Throwable)e);
                    e.printStackTrace();
                }
                font2.setFontHeightInPoints(fontsize);
                if (fg >= 0) {
                    font2.setColor(fg);
                }
                font2.setItalic(fItalic);
                style.setFont(font2);
            }
            if (cell_color >= 0) {
                style.setFillForegroundColor(cell_color);
                style.setFillBackgroundColor((short)9);
                style.setFillPattern(fill_pattern);
            }
            if (rotation != 0) {
                style.setRotation(rotation);
            }
            this.fStyleMap.put(key, style);
        }
        return style;
    }

    protected HSSFCellStyle getChangeBoxStyle() {
        HSSFCellStyle style = this.fStyleMap.get("CHANGE_BOX");
        if (style == null) {
            style = this.fHSSFWorkbook.createCellStyle();
            this.setBorderThin(style, (short)13);
            style.setFillForegroundColor((short)41);
            style.setFillPattern((short)1);
            style.setWrapText(true);
            HSSFFont font2 = this.fHSSFWorkbook.createFont();
            font2.setFontName("\ufffd\uff7c\uff6d\ufffd\uff7c\uff73 \ufffd\uff7c\uff70\u7e67\uff74\u7e67\uff77\u7e5d\ufffd\u7e67\uff6f");
            font2.setFontHeightInPoints((short)9);
            style.setFont(font2);
            this.fStyleMap.put("CHANGE_BOX", style);
        }
        return style;
    }

    protected HSSFPatriarch addPicture(HSSFPatriarch apatriarch, HSSFSheet sheet, int row, int colIdx, byte[] bytes, int picture_type, int height) {
        HSSFRow grow;
        if (apatriarch == null) {
            apatriarch = sheet.createDrawingPatriarch();
        }
        if ((grow = sheet.getRow(row - 1)) == null) {
            grow = sheet.createRow(row - 1);
        }
        HSSFClientAnchor a = new HSSFClientAnchor(0, 0, 1023, 255, (short)colIdx, grow.getRowNum(), (short)colIdx, grow.getRowNum());
        int pictureIdx = this.fHSSFWorkbook.addPicture(bytes, picture_type);
        HSSFPicture picture = apatriarch.createPicture(a, pictureIdx);
        try {
            if (height == 0) {
                Dimension d = picture.getImageDimension();
                grow.setHeightInPoints((float)((short)d.getHeight()));
            } else {
                grow.setHeightInPoints((float)((short)height));
            }
            picture.resize();
            float anchorHeight = a.getAnchorHeightInPoints(sheet);
            grow.setHeightInPoints(anchorHeight);
            picture.resize();
        }
        catch (ArithmeticException e) {
            e.printStackTrace();
        }
        return apatriarch;
    }

    protected boolean close() {
        boolean ret = false;
        if (this.fFileInputStream != null) {
            try {
                this.fFileInputStream.close();
                ret = true;
            }
            catch (IOException e) {
                this.fLogger.warn((Object)"", (Throwable)e);
            }
            this.fFileInputStream = null;
        }
        return ret;
    }

    protected HSSFCell createHSSFCell(HSSFSheet sheet, String col, int row) {
        return this.createHSSFCell(sheet, this.getIndexByColAlphName(col), row);
    }

    protected HSSFCell createHSSFCell(HSSFSheet sheet, short col, int row) {
        HSSFCell ret = null;
        HSSFRow grow = sheet.getRow(row - 1);
        if (grow == null) {
            grow = sheet.createRow(row - 1);
        }
        if ((ret = grow.getCell(col)) == null) {
            ret = grow.createCell(col);
        }
        return ret;
    }

    protected void removeHSSFCellByA1(HSSFSheet sheet, String col, int row) {
        HSSFCell ret = null;
        HSSFRow rows = sheet.getRow(row - 1);
        try {
            ret = rows.getCell(this.getIndexByColAlphName(col));
            if (ret != null) {
                rows.removeCell(ret);
            }
        }
        catch (NullPointerException e) {
            this.fLogger.warn((Object)("Row:[" + row + "/" + col + "]"), (Throwable)e);
            throw e;
        }
    }

    protected void setBlankHSSFCellByA1(HSSFSheet sheet, String col, int row) {
        HSSFCell ret = null;
        HSSFRow rows = sheet.getRow(row - 1);
        try {
            ret = rows.getCell(this.getIndexByColAlphName(col));
            if (ret != null) {
                ret.setCellType(3);
            }
        }
        catch (NullPointerException e) {
            this.fLogger.warn((Object)("Row:[" + row + "/" + col + "]"), (Throwable)e);
            throw e;
        }
    }

    protected HSSFCell getHSSFCellByA1(HSSFSheet sheet, String col, int row) {
        HSSFCell ret = null;
        HSSFRow rows = sheet.getRow(row - 1);
        try {
            ret = rows.getCell(this.getIndexByColAlphName(col));
        }
        catch (NullPointerException e) {
            this.fLogger.warn((Object)("Row:[" + row + "/" + col + "]"), (Throwable)e);
            throw new NullPointerException("Row:[" + row + "/" + col + "]");
        }
        return ret;
    }

    protected HSSFCell getHSSFCellByA1(HSSFSheet sheet, String colRow) {
        Matcher m = this.P_ALPFA_NUM.matcher(colRow);
        if (m.find()) {
            return this.getHSSFCellByA1(sheet, m.group(1), Integer.parseInt(m.group(2)));
        }
        return null;
    }

    protected HSSFSheet copySheet(String makeSheetName, String useSheetName, boolean remove) {
        int index;
        if (remove && (index = this.fHSSFWorkbook.getSheetIndex(makeSheetName)) >= 0) {
            this.fHSSFWorkbook.removeSheetAt(index);
        }
        int cindex = this.fHSSFWorkbook.getSheetIndex(useSheetName);
        HSSFSheet cSheet = this.fHSSFWorkbook.cloneSheet(cindex);
        this.fHSSFWorkbook.setSheetName(this.fHSSFWorkbook.getNumberOfSheets() - 1, makeSheetName);
        return cSheet;
    }

    protected void insertRow(HSSFSheet sheet, int rowNum, int templateRowNum, boolean doRefStyle) {
        sheet.shiftRows(rowNum, sheet.getPhysicalNumberOfRows(), 1, true, false);
        HSSFRow row = sheet.createRow(rowNum - 1);
        HSSFRow templateRow = sheet.getRow(templateRowNum - 1);
        row.setHeight(templateRow.getHeight());
        row.setHeightInPoints(templateRow.getHeightInPoints());
        int i = 0;
        while (i < templateRow.getPhysicalNumberOfCells()) {
            HSSFCell templateCell = templateRow.getCell((short)i);
            HSSFCell cell = row.createCell((short)i);
            if (doRefStyle) {
                cell.setCellStyle(templateCell.getCellStyle());
            } else {
                cell.setCellStyle(this.cloneCellStyle(templateCell.getCellStyle()));
            }
            this.copy(templateCell, cell, rowNum - templateRowNum);
            ++i;
        }
    }

    protected void tuneInExactlyRow(HSSFSheet sheet, int rowNum, int addRowNum) {
        HSSFRow row = sheet.getRow(rowNum - 1);
        int i = 0;
        while (i < row.getPhysicalNumberOfCells()) {
            HSSFCell cell = row.getCell((short)i);
            if (2 == cell.getCellType()) {
                String f = this.getTunedCellFormula(cell, addRowNum);
                HSSFCellStyle style = cell.getCellStyle();
                cell.setCellType(3);
                HSSFCell new_cell = row.createCell((short)i);
                new_cell.setCellStyle(style);
                new_cell.setCellFormula(f);
            }
            ++i;
        }
    }

    private String getTunedCellFormula(HSSFCell cell, int addRowNum) {
        String f = cell.getCellFormula();
        Matcher matcher = fRowNumPattern.matcher(f);
        StringBuffer sb = new StringBuffer();
        while (matcher.find()) {
            int irow = Integer.parseInt(matcher.group(2));
            String newRow = String.valueOf(irow + addRowNum);
            matcher.appendReplacement(sb, String.valueOf(matcher.group(1)) + newRow);
        }
        matcher.appendTail(sb);
        return sb.toString();
    }

    protected void setBackGround(HSSFSheet sheet, short color, int rownum, String beginColumn, String endColumn) {
        int begin = this.getIndexByColAlphName(beginColumn);
        short end = this.getIndexByColAlphName(endColumn);
        HSSFRow row = sheet.getRow(rownum - 1);
        int i = begin;
        while (i <= end) {
            HSSFCellStyle cellstyle = row.getCell((short)i).getCellStyle();
            cellstyle.setFillForegroundColor(color);
            cellstyle.setFillPattern((short)1);
            ++i;
        }
    }

    protected void copy(HSSFCell from, HSSFCell to, int divRow) {
        to.setCellType(from.getCellType());
        switch (from.getCellType()) {
            case 0: {
                to.setCellValue(from.getNumericCellValue());
                break;
            }
            case 1: {
                to.setCellValue(from.getStringCellValue());
                break;
            }
            case 3: {
                break;
            }
            case 4: {
                to.setCellValue(from.getBooleanCellValue());
                break;
            }
            case 2: {
                to.setCellFormula(this.getTunedCellFormula(from, divRow));
                break;
            }
        }
    }

    public static String regReplace(String p, String r, String s) {
        Pattern pattern = Pattern.compile(p);
        Matcher matcher = pattern.matcher(s);
        StringBuffer sb = new StringBuffer();
        while (matcher.find()) {
            matcher.appendReplacement(sb, r);
        }
        matcher.appendTail(sb);
        return sb.toString();
    }

    protected String getCellString(HSSFCell cell) {
        String cellValue = null;
        if (cell == null) {
            return cellValue;
        }
        block0 : switch (cell.getCellType()) {
            case 0: {
                if (PoiDateUtil.isCellDateFormatted(cell)) {
                    cellValue = String.format("%tF %tT", cell.getDateCellValue(), cell.getDateCellValue());
                    break;
                }
                HSSFDataFormatter formatter = new HSSFDataFormatter();
                String retValue = formatter.formatCellValue(cell);
                if (retValue.endsWith("_ ")) {
                    retValue = retValue.substring(0, retValue.length() - 2);
                }
                BigDecimal decimal = new BigDecimal(retValue);
                return decimal.toPlainString();
            }
            case 1: {
                cellValue = cell.getStringCellValue();
                break;
            }
            case 3: {
                cellValue = "";
                break;
            }
            case 4: {
                cellValue = "" + cell.getBooleanCellValue();
                break;
            }
            case 2: {
                cellValue = cell.getCellFormula();
                break;
            }
            case 5: {
                switch (cell.getErrorCellValue()) {
                    case 7: {
                        cellValue = "#DIV/0!";
                        break block0;
                    }
                    case 42: {
                        cellValue = "#N/A";
                        break block0;
                    }
                    case 29: {
                        cellValue = "#NAME?";
                        break block0;
                    }
                    case 0: {
                        cellValue = "#NULL!";
                        break block0;
                    }
                    case 36: {
                        cellValue = "#NUM!";
                        break block0;
                    }
                    case 23: {
                        cellValue = "#REF!";
                        break block0;
                    }
                    case 15: {
                        cellValue = "#VALUE!";
                        break block0;
                    }
                }
                cellValue = "undefined error...";
                break;
            }
            default: {
                cellValue = cell.getStringCellValue();
            }
        }
        return cellValue;
    }

    public boolean save() {
        FileOutputStream outStream = null;
        try {
            File fout = new File(this.fFile.getAbsolutePath());
            outStream = new FileOutputStream(fout);
            this.fHSSFWorkbook.write((OutputStream)outStream);
            return true;
        }
        catch (Exception ex) {
            this.fLogger.warn((Object)"", (Throwable)ex);
            return false;
        }
        finally {
            try {
                if (outStream != null) {
                    outStream.close();
                }
            }
            catch (IOException ex) {
                this.fLogger.warn((Object)"", (Throwable)ex);
            }
        }
    }

    public boolean save(File outFile) {
        FileOutputStream outStream = null;
        try {
            outStream = new FileOutputStream(outFile);
            this.fHSSFWorkbook.write((OutputStream)outStream);
            return true;
        }
        catch (Exception ex) {
            ex.printStackTrace();
            return false;
        }
        finally {
            try {
                if (outStream != null) {
                    outStream.close();
                }
            }
            catch (IOException ex) {
                ex.printStackTrace();
            }
        }
    }

    public void removeSheetAt(int index) {
        this.fHSSFWorkbook.removeSheetAt(index);
    }

    public void renameSheet(int index, String sheetName) {
        this.fHSSFWorkbook.setSheetName(index, sheetName);
    }

    public String cnvSheetName(String targetName) {
        return targetName.replaceAll("[./:*\\[\\]?]", "");
    }

    public void tuneRowHeight(HSSFSheet sheet, int row, int height) {
        HSSFRow row1 = sheet.createRow((int)((short)row));
        row1.setHeightInPoints((float)((short)height));
    }

    public HSSFCellStyle setCellAlignment(short alignment, short verticalAlignment, HSSFCellStyle style) {
        HSSFCellStyle newStyle = style;
        newStyle.setAlignment(alignment);
        newStyle.setVerticalAlignment(verticalAlignment);
        return newStyle;
    }
}

