/*
 * Decompiled with CFR 0.152.
 */
package hiro.yoshioka.gef.tabbedview;

import hiro.yoshioka.gef.tabbedview.ButtonElement;
import hiro.yoshioka.gef.tabbedview.ButtonElementProperties;
import hiro.yoshioka.gef.tabbedview.SizePropertySource;
import org.eclipse.jface.util.Assert;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.swt.custom.CLabel;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.layout.FormAttachment;
import org.eclipse.swt.layout.FormData;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.views.properties.IPropertySource;
import org.eclipse.ui.views.properties.tabbed.AbstractPropertySection;
import org.eclipse.ui.views.properties.tabbed.TabbedPropertySheetPage;

public class SizeSection
extends AbstractPropertySection {
    private Text widthText;
    private Text heightText;
    private ButtonElement buttonElement;
    private ModifyListener listener = new ModifyListener(){

        public void modifyText(ModifyEvent arg0) {
            ButtonElementProperties properties = (ButtonElementProperties)SizeSection.this.buttonElement.getAdapter(IPropertySource.class);
            SizePropertySource sizePropertySource = (SizePropertySource)properties.getPropertyValue("size");
            sizePropertySource.setPropertyValue(SizePropertySource.ID_HEIGHT, SizeSection.this.heightText.getText());
            sizePropertySource.setPropertyValue(SizePropertySource.ID_WIDTH, SizeSection.this.widthText.getText());
        }
    };

    public void setInput(IWorkbenchPart part, ISelection selection) {
        super.setInput(part, selection);
        Assert.isTrue((boolean)(selection instanceof IStructuredSelection));
        Object input = ((IStructuredSelection)selection).getFirstElement();
        Assert.isTrue((boolean)(input instanceof ButtonElement));
        this.buttonElement = (ButtonElement)input;
    }

    public void createControls(Composite parent, TabbedPropertySheetPage tabbedPropertySheetPage) {
        super.createControls(parent, tabbedPropertySheetPage);
        Composite composite = this.getWidgetFactory().createFlatFormComposite(parent);
        CLabel widthLabel = this.getWidgetFactory().createCLabel(composite, "Width:");
        this.widthText = this.getWidgetFactory().createText(composite, "");
        CLabel heightLabel = this.getWidgetFactory().createCLabel(composite, "Height:");
        this.heightText = this.getWidgetFactory().createText(composite, "");
        FormData data = new FormData();
        data.left = new FormAttachment(0, 0);
        data.right = new FormAttachment((Control)this.widthText, -5);
        data.top = new FormAttachment(0, 0);
        widthLabel.setLayoutData((Object)data);
        data = new FormData();
        data.left = new FormAttachment(0, 85);
        data.right = new FormAttachment((Control)heightLabel, -5);
        data.top = new FormAttachment(0, 0);
        this.widthText.setLayoutData((Object)data);
        data = new FormData();
        data.left = new FormAttachment(50, 0);
        data.top = new FormAttachment(0, 0);
        heightLabel.setLayoutData((Object)data);
        data = new FormData();
        data.left = new FormAttachment((Control)heightLabel, 5);
        data.right = new FormAttachment(100, 0);
        data.top = new FormAttachment(0, 0);
        this.heightText.setLayoutData((Object)data);
        this.heightText.addModifyListener(this.listener);
        this.widthText.addModifyListener(this.listener);
    }

    public void refresh() {
        this.heightText.removeModifyListener(this.listener);
        this.widthText.removeModifyListener(this.listener);
        ButtonElementProperties properties = (ButtonElementProperties)this.buttonElement.getAdapter(IPropertySource.class);
        this.widthText.setText(Integer.toString(properties.ptSize.x));
        this.heightText.setText(Integer.toString(properties.ptSize.y));
        this.heightText.addModifyListener(this.listener);
        this.widthText.addModifyListener(this.listener);
    }
}

