/*
 * Decompiled with CFR 0.152.
 */
package hiro.yoshioka.gef.tabbedview;

import hiro.yoshioka.gef.model.Table;
import hiro.yoshioka.gef.tabbedview.AbsBaseSection;
import hiro.yoshioka.wolfdbmanager.Application;
import org.eclipse.draw2d.ColorConstants;
import org.eclipse.jface.text.Document;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.source.CompositeRuler;
import org.eclipse.jface.text.source.IVerticalRuler;
import org.eclipse.jface.text.source.IVerticalRulerColumn;
import org.eclipse.jface.text.source.LineNumberRulerColumn;
import org.eclipse.jface.text.source.SourceViewer;
import org.eclipse.swt.custom.CLabel;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.views.properties.tabbed.TabbedPropertySheetPage;

public class LabelSection
extends AbsBaseSection {
    private Text nameText;
    private Text commentText;
    SourceViewer viewer;
    private ModifyListener listener = new ModifyListener(){

        public void modifyText(ModifyEvent arg0) {
        }
    };

    public void createControls(Composite parent, TabbedPropertySheetPage aTabbedPropertySheetPage) {
        try {
            GridData layoutData = (GridData)parent.getLayoutData();
            layoutData.horizontalAlignment = 4;
            layoutData.verticalAlignment = 4;
            layoutData.grabExcessHorizontalSpace = true;
            layoutData.grabExcessVerticalSpace = true;
            super.createControls(parent, aTabbedPropertySheetPage);
            GridLayout gl = new GridLayout(4, false);
            GridData gd = new GridData(768);
            Composite composite = new Composite(parent, 0);
            composite.setLayout((Layout)gl);
            new CLabel(composite, 0).setText("Name:");
            this.nameText = new Text(composite, 2060);
            this.nameText.setBackground(ColorConstants.white);
            new CLabel(composite, 0).setText("Comment:");
            this.commentText = new Text(composite, 2060);
            this.commentText.setLayoutData((Object)gd);
            this.commentText.setBackground(ColorConstants.white);
            new CLabel(composite, 0).setText("dumpSQL:");
            CompositeRuler ruler = new CompositeRuler();
            ruler.addDecorator(0, (IVerticalRulerColumn)new LineNumberRulerColumn());
            this.viewer = new SourceViewer(composite, (IVerticalRuler)ruler, 2824);
            Document document = new Document();
            this.viewer.setDocument((IDocument)document);
            GridData gdMax = new GridData(1808);
            gdMax.horizontalSpan = 3;
            this.viewer.getControl().setLayoutData((Object)gdMax);
            this.refresh();
        }
        catch (Exception e) {
            this.fLogger.error((Object)e);
        }
    }

    public void refresh() {
        if (this.models != null && this.models.length > 0) {
            if (this.models[0] instanceof Table) {
                Table tbl = (Table)this.models[0];
                this.nameText.setText(tbl.getName());
                this.commentText.setText(tbl.getComment());
                this.viewer.getDocument().set(tbl.getSelectStatement(Application.getActiveSchemaDiagramDatabaseType()));
            } else {
                this.nameText.setText("                       ");
                this.commentText.setText("");
                this.viewer.getDocument().set("");
            }
        }
    }
}

