/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.report.designer.core.model;

import com.ibm.icu.util.ULocale;
import java.io.InputStream;
import java.util.HashMap;
import java.util.Map;
import java.util.WeakHashMap;
import org.eclipse.birt.report.designer.core.CorePlugin;
import org.eclipse.birt.report.designer.core.util.mediator.ReportMediator;
import org.eclipse.birt.report.designer.util.DEUtil;
import org.eclipse.birt.report.model.api.CommandStack;
import org.eclipse.birt.report.model.api.DesignConfig;
import org.eclipse.birt.report.model.api.DesignElementHandle;
import org.eclipse.birt.report.model.api.DesignEngine;
import org.eclipse.birt.report.model.api.DesignFileException;
import org.eclipse.birt.report.model.api.MasterPageHandle;
import org.eclipse.birt.report.model.api.ModuleHandle;
import org.eclipse.birt.report.model.api.ModuleOption;
import org.eclipse.birt.report.model.api.SessionHandle;
import org.eclipse.birt.report.model.api.SimpleMasterPageHandle;
import org.eclipse.birt.report.model.api.SlotHandle;
import org.eclipse.birt.report.model.api.activity.SemanticException;
import org.eclipse.birt.report.model.api.command.ContentException;
import org.eclipse.birt.report.model.api.command.NameException;
import org.eclipse.birt.report.model.api.core.DisposeEvent;
import org.eclipse.birt.report.model.api.core.IDisposeListener;
import org.eclipse.birt.report.model.api.metadata.PropertyValueException;
import org.eclipse.ui.IWindowListener;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.PlatformUI;

public class SessionHandleAdapter {
    public static final int UNKNOWFILE = -1;
    public static final int DESIGNEFILE = 0;
    public static final int LIBRARYFILE = 1;
    public static final int TEMPLATEFILE = 2;
    private int type = 0;
    private IDisposeListener disposeListener = new IDisposeListener(){

        public void moduleDisposed(ModuleHandle targetElement, DisposeEvent ev) {
            ReportMediator media = (ReportMediator)SessionHandleAdapter.this.mediatorMap.get(targetElement);
            if (media != null) {
                media.dispose();
            }
            SessionHandleAdapter.this.mediatorMap.remove(targetElement);
            targetElement.removeDisposeListener((IDisposeListener)this);
        }
    };
    private IWindowListener pageListener = new IWindowListener(){

        public void windowActivated(IWorkbenchWindow window) {
        }

        public void windowClosed(IWorkbenchWindow window) {
            SessionHandleAdapter.this.reportHandleMap.remove(window);
        }

        public void windowDeactivated(IWorkbenchWindow window) {
        }

        public void windowOpened(IWorkbenchWindow window) {
        }
    };
    private Map mediatorMap = new WeakHashMap();
    private Map reportHandleMap = new HashMap();
    private static SessionHandleAdapter sessionAdapter;
    private SessionHandle sessionHandle;
    private ModuleHandle model;

    private SessionHandleAdapter() {
    }

    public int getFileType() {
        return this.type;
    }

    public static SessionHandleAdapter getInstance() {
        if (sessionAdapter == null) {
            sessionAdapter = new SessionHandleAdapter();
        }
        return sessionAdapter;
    }

    public SessionHandle getSessionHandle() {
        if (this.sessionHandle == null) {
            this.sessionHandle = new DesignEngine(new DesignConfig()).newSessionHandle(ULocale.getDefault());
            try {
                if (!CorePlugin.isUseNormalTheme()) {
                    this.sessionHandle.setDefaultValue("color", (Object)DEUtil.getRGBInt(CorePlugin.ReportForeground.getRGB()));
                }
            }
            catch (PropertyValueException propertyValueException) {}
        }
        return this.sessionHandle;
    }

    public ModuleHandle init(String fileName, InputStream input, Map properties) throws DesignFileException {
        ModuleHandle handle = null;
        handle = properties == null ? this.getSessionHandle().openModule(fileName, input) : this.getSessionHandle().openModule(fileName, input, new ModuleOption(properties));
        this.postInit(handle, properties);
        handle.getCommandStack().flush();
        return handle;
    }

    public ModuleHandle init(String fileName, InputStream input) throws DesignFileException {
        return this.init(fileName, input, null);
    }

    private void postInit(ModuleHandle handle, Map properties) {
        String createInfo;
        if (!(properties == null || properties.isEmpty() || (createInfo = handle.getCreatedBy()) != null && createInfo.length() != 0)) {
            try {
                handle.initializeModule(properties);
            }
            catch (SemanticException semanticException) {}
        }
        SimpleMasterPageHandle masterPage = null;
        if (handle.getMasterPages() != null && handle.getMasterPages().getCount() == 0) {
            masterPage = handle.getElementFactory().newSimpleMasterPage(null);
            try {
                handle.getMasterPages().add((DesignElementHandle)masterPage);
            }
            catch (ContentException contentException) {
            }
            catch (NameException nameException) {}
        }
    }

    public ModuleHandle creatReportDesign() {
        return this.getSessionHandle().createDesign();
    }

    public ModuleHandle getReportDesignHandle() {
        if (this.model == null) {
            IWorkbenchWindow activeWindow = PlatformUI.getWorkbench().getActiveWorkbenchWindow();
            this.model = (ModuleHandle)this.reportHandleMap.get(activeWindow);
        }
        return this.model;
    }

    public void setReportDesignHandle(ModuleHandle handle) {
        PlatformUI.getWorkbench().removeWindowListener(this.pageListener);
        IWorkbenchWindow activeWindow = PlatformUI.getWorkbench().getActiveWorkbenchWindow();
        if (handle == null) {
            this.reportHandleMap.remove(activeWindow);
        } else {
            PlatformUI.getWorkbench().addWindowListener(this.pageListener);
        }
        if (activeWindow != null) {
            this.reportHandleMap.put(activeWindow, handle);
        }
        this.model = handle;
    }

    public CommandStack getCommandStack() {
        if (this.getReportDesignHandle() != null) {
            return this.getReportDesignHandle().getCommandStack();
        }
        return null;
    }

    public CommandStack getCommandStack(ModuleHandle handle) {
        if (handle != null) {
            return handle.getCommandStack();
        }
        return null;
    }

    public MasterPageHandle getMasterPageHandle() {
        return this.getFirstMasterPageHandle(this.getReportDesignHandle());
    }

    public MasterPageHandle getMasterPageHandle(ModuleHandle handle) {
        return this.getFirstMasterPageHandle(handle);
    }

    public MasterPageHandle getFirstMasterPageHandle(ModuleHandle handle) {
        if (handle == null) {
            return null;
        }
        SlotHandle slotHandle = handle.getMasterPages();
        if (slotHandle.getCount() > 0) {
            return (MasterPageHandle)slotHandle.getContents().get(0);
        }
        return null;
    }

    public ReportMediator getMediator(ModuleHandle handle) {
        return this.getMediator(handle, true);
    }

    public ReportMediator getMediator(ModuleHandle handle, boolean force) {
        ReportMediator mediator;
        if (handle != null) {
            handle.addDisposeListener(this.disposeListener);
        }
        if ((mediator = (ReportMediator)this.mediatorMap.get(handle)) == null && force) {
            mediator = new ReportMediator();
            this.mediatorMap.put(handle, mediator);
        }
        return mediator;
    }

    public ReportMediator getMediator() {
        return this.getMediator(this.getReportDesignHandle());
    }

    public void resetReportDesign(Object oldObj, Object newObj) {
        ReportMediator mediator = (ReportMediator)this.mediatorMap.get(oldObj);
        if (mediator == null) {
            return;
        }
        this.mediatorMap.remove(oldObj);
        this.mediatorMap.put(newObj, mediator);
    }

    public void clear(ModuleHandle handle) {
        this.mediatorMap.remove(handle);
        if (handle == this.getReportDesignHandle()) {
            this.setReportDesignHandle(null);
            this.getSessionHandle().setResourceFolder(null);
        }
    }
}

