/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.report.designer.internal.ui.views.attributes.provider;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.birt.report.designer.internal.ui.views.attributes.provider.SimpleComboPropertyDescriptorProvider;
import org.eclipse.birt.report.designer.nls.Messages;
import org.eclipse.birt.report.designer.ui.views.attributes.providers.ChoiceSetFactory;
import org.eclipse.birt.report.designer.util.DEUtil;
import org.eclipse.birt.report.model.api.DesignEngine;
import org.eclipse.birt.report.model.api.ReportItemHandle;
import org.eclipse.birt.report.model.api.TOCHandle;
import org.eclipse.birt.report.model.api.activity.SemanticException;
import org.eclipse.birt.report.model.api.metadata.IPredefinedStyle;

public class TocStylePropertyDescriptiorProvider
extends SimpleComboPropertyDescriptorProvider {
    protected TOCHandle tocHandle;

    public TocStylePropertyDescriptiorProvider(String property, String element) {
        super(property, element);
    }

    public String getDisplayName() {
        return Messages.getString((String)"Element.Toc.Sytle");
    }

    public TOCHandle getTocHandle() {
        return this.tocHandle;
    }

    public String[] getItems() {
        String[] items = null;
        items = ChoiceSetFactory.getStyles();
        items = this.filterPreStyles(items);
        return items;
    }

    private String[] filterPreStyles(String[] items) {
        List preStyles = DesignEngine.getMetaDataDictionary().getPredefinedStyles();
        ArrayList<String> preStyleNames = new ArrayList<String>();
        int i = 0;
        while (i < preStyles.size()) {
            preStyleNames.add(((IPredefinedStyle)preStyles.get(i)).getName());
            ++i;
        }
        ArrayList<String> sytleNames = new ArrayList<String>();
        int i2 = 0;
        while (i2 < items.length) {
            if (preStyleNames.indexOf(items[i2]) == -1) {
                sytleNames.add(items[i2]);
            }
            ++i2;
        }
        return sytleNames.toArray(new String[0]);
    }

    public Object load() {
        String value = null;
        if (this.input instanceof ReportItemHandle) {
            this.tocHandle = ((ReportItemHandle)this.input).getTOC();
        } else if (this.input instanceof List) {
            this.tocHandle = ((ReportItemHandle)DEUtil.getGroupElementHandle((List)((List)this.input)).getElements().get(0)).getTOC();
        }
        if (this.tocHandle != null) {
            value = this.tocHandle.getStyleName();
        }
        return value == null ? "" : value;
    }

    public void save(Object value) throws SemanticException {
        if (this.tocHandle == null) {
            if (this.input instanceof ReportItemHandle) {
                this.tocHandle = ((ReportItemHandle)this.input).getTOC();
            } else if (this.input instanceof List) {
                this.tocHandle = ((ReportItemHandle)DEUtil.getGroupElementHandle((List)((List)this.input)).getElements().get(0)).getTOC();
            }
        }
        if (this.tocHandle != null) {
            this.tocHandle.setStyleName((String)value);
        }
    }

    public void setInput(Object input) {
        super.setInput(input);
        if (this.tocHandle == null) {
            if (input instanceof ReportItemHandle) {
                this.tocHandle = ((ReportItemHandle)input).getTOC();
            } else if (input instanceof List) {
                this.tocHandle = ((ReportItemHandle)DEUtil.getGroupElementHandle((List)((List)input)).getElements().get(0)).getTOC();
            }
        }
    }

    public boolean isSpecialProperty() {
        return true;
    }
}

