/*
 * Decompiled with CFR 0.152.
 */
package hiro.yoshioka.csveditor.dialog;

import hiro.yoshioka.csveditor.Messages;
import hiro.yoshioka.util.CSVUtil;
import hiro.yoshioka.util.LineSeparatorEnum;
import hiro.yoshioka.util.StringUtil;
import jp.sf.orangesignal.csv.CsvConfig;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.forms.widgets.FormToolkit;
import org.eclipse.ui.forms.widgets.ScrolledForm;
import org.eclipse.ui.forms.widgets.Section;

public class CSVConfigDialog
extends Dialog {
    char[] COMBO_CODE = new char[]{StringUtil.SINGLE_QUOTE_CHAR, StringUtil.DOUBLE_QUOTE_CHAR, StringUtil.TAB_CHAR, ',', ' ', StringUtil.YEN_CHAR};
    String[] COMBO_TEXTS = new String[]{Messages.CSVConfigDialog_SingleQuotation, Messages.CSVConfigDialog_DoubleQuotation, Messages.CSVConfigDialog_TAB, Messages.CSVConfigDialog_COMMA, Messages.CSVConfigDialog_SPACE, Messages.CSVConfigDialog_YEN_MARK};
    String[][] COMBO_NEW_LINE_TEXTS;
    MyCsvConfig cfg;
    Combo escapeCombo;
    Combo breakStringCombo;
    Combo lineSeparatorCombo;
    Combo quoteCombo;
    Combo separetorCombo;

    public CSVConfigDialog(Shell shell, CsvConfig initial) {
        super(shell);
        String[][] stringArrayArray = new String[2][];
        String[] stringArray = new String[4];
        stringArray[0] = LineSeparatorEnum.CR.getLineSeparator();
        stringArray[1] = LineSeparatorEnum.LF.getLineSeparator();
        stringArray[2] = LineSeparatorEnum.CRLF.getLineSeparator();
        stringArrayArray[0] = stringArray;
        stringArrayArray[1] = new String[]{Messages.CSVConfigDialog_CR, Messages.CSVConfigDialog_LF, Messages.CSVConfigDialog_CRLF, Messages.CSVConfigDialog_EMPTY_STRING, Messages.CSVConfigDialog_DO_NOTHING};
        this.COMBO_NEW_LINE_TEXTS = stringArrayArray;
        this.cfg = initial == null ? new MyCsvConfig(CSVUtil.QUOTE_DOUBLE_QUOTE_SEPARATE_TAB) : new MyCsvConfig(initial);
    }

    public CSVConfigDialog(Shell shell, MyCsvConfig initial) {
        super(shell);
        String[][] stringArrayArray = new String[2][];
        String[] stringArray = new String[4];
        stringArray[0] = LineSeparatorEnum.CR.getLineSeparator();
        stringArray[1] = LineSeparatorEnum.LF.getLineSeparator();
        stringArray[2] = LineSeparatorEnum.CRLF.getLineSeparator();
        stringArrayArray[0] = stringArray;
        stringArrayArray[1] = new String[]{Messages.CSVConfigDialog_CR, Messages.CSVConfigDialog_LF, Messages.CSVConfigDialog_CRLF, Messages.CSVConfigDialog_EMPTY_STRING, Messages.CSVConfigDialog_DO_NOTHING};
        this.COMBO_NEW_LINE_TEXTS = stringArrayArray;
        this.cfg = initial == null ? new MyCsvConfig(CSVUtil.QUOTE_DOUBLE_QUOTE_SEPARATE_TAB) : initial;
    }

    protected boolean isResizable() {
        return true;
    }

    protected Control createDialogArea(Composite parent) {
        FormToolkit toolkit = new FormToolkit(parent.getDisplay());
        ScrolledForm root = toolkit.createScrolledForm(parent);
        root.setText(Messages.CSVConfigDialog_LbGenerator);
        root.setLayout((Layout)new GridLayout());
        root.setLayoutData((Object)new GridData(1808));
        root.getBody().setLayout((Layout)new GridLayout());
        root.getBody().setLayoutData((Object)new GridData(1808));
        Section section2 = toolkit.createSection(root.getBody(), 320);
        section2.setText(Messages.CSVConfigDialog_GenerateRecordsCounter);
        section2.setLayoutData((Object)new GridData(768));
        Composite inner2 = toolkit.createComposite((Composite)section2);
        section2.setClient((Control)inner2);
        inner2.setLayout((Layout)new GridLayout(2, false));
        try {
            toolkit.createLabel(inner2, Messages.CSVConfigDialog_ColumnRow, 2048);
            final Button bt = toolkit.createButton(inner2, Messages.CSVConfigDialog_IncludeRowMessage, 32);
            bt.addSelectionListener((SelectionListener)new SelectionAdapter(){

                public void widgetSelected(SelectionEvent e) {
                    CSVConfigDialog.this.cfg.withRowColumn = bt.getSelection();
                }
            });
            bt.setSelection(this.cfg.withRowColumn);
            toolkit.createLabel(inner2, Messages.CSVConfigDialog_ENCODING, 2048);
            final Combo encodingCombo = new Combo(inner2, 4);
            encodingCombo.setItems(StringUtil.ENCODINGS);
            boolean doAddDefEncode = true;
            int i = 0;
            while (i < StringUtil.ENCODINGS.length) {
                if (StringUtil.ENCODINGS[i].equalsIgnoreCase(this.cfg.getEncoding())) {
                    encodingCombo.select(i);
                    doAddDefEncode = false;
                }
                ++i;
            }
            if (doAddDefEncode) {
                encodingCombo.add(this.cfg.getEncoding(), 0);
                encodingCombo.select(0);
            }
            encodingCombo.setLayoutData((Object)new GridData(768));
            encodingCombo.addSelectionListener((SelectionListener)new SelectionAdapter(){

                public void widgetSelected(SelectionEvent e) {
                    CSVConfigDialog.this.cfg.encoding = encodingCombo.getText();
                }
            });
            this.breakStringCombo = this.createComboNewLine(toolkit, Messages.CSVConfigDialog_breakString, this.cfg.getBreakString(), inner2);
            this.escapeCombo = this.createCombo(toolkit, Messages.CSVConfigDialog_ESCAPE, String.valueOf(this.cfg.getEscape()), inner2);
            this.lineSeparatorCombo = this.createComboNewLine(toolkit, Messages.CSVConfigDialog_LINE_SEPARATOR, this.cfg.getLineSeparator(), inner2);
            this.quoteCombo = this.createCombo(toolkit, Messages.CSVConfigDialog_Quote, String.valueOf(this.cfg.getQuote()), inner2);
            this.separetorCombo = this.createCombo(toolkit, Messages.CSVConfigDialog_SEPARATOR, String.valueOf(this.cfg.getSeparator()), inner2);
            Section section3 = toolkit.createSection(root.getBody(), 320);
            section3.setText("CSV Input Config");
            section3.setLayoutData((Object)new GridData(768));
            Composite inner3 = toolkit.createComposite((Composite)section3);
            section3.setClient((Control)inner3);
            inner3.setLayout((Layout)new GridLayout(3, false));
            toolkit.createLabel(inner3, "Ignore Row Column", 2048);
            final Button btFc = toolkit.createButton(inner3, "Ignore", 32);
            btFc.addSelectionListener((SelectionListener)new SelectionAdapter(){

                public void widgetSelected(SelectionEvent e) {
                    CSVConfigDialog.this.cfg.ignoreFirstRowColumn = btFc.getSelection();
                }
            });
            btFc.setSelection(this.cfg.ignoreFirstRowColumn);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return root;
    }

    private Combo createCombo(FormToolkit toolkit, String labelTitle, String value, Composite inner2) {
        toolkit.createLabel(inner2, labelTitle, 2048);
        Combo c = new Combo(inner2, 12);
        c.setItems(this.COMBO_TEXTS);
        int i = 0;
        while (i < this.COMBO_TEXTS.length) {
            if (String.valueOf(this.COMBO_CODE[i]).equals(value)) {
                c.select(i);
            }
            ++i;
        }
        c.setLayoutData((Object)new GridData(768));
        c.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                if (e.widget == CSVConfigDialog.this.escapeCombo) {
                    CSVConfigDialog.this.cfg.setEscape(CSVConfigDialog.this.COMBO_CODE[CSVConfigDialog.this.escapeCombo.getSelectionIndex()]);
                } else if (e.widget == CSVConfigDialog.this.quoteCombo) {
                    CSVConfigDialog.this.cfg.setQuote(CSVConfigDialog.this.COMBO_CODE[CSVConfigDialog.this.quoteCombo.getSelectionIndex()]);
                } else if (e.widget == CSVConfigDialog.this.separetorCombo) {
                    CSVConfigDialog.this.cfg.setSeparator(CSVConfigDialog.this.COMBO_CODE[CSVConfigDialog.this.separetorCombo.getSelectionIndex()]);
                }
            }
        });
        return c;
    }

    private Combo createComboNewLine(FormToolkit toolkit, String labelTitle, String value, Composite inner2) {
        toolkit.createLabel(inner2, labelTitle, 2048);
        Combo c = new Combo(inner2, 12);
        c.setItems(this.COMBO_NEW_LINE_TEXTS[1]);
        if (value == null) {
            c.select(this.COMBO_NEW_LINE_TEXTS[0].length - 1);
        } else {
            int i = 0;
            while (i < this.COMBO_NEW_LINE_TEXTS[0].length - 1) {
                if (this.COMBO_NEW_LINE_TEXTS[0][i].equals(value)) {
                    c.select(i);
                }
                ++i;
            }
        }
        c.setLayoutData((Object)new GridData(768));
        c.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                if (e.widget == CSVConfigDialog.this.breakStringCombo) {
                    CSVConfigDialog.this.cfg.setBreakString(CSVConfigDialog.this.COMBO_NEW_LINE_TEXTS[0][CSVConfigDialog.this.breakStringCombo.getSelectionIndex()]);
                } else if (e.widget == CSVConfigDialog.this.lineSeparatorCombo) {
                    CSVConfigDialog.this.cfg.setLineSeparator(CSVConfigDialog.this.COMBO_NEW_LINE_TEXTS[0][CSVConfigDialog.this.lineSeparatorCombo.getSelectionIndex()]);
                }
            }
        });
        return c;
    }

    public MyCsvConfig getConfig() {
        return this.cfg;
    }

    public String getEncoding() {
        return this.cfg.getEncoding();
    }

    public static class MyCsvConfig
    extends CsvConfig
    implements Cloneable {
        protected boolean ignoreFirstRowColumn = true;
        private boolean withRowColumn = false;
        private String encoding = StringUtil.DEFAULT_ENCODING;

        public MyCsvConfig(CsvConfig cfg) {
            super(cfg.getSeparator(), cfg.getQuote(), cfg.getEscape(), cfg.isQuoteDisabled(), cfg.isEscapeDisabled());
            this.setIgnoreEmptyLines(cfg.isIgnoreEmptyLines());
            this.setIgnoreCaseNullString(cfg.isIgnoreCaseNullString());
            this.setIgnoreLeadingWhitespaces(cfg.isIgnoreLeadingWhitespaces());
            this.setIgnoreTrailingWhitespaces(cfg.isIgnoreTrailingWhitespaces());
        }

        public MyCsvConfig() {
        }

        public void setEncoding(String encoding) {
            this.encoding = encoding;
        }

        public boolean isWithRowColumn() {
            return this.withRowColumn;
        }

        public String getEncoding() {
            return this.encoding;
        }

        public boolean isIgnoreFirstRowColumn() {
            return this.ignoreFirstRowColumn;
        }
    }
}

