/*
 * Decompiled with CFR 0.152.
 */
package hiro.yoshioka.csveditor;

import hiro.yoshioka.csveditor.CSVRDHView;
import hiro.yoshioka.csveditor.jsAction.JsAction;
import hiro.yoshioka.wolfcsveditor.Activator;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.action.IToolBarManager;
import org.eclipse.jface.action.MenuManager;
import org.eclipse.jface.action.Separator;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.ui.IActionBars;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.actions.ActionFactory;
import org.eclipse.ui.ide.IDEActionFactory;
import org.eclipse.ui.part.MultiPageEditorActionBarContributor;
import org.eclipse.ui.texteditor.ITextEditor;
import org.eclipse.ui.texteditor.ITextEditorActionConstants;

public class CSVEditorContributor
extends MultiPageEditorActionBarContributor
implements ISelectionChangedListener {
    private IEditorPart activeEditorPart;
    private CSVRDHView csvViewPart;
    private Action adjustHeaderAction;
    private Action adjustDatumnAction;
    private Action adjustAreaAction;
    private Action configAction;
    private Action delColumnAction;
    private Action addColumnAction;
    private Action delRowAction;
    private Action addRowAction;
    private JsAction jsAction;

    public CSVEditorContributor() {
        this.createActions();
    }

    protected IAction getAction(ITextEditor editor, String actionID) {
        return editor == null ? null : editor.getAction(actionID);
    }

    public void setActiveEditor(IEditorPart part) {
        super.setActiveEditor(part);
        System.out.println("setActiveEditor=" + part);
    }

    public void setActivePage(IEditorPart part) {
        System.out.println("setActivePage=" + part);
        if (this.activeEditorPart == part) {
            return;
        }
        this.activeEditorPart = part;
        boolean enabled = false;
        System.out.println("enabled=" + enabled);
        try {
            if (!(part instanceof ITextEditor)) {
                if (this.csvViewPart == null) {
                    this.csvViewPart = (CSVRDHView)part;
                    this.csvViewPart.fViewer.addSelectionChangedListener((ISelectionChangedListener)this);
                    this.jsAction.setViewPart(this.csvViewPart);
                }
                enabled = true;
            }
            this.adjustHeaderAction.setEnabled(enabled);
            this.adjustDatumnAction.setEnabled(enabled);
            this.adjustAreaAction.setEnabled(enabled);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        IActionBars actionBars = this.getActionBars();
        if (actionBars != null) {
            if (part instanceof ITextEditor) {
                ITextEditor editor = (ITextEditor)part;
                actionBars.setGlobalActionHandler(ActionFactory.DELETE.getId(), this.getAction(editor, ITextEditorActionConstants.DELETE));
                actionBars.setGlobalActionHandler(ActionFactory.UNDO.getId(), this.getAction(editor, ITextEditorActionConstants.UNDO));
                actionBars.setGlobalActionHandler(ActionFactory.REDO.getId(), this.getAction(editor, ITextEditorActionConstants.REDO));
                actionBars.setGlobalActionHandler(ActionFactory.CUT.getId(), this.getAction(editor, ITextEditorActionConstants.CUT));
                actionBars.setGlobalActionHandler(ActionFactory.COPY.getId(), this.getAction(editor, ITextEditorActionConstants.COPY));
                actionBars.setGlobalActionHandler(ActionFactory.PASTE.getId(), this.getAction(editor, ITextEditorActionConstants.PASTE));
                actionBars.setGlobalActionHandler(ActionFactory.SELECT_ALL.getId(), this.getAction(editor, ITextEditorActionConstants.SELECT_ALL));
                actionBars.setGlobalActionHandler(ActionFactory.FIND.getId(), this.getAction(editor, ITextEditorActionConstants.FIND));
                actionBars.setGlobalActionHandler(IDEActionFactory.BOOKMARK.getId(), this.getAction(editor, IDEActionFactory.BOOKMARK.getId()));
            }
            actionBars.updateActionBars();
        }
    }

    private void createActions() {
        try {
            this.adjustHeaderAction = new Action(){

                public void run() {
                    CSVEditorContributor.this.csvViewPart.adjustHeader();
                }
            };
            this.adjustHeaderAction.setText("Adjust Header Width");
            this.adjustHeaderAction.setToolTipText("Adjust Header Width");
            this.adjustHeaderAction.setImageDescriptor(Activator.getImageDescriptor("icons/action/50_colom.gif"));
            this.adjustDatumnAction = new Action(){

                public void run() {
                    CSVEditorContributor.this.csvViewPart.adjustDatum();
                }
            };
            this.adjustDatumnAction.setText("Adjust Datumn Width");
            this.adjustDatumnAction.setToolTipText("Adjust Datumn Width");
            this.adjustDatumnAction.setImageDescriptor(Activator.getImageDescriptor("icons/action/51_long.gif"));
            this.adjustAreaAction = new Action(){

                public void run() {
                    CSVEditorContributor.this.csvViewPart.adjustArea();
                }
            };
            this.adjustAreaAction.setText("Adjust Area Width");
            this.adjustAreaAction.setToolTipText("Adjust Area Width");
            this.adjustAreaAction.setImageDescriptor(Activator.getImageDescriptor("icons/action/15Index.gif"));
            this.configAction = new Action(){

                public void run() {
                    CSVEditorContributor.this.csvViewPart.openConfigDialog();
                }
            };
            this.configAction.setText("CSV File Config");
            this.configAction.setToolTipText("CSV File Config");
            this.configAction.setImageDescriptor(Activator.getImageDescriptor("icons/misc/asterisk.gif"));
            this.delColumnAction = new Action(){

                public void run() {
                    CSVEditorContributor.this.csvViewPart.deleteColumn();
                }
            };
            this.delColumnAction.setText("Delete Column");
            this.delColumnAction.setToolTipText("Delete Column");
            this.delColumnAction.setImageDescriptor(Activator.getImageDescriptor("icons/action/45_hide_table_column.png"));
            this.delColumnAction.setEnabled(false);
            this.addColumnAction = new Action(){

                public void run() {
                    CSVEditorContributor.this.csvViewPart.addColumn();
                }
            };
            this.addColumnAction.setText("Add Column");
            this.addColumnAction.setToolTipText("Add Column");
            this.addColumnAction.setImageDescriptor(Activator.getImageDescriptor("icons/action/45_show_table_column.png"));
            this.addColumnAction.setEnabled(false);
            this.delRowAction = new Action(){

                public void run() {
                    CSVEditorContributor.this.csvViewPart.deleteRow();
                }
            };
            this.delRowAction.setText("Delete Row");
            this.delRowAction.setToolTipText("Delete Row");
            this.delRowAction.setImageDescriptor(Activator.getImageDescriptor("icons/action/45_hide_table_row.png"));
            this.delRowAction.setEnabled(false);
            this.addRowAction = new Action(){

                public void run() {
                    CSVEditorContributor.this.csvViewPart.addRow();
                }
            };
            this.addRowAction.setText("Add Row");
            this.addRowAction.setToolTipText("Add Row");
            this.addRowAction.setImageDescriptor(Activator.getImageDescriptor("icons/action/45_show_table_row.png"));
            this.jsAction = new JsAction(this.csvViewPart);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public void contributeToMenu(IMenuManager manager) {
        MenuManager menu = new MenuManager("CSV Editor &Menu");
        manager.prependToGroup("additions", (IContributionItem)menu);
        menu.add((IAction)this.adjustHeaderAction);
        menu.add((IAction)this.adjustDatumnAction);
        menu.add((IAction)this.adjustAreaAction);
        menu.add((IContributionItem)new Separator());
        menu.add((IAction)this.configAction);
        menu.add((IContributionItem)new Separator());
        menu.add((IAction)this.delColumnAction);
        menu.add((IAction)this.addColumnAction);
        menu.add((IAction)this.delRowAction);
        menu.add((IAction)this.addRowAction);
        menu.add((IContributionItem)new Separator());
        menu.add((IAction)this.jsAction);
    }

    public void contributeToToolBar(IToolBarManager manager) {
        manager.add((IContributionItem)new Separator());
        manager.add((IAction)this.adjustHeaderAction);
        manager.add((IAction)this.adjustDatumnAction);
        manager.add((IAction)this.adjustAreaAction);
        manager.add((IContributionItem)new Separator());
        manager.add((IAction)this.configAction);
        manager.add((IContributionItem)new Separator());
        manager.add((IAction)this.delColumnAction);
        manager.add((IAction)this.addColumnAction);
        manager.add((IAction)this.delRowAction);
        manager.add((IAction)this.addRowAction);
        manager.add((IContributionItem)new Separator());
        manager.add((IAction)this.jsAction);
    }

    public void selectionChanged(SelectionChangedEvent event) {
        boolean columnEnabled = this.csvViewPart.fViewer.getLastSelectedColumn() >= 0;
        this.addColumnAction.setEnabled(columnEnabled);
        this.delColumnAction.setEnabled(columnEnabled);
        boolean rowEnabled = this.csvViewPart.fViewer.getLastSelectedRow() >= 0;
        this.delRowAction.setEnabled(rowEnabled);
    }
}

