/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.report.engine.layout.pdf.hyphen;

import com.ibm.icu.text.BreakIterator;
import java.util.Locale;
import org.eclipse.birt.report.engine.layout.pdf.hyphen.IWordRecognizer;
import org.eclipse.birt.report.engine.layout.pdf.hyphen.Word;

public class ICUWordRecognizer
implements IWordRecognizer {
    protected BreakIterator wordBreaker = null;
    protected Word lastWord = null;
    protected Word currentWord = null;
    protected String text;
    int end;

    public ICUWordRecognizer(String text, Locale locale) {
        this.wordBreaker = locale != null ? BreakIterator.getWordInstance((Locale)locale) : BreakIterator.getWordInstance((Locale)Locale.getDefault());
        this.text = text;
        this.wordBreaker.setText(text);
    }

    public int getLastWordEnd() {
        return this.wordBreaker.current() == 0 ? 0 : this.wordBreaker.current() - 1;
    }

    public Word getNextWord() {
        int start = this.wordBreaker.current();
        this.end = this.wordBreaker.next();
        if (this.end != -1) {
            return new Word(this.text, start, this.end);
        }
        return null;
    }

    public boolean hasWord() {
        return this.getLastWordEnd() != this.text.length();
    }
}

