/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.report.engine.layout.pdf;

import org.eclipse.birt.core.exception.BirtException;
import org.eclipse.birt.report.engine.content.IContent;
import org.eclipse.birt.report.engine.content.IStyle;
import org.eclipse.birt.report.engine.extension.IReportItemExecutor;
import org.eclipse.birt.report.engine.layout.ILayoutContext;
import org.eclipse.birt.report.engine.layout.IStackingLayoutManager;
import org.eclipse.birt.report.engine.layout.area.impl.AbstractArea;
import org.eclipse.birt.report.engine.layout.area.impl.ContainerArea;
import org.eclipse.birt.report.engine.layout.pdf.PDFAbstractLM;
import org.eclipse.birt.report.engine.layout.pdf.PDFLayoutEngineContext;
import org.eclipse.birt.report.engine.layout.pdf.util.PropertyUtil;

public abstract class PDFStackingLM
extends PDFAbstractLM
implements IStackingLayoutManager,
ILayoutContext {
    protected int maxWidth = -1;
    protected int maxHeight = -1;
    protected int maxAvaHeight = 0;
    protected int maxAvaWidth = 0;
    protected int currentIP = 0;
    protected int currentBP = 0;
    protected int offsetX = 0;
    protected int offsetY = 0;
    protected ContainerArea root;
    protected PDFAbstractLM child;
    protected int minHeight = 0;
    protected int minWidth = 0;
    protected boolean pageBreakAvoid = this.pageBreakInsideAvoid() || this.pageBreakAfterAvoid();

    public int getMaxAvaHeight() {
        return this.maxAvaHeight;
    }

    public int getCurrentMaxContentWidth() {
        return this.maxAvaWidth - this.currentIP;
    }

    public int getCurrentMaxContentHeight() {
        return this.maxAvaHeight - this.currentBP;
    }

    public int getCurrentIP() {
        return this.currentIP;
    }

    public int getCurrentBP() {
        return this.currentBP;
    }

    public void setCurrentBP(int bp) {
        this.currentBP = bp;
    }

    public void setCurrentIP(int ip) {
        this.currentIP = ip;
    }

    public int getOffsetX() {
        return this.offsetX;
    }

    public void setOffsetX(int x) {
        this.offsetX = x;
    }

    public int getOffsetY() {
        return this.offsetY;
    }

    public void setOffsetY(int y) {
        this.offsetY = y;
    }

    public PDFStackingLM(PDFLayoutEngineContext context, PDFStackingLM parent, IContent content, IReportItemExecutor executor) {
        super(context, parent, content, executor);
    }

    public boolean isPageBreakAvoidInside() {
        if (this.parent == null) {
            return false;
        }
        if (this.parent.pageBreakAvoid) {
            return true;
        }
        return this.parent.isPageBreakAvoidInside();
    }

    protected boolean layoutChildren() throws BirtException {
        this.initialize();
        boolean hasNextPage = false;
        hasNextPage = this.traverseChildren();
        if (!hasNextPage) {
            this.isLast = true;
            this.clearCache();
        } else if (!this.context.isAutoPageBreak()) {
            this.clearCache();
        }
        if (!this.isRootEmpty()) {
            this.closeLayout();
            hasNextPage = !this.submitRoot() || hasNextPage;
        }
        return hasNextPage;
    }

    protected boolean clearCache() {
        return true;
    }

    protected boolean isRootEmpty() {
        return this.root == null || this.root.getChildrenCount() <= 0;
    }

    protected abstract boolean traverseChildren() throws BirtException;

    protected boolean submitRoot() {
        if (this.root == null) {
            return true;
        }
        boolean success = true;
        if (this.parent != null) {
            success = this.parent.addArea(this.root, false, this.isKeepWithNext());
            if (success) {
                this.isFirst = false;
                this.root = null;
            }
        } else if (this.content != null) {
            this.content.setExtension(1, this.root);
            this.root = null;
        }
        return success;
    }

    protected boolean isKeepWithNext() {
        return this.isLast && this.isFirst && this.pageBreakAfterAvoid();
    }

    protected abstract void initialize() throws BirtException;

    protected abstract void closeLayout();

    protected abstract void createRoot();

    protected int getIntrisicHeight() {
        if (this.root != null) {
            return this.root.getIntrisicHeight();
        }
        return 0;
    }

    public boolean isPageEmpty() {
        if (!this.isRootEmpty()) {
            return false;
        }
        if (this.parent != null) {
            return this.parent.isPageEmpty();
        }
        return true;
    }

    public int getLineHeight() {
        if (this.content != null) {
            IStyle contentStyle = this.content.getComputedStyle();
            return PropertyUtil.getLineHeight(contentStyle.getLineHeight());
        }
        return 0;
    }

    public abstract void submit(AbstractArea var1);
}

