/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.report.engine.executor.template;

import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.eclipse.birt.core.format.NumberFormatter;
import org.eclipse.birt.core.template.TextTemplate;
import org.eclipse.birt.report.engine.api.EngineConfig;
import org.eclipse.birt.report.engine.api.EngineException;
import org.eclipse.birt.report.engine.api.impl.ReportEngine;
import org.eclipse.birt.report.engine.executor.ExecutionContext;
import org.eclipse.birt.report.engine.ir.Expression;
import org.eclipse.birt.report.engine.util.ExpressionUtil;
import org.eclipse.birt.report.engine.util.FileUtil;
import org.eclipse.birt.report.model.api.ModuleHandle;
import org.eclipse.birt.report.model.api.elements.structures.EmbeddedImage;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TemplateExecutor
implements TextTemplate.Visitor {
    protected static Logger logger = Logger.getLogger(TemplateExecutor.class.getName());
    protected StringBuffer buffer;
    protected HashMap<String, Object> values;
    protected ExecutionContext context;
    protected File imageFolder;
    protected HashMap imageCaches = new HashMap();

    public TemplateExecutor(ExecutionContext context) {
        EngineConfig config;
        ReportEngine engine;
        this.context = context;
        String tmpDir = null;
        if (context != null && (engine = context.getEngine()) != null && (config = engine.getConfig()) != null) {
            tmpDir = config.getTempDir();
        }
        if (tmpDir == null) {
            tmpDir = FileUtil.getJavaTmpDir();
        }
        if (tmpDir == null) {
            tmpDir = ".";
        }
        this.imageFolder = new File(tmpDir);
    }

    public String execute(TextTemplate template, HashMap<String, Object> values) {
        this.buffer = new StringBuffer();
        this.values = values;
        if (template == null) {
            return "";
        }
        ArrayList nodes = template.getNodes();
        for (TextTemplate.Node node : nodes) {
            node.accept((TextTemplate.Visitor)this, null);
        }
        return this.buffer.toString();
    }

    public Object visitNode(TextTemplate.Node node, Object value) {
        return value;
    }

    public Object visitText(TextTemplate.TextNode node, Object value) {
        this.buffer.append(node.getContent());
        return value;
    }

    public Object visitValue(TextTemplate.ValueNode node, Object value) {
        String expression = node.getValue();
        if (expression != null) {
            if ("pageNumber".equals(expression = expression.trim()) || "totalPage".equals(expression)) {
                Object result = ExpressionUtil.evaluate(this.context, Expression.newScript(expression));
                String text = this.formatValue(node, result);
                this.buffer.append(text);
            } else {
                Object result = null;
                if (this.values != null) {
                    String keyExpr = node.getValue();
                    if (keyExpr != null) {
                        keyExpr = keyExpr.trim();
                    }
                    result = this.values.get(keyExpr);
                }
                String text = this.formatValue(node, result);
                this.buffer.append(text);
            }
        }
        return value;
    }

    public Object visitExpressionValue(TextTemplate.ExpressionValueNode node, Object value) {
        String expression = node.getValue();
        if (expression != null && (expression = expression.trim()).length() > 0) {
            Object result = ExpressionUtil.evaluate(this.context, Expression.newScript(expression));
            String text = this.formatValue((TextTemplate.ValueNode)node, result);
            this.buffer.append(text);
        }
        return value;
    }

    private String formatValue(TextTemplate.ValueNode node, Object value) {
        String keyExpr;
        Object formatValue;
        String text = "";
        String format = node.getFormat();
        String formatExpression = node.getFormatExpression();
        if (format == null && formatExpression != null && (formatValue = this.values.get(keyExpr = formatExpression.trim())) != null) {
            format = formatValue.toString();
        }
        if ("html".equalsIgnoreCase(format)) {
            if (value != null) {
                text = value.toString();
            }
        } else {
            if (value != null) {
                NumberFormatter fmt;
                if (value instanceof Number) {
                    fmt = this.context.getNumberFormatter(format);
                    text = fmt.format((Number)value);
                } else if (value instanceof String) {
                    fmt = this.context.getStringFormatter(format);
                    text = fmt.format((String)value);
                } else if (value instanceof Date) {
                    fmt = this.context.getDateFormatter(format);
                    text = fmt.format((Date)value);
                } else {
                    text = value.toString();
                }
            }
            text = this.encodeHtmlText(text);
        }
        return text;
    }

    protected String encodeHtmlText(String text) {
        return text.replaceAll("<", "&lt;");
    }

    public Object visitImage(TextTemplate.ImageNode node, Object value) {
        String src;
        String imageName = null;
        String imageExt = null;
        Object imageContent = null;
        if ("expr" == node.getType()) {
            imageContent = this.values.get(node.getExpr());
        } else {
            EmbeddedImage image;
            ModuleHandle design;
            imageName = node.getImageName();
            if (this.context != null && (design = this.context.getDesign()) != null && (image = design.findImage(imageName)) != null) {
                imageContent = image.getData(design.getModule());
                imageExt = FileUtil.getExtFromFileName(imageName);
            }
        }
        if (imageContent instanceof byte[] && (src = this.saveToFile(imageName, imageExt, (byte[])imageContent)) != null) {
            this.buffer.append("<img src=\"");
            this.buffer.append(src);
            this.buffer.append("\" ");
            for (Map.Entry entry : node.getAttributes().entrySet()) {
                Object attrName = entry.getKey();
                Object attrValue = entry.getValue();
                if (attrName == null || attrValue == null) continue;
                this.buffer.append(attrName.toString());
                this.buffer.append("=\"");
                this.buffer.append(attrValue.toString());
                this.buffer.append("\" ");
            }
            this.buffer.append(">");
        }
        return value;
    }

    protected String saveToFile(final String name, final String ext, final byte[] content) {
        String file;
        if (name != null && (file = (String)this.imageCaches.get(name)) != null) {
            return file;
        }
        return AccessController.doPrivileged(new PrivilegedAction<String>(){

            @Override
            public String run() {
                try {
                    File imageFile = File.createTempFile("img", ext, TemplateExecutor.this.imageFolder);
                    FileOutputStream out = new FileOutputStream(imageFile);
                    ((OutputStream)out).write(content);
                    ((OutputStream)out).close();
                    String fileName = imageFile.toURL().toExternalForm();
                    TemplateExecutor.this.imageCaches.put(name, fileName);
                    return fileName;
                }
                catch (IOException ex) {
                    logger.log(Level.WARNING, ex.getMessage(), ex);
                    TemplateExecutor.this.context.addException(new EngineException(ex.getLocalizedMessage()));
                    return null;
                }
            }
        });
    }
}

