/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.report.engine.api;

import org.eclipse.birt.report.engine.api.DataID;

public class InstanceID {
    protected InstanceID parentId;
    protected long uid;
    protected long designId;
    protected DataID dataId;

    public InstanceID(InstanceID parent, long designId, DataID dataId) {
        this.parentId = parent;
        this.uid = -1L;
        this.designId = designId;
        this.dataId = dataId;
    }

    public InstanceID(InstanceID parent, InstanceID iid) {
        this.parentId = parent;
        this.uid = iid.uid;
        this.designId = iid.designId;
        this.dataId = iid.dataId;
    }

    public InstanceID(InstanceID parent, long uid, long designId, DataID dataId) {
        this.parentId = parent;
        this.uid = uid;
        this.designId = designId;
        this.dataId = dataId;
    }

    public InstanceID getParentID() {
        return this.parentId;
    }

    public long getUniqueID() {
        return this.uid;
    }

    public long getComponentID() {
        return this.designId;
    }

    public DataID getDataID() {
        return this.dataId;
    }

    protected void append(StringBuffer buffer) {
        buffer.append("/");
        if (this.uid != -1L) {
            buffer.append(this.uid);
            buffer.append(".");
        }
        buffer.append(this.designId);
        if (this.dataId != null) {
            buffer.append("(");
            this.dataId.append(buffer);
            buffer.append(")");
        }
    }

    public String toString() {
        StringBuffer buffer = new StringBuffer();
        this.append(buffer);
        return buffer.toString();
    }

    protected void appendUniqueID(StringBuffer buffer) {
        InstanceID pid = this.parentId;
        if (pid != null) {
            pid.appendUniqueID(buffer);
        }
        this.append(buffer);
    }

    public String toUniqueString() {
        StringBuffer buffer = new StringBuffer();
        this.appendUniqueID(buffer);
        return buffer.toString();
    }

    public static InstanceID parse(String instanceId) {
        if (instanceId == null) {
            return null;
        }
        return InstanceID.parse(instanceId.toCharArray(), 0, instanceId.length());
    }

    public static InstanceID parse(char[] buffer, int offset, int length) {
        DataID dataId = null;
        int ptr = offset + length - 1;
        if (ptr >= offset && buffer[ptr] == ')') {
            --ptr;
            while (ptr >= offset && buffer[ptr] != '(') {
                --ptr;
            }
            if (ptr < offset || buffer[ptr] != '(') {
                return null;
            }
            dataId = DataID.parse(buffer, ptr + 1, offset + length - ptr - 2);
            if (dataId == null) {
                return null;
            }
            length = --ptr - offset + 1;
        }
        while (ptr >= offset && buffer[ptr] != '/') {
            --ptr;
        }
        if (ptr >= offset && buffer[ptr] == '/') {
            long uid = -1L;
            long designId = -1L;
            String strId = new String(buffer, ptr + 1, offset + length - ptr - 1);
            int dotPos = strId.indexOf(46);
            if (dotPos != -1) {
                uid = Long.parseLong(strId.substring(0, dotPos));
                designId = Long.parseLong(strId.substring(dotPos + 1));
            } else {
                designId = Long.parseLong(strId);
            }
            if (--ptr >= offset) {
                length = ptr - offset + 1;
                InstanceID parent = InstanceID.parse(buffer, offset, length);
                if (parent != null) {
                    return new InstanceID(parent, uid, designId, dataId);
                }
            } else {
                return new InstanceID(null, uid, designId, dataId);
            }
        }
        return null;
    }
}

