/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.data.engine.executor.dscache;

import java.util.Collection;
import java.util.List;
import org.eclipse.birt.data.engine.api.IQueryDefinition;
import org.eclipse.birt.data.engine.core.DataException;
import org.eclipse.birt.data.engine.executor.BaseQuery;
import org.eclipse.birt.data.engine.executor.QueryExecutionStrategyUtil;
import org.eclipse.birt.data.engine.executor.dscache.DataSetFromCache;
import org.eclipse.birt.data.engine.executor.transform.CachedResultSet;
import org.eclipse.birt.data.engine.executor.transform.ResultSetWrapper;
import org.eclipse.birt.data.engine.executor.transform.SimpleResultSet;
import org.eclipse.birt.data.engine.impl.ComputedColumnHelper;
import org.eclipse.birt.data.engine.impl.DataEngineImpl;
import org.eclipse.birt.data.engine.impl.DataEngineSession;
import org.eclipse.birt.data.engine.odi.IDataSetPopulator;
import org.eclipse.birt.data.engine.odi.IDataSourceQuery;
import org.eclipse.birt.data.engine.odi.IEventHandler;
import org.eclipse.birt.data.engine.odi.IPreparedDSQuery;
import org.eclipse.birt.data.engine.odi.IResultClass;
import org.eclipse.birt.data.engine.odi.IResultIterator;
import org.eclipse.birt.data.engine.odi.IResultObject;
import org.eclipse.birt.data.engine.odi.IResultObjectEvent;
import org.eclipse.datatools.connectivity.oda.spec.QuerySpecification;

public class DataSourceQuery
extends BaseQuery
implements IDataSourceQuery,
IPreparedDSQuery {
    private DataEngineSession session;
    private DataSetFromCache datasetFromCache;

    public DataSourceQuery(DataEngineSession session) {
        this.session = session;
    }

    public void setResultHints(Collection columnDefns) {
    }

    public void setResultProjection(String[] fieldNames) throws DataException {
    }

    public void setParameterHints(Collection parameterDefns) {
    }

    public void addProperty(String name, String value) throws DataException {
    }

    public void declareCustomField(String fieldName, int dataType) throws DataException {
    }

    public IPreparedDSQuery prepare() throws DataException {
        return this;
    }

    public IResultClass getResultClass() throws DataException {
        return this.getOdaCacheResultSet().getResultClass();
    }

    public Collection getParameterMetaData() throws DataException {
        return null;
    }

    public Object getOutputParameterValue(int index) throws DataException {
        return null;
    }

    public Object getOutputParameterValue(String name) throws DataException {
        return null;
    }

    public void setTempComputedColumn(List addedTempComputedColumn) {
        this.getOdaCacheResultSet().setTempComputedColumn(addedTempComputedColumn);
    }

    public IResultIterator execute(IEventHandler eventHandler) throws DataException {
        IQueryDefinition queryDefn;
        QueryExecutionStrategyUtil.Strategy strategy;
        if ((this.session.getEngineContext().getMode() == 3 || this.session.getEngineContext().getMode() == 1) && this.getQueryDefinition() instanceof IQueryDefinition && (strategy = QueryExecutionStrategyUtil.getQueryExecutionStrategy(this.session, queryDefn, (queryDefn = (IQueryDefinition)this.getQueryDefinition()).getDataSetName() == null ? null : ((DataEngineImpl)this.session.getEngine()).getDataSetDesign(queryDefn.getDataSetName()))) != QueryExecutionStrategyUtil.Strategy.Complex) {
            if (this.getFetchEvents() != null) {
                for (IResultObjectEvent event : this.getFetchEvents()) {
                    if (!(event instanceof ComputedColumnHelper)) continue;
                    ((ComputedColumnHelper)event).setModel(1);
                }
            }
            SimpleResultSet simpleResult = new SimpleResultSet((BaseQuery)this, new IDataSetPopulator(){

                public IResultObject next() throws DataException {
                    return DataSourceQuery.this.getOdaCacheResultSet().fetch();
                }
            }, this.getOdaCacheResultSet().getResultClass(), eventHandler, this.getGrouping(), this.session, strategy == QueryExecutionStrategyUtil.Strategy.SimpleLookingFoward);
            IResultIterator it = strategy == QueryExecutionStrategyUtil.Strategy.SimpleLookingFoward ? new ResultSetWrapper(this.session, simpleResult) : simpleResult;
            eventHandler.handleEndOfDataSetProcess(it);
            return it;
        }
        return new CachedResultSet((BaseQuery)this, this.getOdaCacheResultSet().getResultClass(), this.getOdaCacheResultSet(), eventHandler, this.session);
    }

    public void close() {
        try {
            if (this.datasetFromCache != null) {
                this.datasetFromCache.close();
                this.datasetFromCache = null;
            }
        }
        catch (DataException dataException) {}
    }

    private DataSetFromCache getOdaCacheResultSet() {
        if (this.datasetFromCache == null) {
            this.datasetFromCache = new DataSetFromCache(this.session);
        }
        return this.datasetFromCache;
    }

    public void setQuerySpecification(QuerySpecification spec) {
    }
}

