/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.core.ui.frameworks.taskwizard;

import java.util.List;
import org.eclipse.birt.core.ui.frameworks.errordisplay.ErrorDialog;
import org.eclipse.birt.core.ui.frameworks.taskwizard.TasksManager;
import org.eclipse.birt.core.ui.frameworks.taskwizard.WizardBase;
import org.eclipse.birt.core.ui.frameworks.taskwizard.interfaces.IButtonHandler;
import org.eclipse.birt.core.ui.i18n.Messages;
import org.eclipse.core.runtime.ISafeRunnable;
import org.eclipse.core.runtime.ListenerList;
import org.eclipse.jface.dialogs.IPageChangeProvider;
import org.eclipse.jface.dialogs.IPageChangedListener;
import org.eclipse.jface.dialogs.PageChangedEvent;
import org.eclipse.jface.dialogs.TitleAreaDialog;
import org.eclipse.jface.util.SafeRunnable;
import org.eclipse.swt.custom.CTabFolder;
import org.eclipse.swt.custom.CTabItem;
import org.eclipse.swt.events.ControlEvent;
import org.eclipse.swt.events.ControlListener;
import org.eclipse.swt.events.DisposeEvent;
import org.eclipse.swt.events.DisposeListener;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.ToolBar;
import org.eclipse.swt.widgets.ToolItem;

public class WizardBaseDialog
extends TitleAreaDialog
implements SelectionListener,
ControlListener,
DisposeListener,
IPageChangeProvider {
    protected final WizardBase wizardBase;
    private ListenerList pageChangedListeners = new ListenerList();
    private transient CTabFolder cmpTaskContainer;
    private transient int iWizardHeightMinimum = 100;
    private transient int iWizardWidthMinimum = 100;
    transient String wizardTitle = "Task Wizard";
    private transient Image imgShell = null;
    private transient Shell shellPopup = null;
    transient String[] tmpTaskArray;
    transient String tmpTopTaskId;

    public WizardBaseDialog(WizardBase wizardBase, Shell parentShell, int iInitialWidth, int iInitialHeight, String strTitle, Image imgTitle) {
        super(parentShell);
        this.wizardBase = wizardBase;
        this.setHelpAvailable(true);
        this.iWizardWidthMinimum = iInitialWidth;
        this.iWizardHeightMinimum = iInitialHeight;
        this.wizardTitle = strTitle;
        this.imgShell = imgTitle;
    }

    protected void setShellStyle(int newShellStyle) {
        super.setShellStyle(newShellStyle | 0x860 | 0x10 | 0x10000);
    }

    private void configureTaskContext(String[] sTasks, String topTaskId) {
        String[] allTasks = TasksManager.instance().getTasksForWizard(this.wizardBase.sWizardID);
        int i = 0;
        while (i < allTasks.length) {
            this.wizardBase.addTask(allTasks[i]);
            ++i;
        }
        if (sTasks != null && sTasks.length > 0) {
            i = 0;
            while (i < sTasks.length) {
                if (!this.wizardBase.vTaskIDs.contains(sTasks[i])) {
                    this.wizardBase.addTask(sTasks[i]);
                }
                ++i;
            }
        }
        if (topTaskId == null) {
            if (this.wizardBase.vTaskIDs.size() > 0) {
                this.wizardBase.sCurrentActiveTask = this.wizardBase.vTaskIDs.get(0).toString();
            }
        } else {
            assert (this.wizardBase.vTaskIDs.contains(topTaskId));
            this.wizardBase.sCurrentActiveTask = topTaskId;
        }
    }

    protected void initializeBounds() {
        this.getShell().setText(this.wizardTitle);
        this.setTitle(this.wizardTitle);
        if (this.imgShell != null) {
            this.getShell().setImage(this.imgShell);
        }
        this.getShell().addControlListener((ControlListener)this);
        this.getShell().addDisposeListener((DisposeListener)this);
        String[] allTasks = TasksManager.instance().getTasksForWizard(this.wizardBase.sWizardID);
        int i = 0;
        while (i < allTasks.length) {
            CTabItem item = new CTabItem(this.getTabContainer(), 0);
            item.setImage(TasksManager.instance().getTask(allTasks[i]).getImage());
            item.setText(TasksManager.instance().getTask(allTasks[i]).getTitle());
            item.setData((Object)allTasks[i]);
            ++i;
        }
        if (this.tmpTopTaskId != null) {
            int taskIndex = this.wizardBase.vTaskIDs.indexOf(this.tmpTopTaskId);
            this.cmpTaskContainer.setSelection(taskIndex);
        }
        if (this.wizardBase.getCurrentTask() != null) {
            this.wizardBase.getCurrentTask().setContext(this.wizardBase.context);
            this.wizardBase.packNeeded = false;
            this.wizardBase.switchTo(this.wizardBase.sCurrentActiveTask);
            this.wizardBase.packNeeded = true;
        }
        super.initializeBounds();
    }

    public void create() {
        this.configureTaskContext(this.tmpTaskArray, this.tmpTopTaskId);
        super.create();
    }

    protected Control createDialogArea(Composite parent) {
        Composite composite = new Composite(parent, 0);
        GridLayout layout = new GridLayout();
        layout.marginHeight = 0;
        layout.marginWidth = 0;
        layout.verticalSpacing = 0;
        layout.horizontalSpacing = 0;
        composite.setLayout((Layout)layout);
        composite.setLayoutData((Object)new GridData(1808));
        composite.setFont(parent.getFont());
        Label lblSeparator = new Label(composite, 258);
        lblSeparator.setLayoutData((Object)new GridData(768));
        this.cmpTaskContainer = new CTabFolder(composite, 0x800080);
        this.cmpTaskContainer.setLayoutData((Object)new GridData(1808));
        this.cmpTaskContainer.setTabHeight(25);
        this.cmpTaskContainer.addSelectionListener((SelectionListener)this);
        this.createTabToolButtons(this.cmpTaskContainer);
        lblSeparator = new Label(composite, 258);
        lblSeparator.setLayoutData((Object)new GridData(768));
        return composite;
    }

    protected void createTabToolButtons(CTabFolder tabFolder) {
        List<IButtonHandler> buttons = this.wizardBase.getTabToolButtons();
        if (buttons.size() == 0) {
            return;
        }
        ToolBar toolbar = new ToolBar((Composite)tabFolder, 0x800040);
        tabFolder.setTopRight((Control)toolbar);
        for (IButtonHandler btnHandler : buttons) {
            ToolItem btn = new ToolItem(toolbar, 0);
            btn.addSelectionListener((SelectionListener)this);
            btn.setData((Object)btnHandler);
            if (btnHandler.getLabel() != null) {
                btn.setText(btnHandler.getLabel());
            }
            if (btnHandler.getTooltip() != null) {
                btn.setToolTipText(btnHandler.getTooltip());
            }
            if (btnHandler.getIcon() == null) continue;
            btn.setImage(btnHandler.getIcon());
        }
    }

    protected void createButtonsForButtonBar(Composite parent) {
        this.createButton(parent, 14, Messages.getString("WizardBase.Back"), false);
        this.createButton(parent, 15, Messages.getString("WizardBase.Next"), false);
        this.createButton(parent, 16, Messages.getString("WizardBase.Finish"), this.wizardBase.bEnterClosed);
        this.createButton(parent, 1, Messages.getString("WizardBase.Cancel"), false);
        int i = 0;
        while (i < this.wizardBase.buttonList.size()) {
            IButtonHandler buttonHandler = this.wizardBase.buttonList.get(i);
            assert (this.getButton(buttonHandler.getId()) == null);
            buttonHandler.setButton(this.createButton(parent, buttonHandler.getId(), buttonHandler.getLabel(), false));
            ++i;
        }
        int taskIndex = this.wizardBase.vTaskIDs.indexOf(this.wizardBase.sCurrentActiveTask);
        if (taskIndex > 0) {
            this.getButton(14).setEnabled(true);
        } else {
            this.getButton(14).setEnabled(false);
        }
        if (taskIndex < this.wizardBase.vTaskIDs.size() - 1) {
            this.getButton(15).setEnabled(true);
        } else {
            this.getButton(15).setEnabled(false);
        }
    }

    protected void buttonPressed(int buttonId) {
        if (16 == buttonId) {
            this.okPressed();
        } else if (1 == buttonId) {
            this.cancelPressed();
        } else if (14 == buttonId) {
            this.backPressed();
        } else if (15 == buttonId) {
            this.nextPressed();
        }
        int i = 0;
        while (i < this.wizardBase.buttonList.size()) {
            IButtonHandler buttonHandler = this.wizardBase.buttonList.get(i);
            if (buttonId == buttonHandler.getId()) {
                buttonHandler.run();
                break;
            }
            ++i;
        }
    }

    public void switchTask() {
        String strDesc = this.wizardBase.getCurrentTask().getDescription();
        if (strDesc != null) {
            this.setMessage(strDesc);
        }
        if (this.getTabContainer().getSelectionIndex() < 0) {
            this.getTabContainer().setSelection(0);
        }
        CTabItem currentItem = this.getTabContainer().getItem(this.getTabContainer().getSelectionIndex());
        this.wizardBase.getCurrentTask().createControl((Composite)this.getTabContainer());
        if (currentItem.getControl() == null) {
            currentItem.setControl(this.wizardBase.getCurrentTask().getControl());
        }
        this.packWizard();
        this.firePageChanged(new PageChangedEvent((IPageChangeProvider)this, (Object)this.wizardBase.getCurrentTask()));
    }

    private void backPressed() {
        int i = this.wizardBase.vTaskIDs.indexOf(this.wizardBase.sCurrentActiveTask);
        if (i > 0) {
            this.cmpTaskContainer.setSelection(i - 1);
            this.wizardBase.switchTo(this.wizardBase.vTaskIDs.get(i - 1));
            this.getButton(15).setEnabled(true);
        }
        if (i == 1) {
            this.getButton(14).setEnabled(false);
        }
    }

    private void nextPressed() {
        int i = this.wizardBase.vTaskIDs.indexOf(this.wizardBase.sCurrentActiveTask);
        if (i < this.wizardBase.vTaskIDs.size() - 1) {
            this.cmpTaskContainer.setSelection(i + 1);
            this.wizardBase.switchTo(this.wizardBase.vTaskIDs.get(i + 1));
            this.getButton(14).setEnabled(true);
        }
        if (i == this.wizardBase.vTaskIDs.size() - 2) {
            this.getButton(15).setEnabled(false);
        }
    }

    protected void okPressed() {
        ErrorDialog ed;
        String[] saMessages = this.wizardBase.validate();
        if (saMessages != null && saMessages.length > 0 && (ed = new ErrorDialog(this.wizardBase.shellParent, Messages.getString("WizardBase.error.ErrorsEncountered"), Messages.getString("WizardBase.error.FollowingErrorsReportedWhileVerifying"), saMessages, new String[0])).getOption() == "ACCEPT") {
            return;
        }
        super.okPressed();
    }

    public void setMinimumSize(int iWidth, int iHeight) {
        this.iWizardWidthMinimum = iWidth;
        this.iWizardHeightMinimum = iHeight;
    }

    public Shell createPopupContainer() {
        if (this.shellPopup != null && !this.shellPopup.isDisposed()) {
            this.shellPopup.dispose();
        }
        if (this.shellPopup == null || this.shellPopup.isDisposed()) {
            int shellStyle = 2160;
            this.shellPopup = new Shell(this.getShell(), shellStyle);
            this.shellPopup.setLayout((Layout)new FillLayout());
        }
        return this.shellPopup;
    }

    public Shell getPopupContainer() {
        return this.shellPopup;
    }

    public void attachPopup(String sPopupTitle, int iWidth, int iHeight) {
        this.shellPopup.setText(sPopupTitle);
        if (iWidth != -1 && iHeight != -1) {
            this.shellPopup.setSize(iWidth, iHeight);
        } else {
            this.shellPopup.pack();
        }
        this.setPopupLocation();
        this.shellPopup.open();
    }

    public void detachPopup() {
        if (this.shellPopup != null && !this.shellPopup.isDisposed()) {
            this.shellPopup.close();
        }
    }

    public void packWizard() {
        if (!this.wizardBase.packNeeded) {
            return;
        }
        if (this.wizardBase.applyCustomPack()) {
            return;
        }
        boolean changed = false;
        Point wizardSize = this.getShell().computeSize(-1, -1);
        int iWizardWidth = Math.max(wizardSize.x, this.iWizardWidthMinimum);
        int iWizardHeight = Math.max(wizardSize.y, this.iWizardHeightMinimum);
        Point oldSize = this.getShell().getSize();
        if (oldSize.x < iWizardWidth) {
            oldSize.x = iWizardWidth;
            changed = true;
        }
        if (oldSize.y < iWizardHeight) {
            oldSize.y = iWizardHeight;
            changed = true;
        }
        if (changed) {
            this.getShell().setSize(oldSize);
            this.getShell().layout();
        }
    }

    CTabFolder getTabContainer() {
        return this.cmpTaskContainer;
    }

    public void widgetDefaultSelected(SelectionEvent e) {
    }

    public void widgetSelected(SelectionEvent e) {
        if (e.getSource() instanceof CTabFolder) {
            String taskId = (String)e.item.getData();
            int indexLabel = this.wizardBase.vTaskIDs.indexOf(taskId);
            if (indexLabel >= 0) {
                this.wizardBase.switchTo(taskId);
                this.getButton(15).setEnabled(indexLabel < this.wizardBase.vTaskIDs.size() - 1);
                this.getButton(14).setEnabled(indexLabel > 0);
            }
        } else if (e.getSource() instanceof ToolItem && this.wizardBase.getTabToolButtons().contains(((ToolItem)e.getSource()).getData())) {
            IButtonHandler btnHandle = (IButtonHandler)((ToolItem)e.getSource()).getData();
            btnHandle.run();
        }
    }

    public void controlMoved(ControlEvent e) {
        this.setPopupLocation();
    }

    public void controlResized(ControlEvent e) {
        this.setPopupLocation();
    }

    private void setPopupLocation() {
        if (this.shellPopup != null && !this.shellPopup.isDisposed()) {
            int x = 0;
            x = this.getShell().getLocation().x + this.getShell().getSize().x + this.shellPopup.getSize().x > this.getShell().getDisplay().getClientArea().width ? this.getShell().getDisplay().getClientArea().width - this.shellPopup.getSize().x : this.getShell().getLocation().x + this.getShell().getSize().x;
            this.shellPopup.setLocation(x, this.getShell().getLocation().y + 20);
        }
    }

    public void widgetDisposed(DisposeEvent e) {
        this.wizardBase.dispose();
    }

    public void addPageChangedListener(IPageChangedListener listener) {
        this.pageChangedListeners.add((Object)listener);
    }

    public Object getSelectedPage() {
        return this.wizardBase.getCurrentTask();
    }

    public void removePageChangedListener(IPageChangedListener listener) {
        this.pageChangedListeners.remove((Object)listener);
    }

    void firePageChanged(final PageChangedEvent event) {
        Object[] listeners = this.pageChangedListeners.getListeners();
        int i = 0;
        while (i < listeners.length) {
            final IPageChangedListener l = (IPageChangedListener)listeners[i];
            SafeRunnable.run((ISafeRunnable)new SafeRunnable(){

                public void run() {
                    l.pageChanged(event);
                }
            });
            ++i;
        }
    }
}

