/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.report.designer.internal.ui.dialogs.expression;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import org.eclipse.birt.report.designer.internal.ui.dialogs.expression.ExpressionCellEditor;
import org.eclipse.birt.report.designer.internal.ui.dialogs.expression.IExpressionCellEditorProvider;
import org.eclipse.birt.report.designer.internal.ui.expressions.ExpressionSupportManager;
import org.eclipse.birt.report.designer.internal.ui.expressions.IExpressionBuilder;
import org.eclipse.birt.report.designer.internal.ui.expressions.IExpressionSupport;
import org.eclipse.birt.report.designer.nls.Messages;
import org.eclipse.birt.report.designer.ui.ReportPlatformUIImages;
import org.eclipse.swt.graphics.Image;

public class ExpressionCellEditorProvider
implements IExpressionCellEditorProvider {
    private static final String CONSTANT = Messages.getString((String)"ExpressionButtonProvider.Constant");
    private ExpressionCellEditor input;
    private Map<String, IExpressionSupport> supports = new HashMap<String, IExpressionSupport>();
    private String[] supportedTypes;

    public ExpressionCellEditorProvider(boolean allowConstant) {
        IExpressionSupport[] exts;
        ArrayList<String> types = new ArrayList<String>();
        if (allowConstant) {
            types.add("constant");
        }
        if ((exts = ExpressionSupportManager.getExpressionSupports()) != null) {
            IExpressionSupport[] iExpressionSupportArray = exts;
            int n = exts.length;
            int n2 = 0;
            while (n2 < n) {
                IExpressionSupport ex = iExpressionSupportArray[n2];
                types.add(ex.getName());
                this.supports.put(ex.getName(), ex);
                ++n2;
            }
        }
        this.supportedTypes = types.toArray(new String[types.size()]);
    }

    public void setInput(ExpressionCellEditor input) {
        this.input = input;
    }

    public String[] getExpressionTypes() {
        return this.supportedTypes;
    }

    public Image getImage(String exprType) {
        if ("constant".equals(exprType)) {
            return ReportPlatformUIImages.getImage("Enable Expression Constant");
        }
        IExpressionSupport spt = this.supports.get(exprType);
        if (spt != null) {
            return spt.getImage();
        }
        return null;
    }

    public String getText(String exprType) {
        if ("constant".equals(exprType)) {
            return CONSTANT;
        }
        IExpressionSupport spt = this.supports.get(exprType);
        if (spt != null) {
            return spt.getDisplayName();
        }
        return "";
    }

    public String getTooltipText(String exprType) {
        return this.getText(exprType);
    }

    public void handleSelectionEvent(String exprType) {
        IExpressionBuilder builder;
        IExpressionSupport spt = this.supports.get(exprType);
        String sOldExpr = this.input.getExpression();
        if (spt != null && (builder = spt.createBuilder(this.input.getControl().getShell(), null)) != null) {
            this.input.openExpressionBuilder(builder, exprType);
        }
        this.input.notifyExpressionChangeEvent(sOldExpr, this.input.getExpression());
    }

    public IExpressionSupport getExpressionSupport(String exprType) {
        return this.supports.get(exprType);
    }
}

