/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ui.internal.views.markers;

import org.eclipse.jface.action.ContributionItem;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.action.Separator;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.swt.widgets.MenuItem;
import org.eclipse.ui.internal.views.markers.ExtendedMarkersView;
import org.eclipse.ui.internal.views.markers.MarkersContribution;
import org.eclipse.ui.views.markers.MarkerField;
import org.eclipse.ui.views.markers.internal.MarkerMessages;

public class SortFieldContribution
extends MarkersContribution {
    public SortFieldContribution() {
    }

    public SortFieldContribution(String id) {
        super(id);
    }

    protected IContributionItem[] getContributionItems() {
        ExtendedMarkersView view = this.getView();
        if (view == null) {
            return new IContributionItem[0];
        }
        MarkerField[] fields = view.getVisibleFields();
        if (fields.length == 0) {
            return new IContributionItem[0];
        }
        IContributionItem[] items = new IContributionItem[fields.length + 2];
        int i = 0;
        while (i < fields.length) {
            items[i] = this.getContributionItem(fields[i]);
            ++i;
        }
        items[fields.length] = new Separator();
        items[fields.length + 1] = this.getDirectionContribution();
        return items;
    }

    private IContributionItem getDirectionContribution() {
        return new ContributionItem(){

            public void fill(Menu menu, int index) {
                MenuItem item = new MenuItem(menu, 32);
                item.setText(MarkerMessages.sortDirectionAscending_text);
                ExtendedMarkersView view = SortFieldContribution.this.getView();
                item.addListener(13, new Listener(this, view){
                    final /* synthetic */ 1 this$1;
                    private final /* synthetic */ ExtendedMarkersView val$view;
                    {
                        this.this$1 = var1_1;
                        this.val$view = extendedMarkersView;
                    }

                    public void handleEvent(Event event) {
                        if (this.val$view != null) {
                            this.val$view.toggleSortDirection();
                        }
                    }
                });
                if (view != null) {
                    item.setSelection(view.getSortAscending());
                }
            }
        };
    }

    private IContributionItem getContributionItem(final MarkerField field) {
        return new ContributionItem(){

            public void fill(Menu menu, int index) {
                MenuItem item = new MenuItem(menu, 16);
                String title = field.getName();
                item.setText(title);
                ExtendedMarkersView view = SortFieldContribution.this.getView();
                item.addListener(13, this.getMenuItemListener(field, view));
                if (view != null) {
                    item.setSelection(view.isPrimarySortField(field));
                }
            }

            private Listener getMenuItemListener(MarkerField field2, ExtendedMarkersView view) {
                return new Listener(this, view, field2){
                    final /* synthetic */ 3 this$1;
                    private final /* synthetic */ ExtendedMarkersView val$view;
                    private final /* synthetic */ MarkerField val$field;
                    {
                        this.this$1 = var1_1;
                        this.val$view = extendedMarkersView;
                        this.val$field = markerField;
                    }

                    public void handleEvent(Event event) {
                        MenuItem item = (MenuItem)event.widget;
                        if (item.getSelection() && this.val$view != null) {
                            this.val$view.setPrimarySortField(this.val$field);
                        }
                    }
                };
            }
        };
    }
}

