/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.report.designer.data.ui.dataset;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import org.eclipse.birt.core.data.ExpressionUtil;
import org.eclipse.birt.core.data.IColumnBinding;
import org.eclipse.birt.core.exception.BirtException;
import org.eclipse.birt.data.engine.api.aggregation.AggregationManager;
import org.eclipse.birt.data.engine.api.aggregation.IAggrFunction;
import org.eclipse.birt.data.engine.api.aggregation.IParameterDefn;
import org.eclipse.birt.report.data.adapter.api.DataAdapterUtil;
import org.eclipse.birt.report.designer.data.ui.dataset.DataSetEditor;
import org.eclipse.birt.report.designer.data.ui.dataset.DataSetViewData;
import org.eclipse.birt.report.designer.data.ui.dataset.PropertyHandleInputDialog;
import org.eclipse.birt.report.designer.data.ui.dataset.PropertyHandleTableViewer;
import org.eclipse.birt.report.designer.data.ui.property.AbstractDescriptionPropertyPage;
import org.eclipse.birt.report.designer.data.ui.util.ControlProvider;
import org.eclipse.birt.report.designer.data.ui.util.DataSetExpressionProvider;
import org.eclipse.birt.report.designer.data.ui.util.DataSetProvider;
import org.eclipse.birt.report.designer.data.ui.util.DataUtil;
import org.eclipse.birt.report.designer.data.ui.util.Utility;
import org.eclipse.birt.report.designer.internal.ui.util.ExceptionHandler;
import org.eclipse.birt.report.designer.nls.Messages;
import org.eclipse.birt.report.designer.ui.dialogs.ExpressionBuilder;
import org.eclipse.birt.report.designer.ui.dialogs.IExpressionProvider;
import org.eclipse.birt.report.designer.util.DEUtil;
import org.eclipse.birt.report.model.api.AggregationArgumentHandle;
import org.eclipse.birt.report.model.api.ColumnHintHandle;
import org.eclipse.birt.report.model.api.ComputedColumnHandle;
import org.eclipse.birt.report.model.api.DataSetHandle;
import org.eclipse.birt.report.model.api.DesignElementHandle;
import org.eclipse.birt.report.model.api.PropertyHandle;
import org.eclipse.birt.report.model.api.SimpleValueHandle;
import org.eclipse.birt.report.model.api.StructureFactory;
import org.eclipse.birt.report.model.api.activity.SemanticException;
import org.eclipse.birt.report.model.api.core.IStructure;
import org.eclipse.birt.report.model.api.elements.structures.AggregationArgument;
import org.eclipse.birt.report.model.api.elements.structures.ComputedColumn;
import org.eclipse.birt.report.model.api.metadata.IChoice;
import org.eclipse.birt.report.model.api.metadata.PropertyValueException;
import org.eclipse.birt.report.model.core.Structure;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ILabelProviderListener;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.IStructuredContentProvider;
import org.eclipse.jface.viewers.ITableLabelProvider;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.swt.events.KeyEvent;
import org.eclipse.swt.events.KeyListener;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.MouseAdapter;
import org.eclipse.swt.events.MouseEvent;
import org.eclipse.swt.events.MouseListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.TableColumn;
import org.eclipse.swt.widgets.Text;

public class DataSetComputedColumnsPage
extends AbstractDescriptionPropertyPage {
    protected transient PropertyHandle computedColumns = null;
    protected transient PropertyHandleTableViewer viewer = null;
    private static final int COLUMN_NAME_INDEX = 0;
    private static final int DATA_TYPE_INDEX = 1;
    private static final int EXPRESSION_INDEX = 2;
    private static final int AGGREGATION_INDEX = 3;
    private static final int FILTER_INDEX = 5;
    protected static String[] cellLabels = new String[]{Messages.getString((String)"dataset.editor.title.columnName"), Messages.getString((String)"dataset.editor.title.dataType"), Messages.getString((String)"dataset.editor.title.expression"), Messages.getString((String)"dataset.editor.title.aggrFunc"), Messages.getString((String)"dataset.editor.title.aggrArgu"), Messages.getString((String)"dataset.editor.title.filter")};
    protected static String[] cellProperties = new String[]{"name", "dataType", "expression", "aggregateFunction", "arguments", "filterExpr"};
    protected static IChoice[] dataTypes = DEUtil.getMetaDataDictionary().getStructure("ComputedColumn").getMember("dataType").getAllowedChoices().getChoices();
    protected static String[] dialogLabels = new String[]{Messages.getString((String)"dataset.editor.inputDialog.columnName"), Messages.getString((String)"dataset.editor.inputDialog.dataType"), Messages.getString((String)"dataset.editor.inputDialog.expression"), Messages.getString((String)"dataset.editor.inputDialog.aggrFunc"), Messages.getString((String)"dataset.editor.inputDialog.aggrArgu"), Messages.getString((String)"dataset.editor.inputDialog.filter")};
    protected AggregationManager aggregationManager;

    public DataSetComputedColumnsPage() {
        try {
            DataUtil.getAggregationManager();
            this.aggregationManager = AggregationManager.getInstance();
        }
        catch (BirtException e) {
            e.printStackTrace();
        }
    }

    public Control createContents(Composite parent) {
        this.computedColumns = ((DataSetHandle)this.getContainer().getModel()).getPropertyHandle("computedColumns");
        this.createTableViewer(parent);
        this.addListeners();
        this.setToolTips();
        return this.viewer.getControl();
    }

    protected void createTableViewer(Composite parent) {
        this.viewer = new PropertyHandleTableViewer(parent, true, true, true){

            protected void doRemove() {
                int count;
                int index = this.viewer.getTable().getSelectionIndex();
                PropertyHandle handle = (PropertyHandle)this.viewer.getInput();
                int n = count = handle.getListValue() == null ? 0 : handle.getListValue().size();
                if (index > -1 && index < count) {
                    ComputedColumnHandle computedColumn = (ComputedColumnHandle)this.viewer.getTable().getItems()[index].getData();
                    this.removeColumnHint(computedColumn.getName());
                    try {
                        handle.removeItem(index);
                    }
                    catch (PropertyValueException e1) {
                        ExceptionHandler.handle((Throwable)e1);
                    }
                    this.viewer.refresh();
                    this.viewer.getTable().setFocus();
                    this.viewer.getTable().select(index);
                    this.updateButtons();
                }
            }

            private void removeColumnHint(String columnName) {
                if (columnName == null) {
                    return;
                }
                PropertyHandle propertyHandle = ((DataSetHandle)DataSetComputedColumnsPage.this.getContainer().getModel()).getPropertyHandle("columnHints");
                for (ColumnHintHandle hint : propertyHandle) {
                    if (!columnName.equals(hint.getColumnName())) continue;
                    try {
                        propertyHandle.removeItem((Object)hint);
                    }
                    catch (PropertyValueException e) {
                        ExceptionHandler.handle((Throwable)e);
                    }
                }
            }
        };
        TableColumn column = new TableColumn(this.viewer.getViewer().getTable(), 16384);
        column.setText(cellLabels[0]);
        column.setWidth(150);
        column = new TableColumn(this.viewer.getViewer().getTable(), 16384);
        column.setText(cellLabels[1]);
        column.setWidth(200);
        column = new TableColumn(this.viewer.getViewer().getTable(), 16384);
        column.setText(cellLabels[2]);
        column.setWidth(200);
        column = new TableColumn(this.viewer.getViewer().getTable(), 16384);
        column.setText(cellLabels[3]);
        column.setWidth(200);
        column = new TableColumn(this.viewer.getViewer().getTable(), 16384);
        column.setText(cellLabels[5]);
        column.setWidth(200);
        this.viewer.getViewer().setContentProvider((IContentProvider)new IStructuredContentProvider(){

            public Object[] getElements(Object inputElement) {
                ArrayList computedColumnsList = new ArrayList(10);
                Iterator iter = DataSetComputedColumnsPage.this.computedColumns.iterator();
                if (iter != null) {
                    while (iter.hasNext()) {
                        computedColumnsList.add(iter.next());
                    }
                }
                return computedColumnsList.toArray();
            }

            public void dispose() {
            }

            public void inputChanged(Viewer viewer, Object oldInput, Object newInput) {
            }
        });
        this.viewer.getViewer().setLabelProvider((IBaseLabelProvider)new TableProvider());
        this.viewer.getViewer().setInput((Object)this.computedColumns);
    }

    public void pageActivated() {
        this.refreshColumnNames();
        this.getContainer().setMessage(Messages.getString((String)"dataset.editor.computedColumns"), 0);
        this.setPageProperties();
        this.computedColumns = ((DataSetHandle)this.getContainer().getModel()).getPropertyHandle("computedColumns");
        this.viewer.getViewer().setInput((Object)this.computedColumns);
        this.viewer.getViewer().getTable().select(0);
    }

    private void refreshColumnNames() {
        ((DataSetEditor)this.getContainer()).getCurrentItemModel(true, true);
    }

    private void addListeners() {
        this.viewer.getNewButton().addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                DataSetComputedColumnsPage.this.doNew();
            }
        });
        this.viewer.getEditButton().addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                DataSetComputedColumnsPage.this.doEdit();
            }
        });
        this.viewer.getViewer().getTable().addMouseListener((MouseListener)new MouseAdapter(){

            public void mouseDoubleClick(MouseEvent e) {
                DataSetComputedColumnsPage.this.doEdit();
            }
        });
        this.viewer.getViewer().getTable().addKeyListener(new KeyListener(){

            public void keyPressed(KeyEvent e) {
            }

            public void keyReleased(KeyEvent e) {
                if (e.keyCode == 127) {
                    DataSetComputedColumnsPage.this.setPageProperties();
                }
            }
        });
        this.addRemoveListeners();
        this.viewer.getViewer().addSelectionChangedListener((ISelectionChangedListener)new ViewerSelectionListener());
    }

    private void addRemoveListeners() {
        this.viewer.getRemoveButton().addSelectionListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent e) {
                DataSetComputedColumnsPage.this.setPageProperties();
                DataSetComputedColumnsPage.this.updateColumnsOfDataSetHandle();
            }

            public void widgetDefaultSelected(SelectionEvent e) {
            }
        });
        this.viewer.getRemoveMenuItem().addSelectionListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent e) {
                DataSetComputedColumnsPage.this.setPageProperties();
                DataSetComputedColumnsPage.this.updateColumnsOfDataSetHandle();
            }

            public void widgetDefaultSelected(SelectionEvent e) {
            }
        });
        this.viewer.getRemoveAllMenuItem().addSelectionListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent e) {
                DataSetComputedColumnsPage.this.setPageProperties();
                DataSetComputedColumnsPage.this.updateColumnsOfDataSetHandle();
            }

            public void widgetDefaultSelected(SelectionEvent e) {
                this.widgetSelected(e);
            }
        });
    }

    private void doNew() {
        this.doEdit(new ComputedColumn(), true);
    }

    private void doEdit() {
        int index = this.viewer.getViewer().getTable().getSelectionIndex();
        if (index == -1) {
            return;
        }
        ComputedColumnHandle handle = (ComputedColumnHandle)this.viewer.getViewer().getTable().getItem(index).getData();
        this.doEdit(handle, false);
    }

    protected void doEdit(Object structureOrHandle, boolean applyAnalysis) {
        ComputedColumnInputDialog dlg = new ComputedColumnInputDialog(structureOrHandle, applyAnalysis);
        if (dlg.open() == 0) {
            this.updateComputedColumn(structureOrHandle);
        }
    }

    protected void updateComputedColumn(Object structureOrHandle) {
        if (structureOrHandle instanceof ComputedColumn) {
            try {
                this.computedColumns.addItem((IStructure)((ComputedColumn)structureOrHandle));
                this.viewer.getViewer().refresh();
            }
            catch (SemanticException e) {
                ExceptionHandler.handle((Throwable)e);
            }
        } else {
            this.viewer.getViewer().update(structureOrHandle, null);
        }
        if (this.validateAllComputedColumns()) {
            this.getContainer().setMessage(Messages.getString((String)"dataset.editor.computedColumns"), 0);
        }
    }

    protected ComputedColumn getStructure(Object structureOrHandle) {
        ComputedColumn structure = null;
        structure = structureOrHandle instanceof ComputedColumn ? (ComputedColumn)structureOrHandle : (ComputedColumn)((ComputedColumnHandle)structureOrHandle).getStructure();
        return structure;
    }

    protected final String getTypeName(String typeDisplayName) {
        int i = 0;
        while (i < dataTypes.length) {
            if (dataTypes[i].getDisplayName().equals(typeDisplayName)) {
                return dataTypes[i].getName();
            }
            ++i;
        }
        return dataTypes[0].getName();
    }

    protected final String getTypeDisplayName(String typeName) {
        int i = 0;
        while (i < dataTypes.length) {
            if (dataTypes[i].getName().equals(typeName)) {
                return dataTypes[i].getDisplayName();
            }
            ++i;
        }
        return typeName;
    }

    private void setToolTips() {
        this.viewer.getNewButton().setToolTipText(Messages.getString((String)"DataSetComputedColumnsPage.toolTipText.New"));
        this.viewer.getEditButton().setToolTipText(Messages.getString((String)"DataSetComputedColumnsPage.toolTipText.Edit"));
        this.viewer.getRemoveButton().setToolTipText(Messages.getString((String)"DataSetComputedColumnsPage.toolTipText.Remove"));
        this.viewer.getUpButton().setToolTipText(Messages.getString((String)"DataSetComputedColumnsPage.toolTipText.Up"));
        this.viewer.getDownButton().setToolTipText(Messages.getString((String)"DataSetComputedColumnsPage.toolTipText.Down"));
    }

    public String getPageDescription() {
        return Messages.getString((String)"DataSetComputedColumnsPage.description");
    }

    public boolean performOk() {
        if (this.validateAllComputedColumns()) {
            return super.performOk();
        }
        return false;
    }

    private void setPageProperties() {
        this.viewer.updateButtons();
        this.validateAllComputedColumns();
    }

    private void updateColumnsOfDataSetHandle() {
        DataSetHandle dataSet = ((DataSetEditor)this.getContainer()).getHandle();
        DataSetViewData[] items = DataSetProvider.getCurrentInstance().getColumns(dataSet, false, true, true);
        int inexistence = 0;
        int i = 0;
        while (i < items.length) {
            boolean exist = false;
            if (items[i].isComputedColumn()) {
                Iterator iter = this.computedColumns.iterator();
                while (iter.hasNext()) {
                    ComputedColumn computedColumn = null;
                    Object obj = iter.next();
                    if (obj instanceof ComputedColumnHandle) {
                        computedColumn = (ComputedColumn)((ComputedColumnHandle)obj).getStructure();
                    }
                    if (computedColumn == null || !items[i].getName().equals(computedColumn.getName())) continue;
                    exist = true;
                }
                if (!exist) {
                    items[i] = null;
                    ++inexistence;
                }
            }
            ++i;
        }
        if (inexistence == 0) {
            return;
        }
        DataSetViewData[] existItems = new DataSetViewData[items.length - inexistence];
        int index = 0;
        int i2 = 0;
        while (i2 < items.length) {
            if (items[i2] != null) {
                existItems[index] = items[i2];
                ++index;
            }
            ++i2;
        }
        DataSetProvider.getCurrentInstance().updateColumnsOfDataSetHandle(dataSet, existItems);
    }

    public String getToolTip() {
        return Messages.getString((String)"DataSetComputedColumnsPage.ComputedColumns.Tooltip");
    }

    public boolean canLeave() {
        return this.validateAllComputedColumns();
    }

    private boolean validateAllComputedColumns() {
        Iterator iter;
        if (this.computedColumns != null && (iter = this.computedColumns.iterator()) != null) {
            while (iter.hasNext()) {
                Object o = iter.next();
                ComputedColumn computedColumn = null;
                computedColumn = o instanceof ComputedColumnHandle ? (ComputedColumn)((ComputedColumnHandle)o).getStructure() : (ComputedColumn)o;
                if (this.validateSingleColumn(computedColumn)) continue;
                return false;
            }
        }
        return true;
    }

    private boolean validateSingleColumn(ComputedColumn computedColumn) {
        if (computedColumn.getName() == null || computedColumn.getName().trim().length() == 0) {
            this.getContainer().setMessage(Messages.getFormattedString((String)"dataset.editor.error.missingComputedColumnName", (Object[])new Object[]{computedColumn.getName()}), 3);
            return false;
        }
        for (ColumnHintHandle hint : ((DataSetHandle)this.getContainer().getModel()).getPropertyHandle("columnHints")) {
            if (computedColumn.getName().equals(hint.getColumnName()) || !computedColumn.getName().equals(hint.getAlias())) continue;
            this.getContainer().setMessage(Messages.getFormattedString((String)"dataset.editor.error.computedColumnNameAlreadyUsed", (Object[])new Object[]{computedColumn.getName()}), 3);
            return false;
        }
        return true;
    }

    protected class ComputedColumnInputDialog
    extends PropertyHandleInputDialog {
        private static final String BLANK = "";
        private Text txtColumnName;
        private Combo cmbDataType;
        private Combo cmbAggregation;
        private Label lblFilter;
        private Text txtFilter;
        private Button btnFilter;
        private String columnName;
        private Text[] txtParams;
        private IAggrFunction[] functions;
        private Composite parameterContainer;
        private Composite composite;
        private String lastExpression;
        private Label firstLabel;
        private int maxWidth;

        private ComputedColumnInputDialog(Object structureOrHandle, boolean applyAnalysis) {
            super(structureOrHandle);
            this.txtColumnName = null;
            this.cmbDataType = null;
            this.cmbAggregation = null;
            this.lblFilter = null;
            this.txtFilter = null;
            this.btnFilter = null;
            this.columnName = null;
            this.txtParams = null;
            this.functions = null;
            this.populateFunctions();
        }

        protected void setSystemHelp(Composite composite) {
            Utility.setSystemHelp((Control)composite, (String)"org.eclipse.birt.cshelp.Dialog_DataSet_ComputedColumns_ID");
        }

        private void populateFunctions() {
            List aggrList = DataSetComputedColumnsPage.this.aggregationManager.getAggregations(0);
            this.functions = new IAggrFunction[aggrList.size()];
            aggrList.toArray(this.functions);
        }

        protected void createCustomControls(Composite parent) {
            this.composite = parent;
            this.createTextCell(parent, 0);
            this.createComboBoxCell(parent, 1);
            this.createAggrListCell(parent, 3);
            this.createParameterContainer(parent);
            this.createFilterCell(parent, 5);
            this.handleAggrSelectEvent(this.getStructureOrHandle() instanceof Structure);
            this.createSpaceForResize(parent);
        }

        private void createSpaceForResize(Composite parent) {
            Label space = ControlProvider.createLabel(parent, null);
            space.setLayoutData((Object)ControlProvider.getGridDataWithHSpan(3));
            space = ControlProvider.createLabel(parent, null);
            space.setLayoutData((Object)ControlProvider.getGridDataWithHSpan(3));
            space = ControlProvider.createLabel(parent, null);
            space.setLayoutData((Object)ControlProvider.getGridDataWithHSpan(3));
            space = ControlProvider.createLabel(parent, null);
            space.setLayoutData((Object)ControlProvider.getGridDataWithHSpan(3));
        }

        private void createParameterContainer(Composite parent) {
            this.parameterContainer = new Composite(parent, 0);
            GridData gridData = new GridData(768);
            gridData.horizontalIndent = 0;
            gridData.horizontalSpan = 3;
            gridData.exclude = true;
            this.parameterContainer.setLayoutData((Object)gridData);
            GridLayout layout = new GridLayout();
            layout.marginHeight = 0;
            layout.marginWidth = 0;
            layout.numColumns = 3;
            this.parameterContainer.setLayout((Layout)layout);
        }

        private void createTextCell(Composite parent, int index) {
            this.firstLabel = ControlProvider.createLabel(parent, dialogLabels[index]);
            this.maxWidth = this.computeMaxWidth(this.firstLabel);
            this.txtColumnName = ControlProvider.createText(parent, (String)this.getProperty(this.getStructureOrHandle(), cellProperties[index]));
            this.txtColumnName.setLayoutData((Object)ControlProvider.getGridDataWithHSpan(2));
            this.columnName = this.txtColumnName.getText();
            this.txtColumnName.addModifyListener(new ModifyListener(){

                public void modifyText(ModifyEvent e) {
                    ComputedColumnInputDialog.this.validateSyntax();
                }
            });
        }

        private void createComboBoxCell(Composite parent, int index) {
            Label label = ControlProvider.createLabel(parent, dialogLabels[index]);
            this.maxWidth = this.computeMaxWidth(label);
            this.cmbDataType = ControlProvider.createCombo(parent, 8);
            this.cmbDataType.setLayoutData((Object)ControlProvider.getGridDataWithHSpan(2));
            this.cmbDataType.setVisibleItemCount(30);
            this.populateDataTypeComboItems();
            this.cmbDataType.select(Utility.findIndex((String[])this.cmbDataType.getItems(), (String)DataSetComputedColumnsPage.this.getTypeDisplayName((String)this.getProperty(this.getStructureOrHandle(), cellProperties[index]))));
            this.cmbDataType.addSelectionListener((SelectionListener)new SelectionAdapter(){

                public void widgetSelected(SelectionEvent e) {
                    ComputedColumnInputDialog.this.validateSyntax();
                }
            });
        }

        private void populateDataTypeComboItems() {
            HashMap<Object, String> indexMap = new HashMap<Object, String>();
            Object[] dataTypeDisplayNames = new String[dataTypes.length];
            int i = 0;
            while (i < dataTypes.length) {
                dataTypeDisplayNames[i] = dataTypes[i].getDisplayName();
                indexMap.put(dataTypeDisplayNames[i], dataTypes[i].getName());
                ++i;
            }
            Arrays.sort(dataTypeDisplayNames);
            this.cmbDataType.setItems((String[])dataTypeDisplayNames);
            i = 0;
            while (i < dataTypeDisplayNames.length) {
                String name = (String)indexMap.get(dataTypeDisplayNames[i]);
                this.cmbDataType.setData(name, (Object)i);
                ++i;
            }
        }

        private void createAggrListCell(Composite parent, int index) {
            Label label = ControlProvider.createLabel(parent, dialogLabels[index]);
            this.maxWidth = this.computeMaxWidth(label);
            this.cmbAggregation = ControlProvider.createCombo(parent, 8);
            this.cmbAggregation.setLayoutData((Object)ControlProvider.getGridDataWithHSpan(2));
            this.cmbAggregation.setVisibleItemCount(30);
            this.cmbAggregation.add(BLANK);
            this.cmbAggregation.setData(BLANK, (Object)0);
            int i = 0;
            while (i < this.functions.length) {
                this.cmbAggregation.add(this.functions[i].getDisplayName());
                this.cmbAggregation.setData(this.functions[i].getName(), (Object)(i + 1));
                ++i;
            }
            String aggrFuncName = (String)this.getProperty(this.getStructureOrHandle(), cellProperties[index]);
            int selectionIndex = this.getAggrFuncIndex(aggrFuncName);
            this.cmbAggregation.select(selectionIndex);
            this.cmbAggregation.setToolTipText(selectionIndex > 0 ? this.functions[selectionIndex - 1].getDescription() : BLANK);
            this.cmbAggregation.addSelectionListener((SelectionListener)new SelectionAdapter(){

                public void widgetSelected(SelectionEvent e) {
                    ComputedColumnInputDialog.this.handleAggrSelectEvent(true);
                    ComputedColumnInputDialog.this.validateSyntax();
                    ComputedColumnInputDialog.this.updateFilterUIStatus();
                }
            });
        }

        private int computeMaxWidth(Label label) {
            int widthHint = label.computeSize((int)-1, (int)-1).x - label.getBorderWidth();
            return widthHint > this.maxWidth ? widthHint : this.maxWidth;
        }

        private void handleAggrSelectEvent(boolean resetDataType) {
            this.disposeOldParameterUI();
            IAggrFunction function = this.getSelectedFunction();
            IParameterDefn[] params = null;
            params = function != null ? function.getParameterDefn() : new IParameterDefn[]{new DummyParamDefn(cellLabels[2], dialogLabels[2], false, true)};
            if (params.length > 0) {
                this.showParameterUISection();
                this.createParameterUISection(params);
            } else {
                this.hideParameterUISection();
            }
            if (resetDataType) {
                this.updateDataTypeCombo();
            }
            this.parameterContainer.layout();
            this.composite.layout();
        }

        private void createParameterUISection(IParameterDefn[] params) {
            this.txtParams = new Text[params.length];
            int i = 0;
            while (i < params.length) {
                IParameterDefn param = params[i];
                Label paramLabel = new Label(this.parameterContainer, 64);
                paramLabel.setText(Utility.getNonNullString((String)param.getDisplayName()));
                GridData gd = new GridData();
                gd.widthHint = this.maxWidth = this.computeMaxWidth(paramLabel);
                paramLabel.setLayoutData((Object)gd);
                Composite composite = ControlProvider.getDefaultComposite(this.parameterContainer);
                if (param.isDataField()) {
                    String text = BLANK;
                    text = this.lastExpression != null ? this.lastExpression : (String)this.getProperty(this.getStructureOrHandle(), cellProperties[2]);
                    this.txtParams[i] = ControlProvider.createText(composite, text);
                    final Text txtDataField = this.txtParams[i];
                    txtDataField.setLayoutData((Object)ControlProvider.getGridDataWithHSpan(1));
                    txtDataField.setData((Object)params[i]);
                    txtDataField.addModifyListener(new ModifyListener(){

                        public void modifyText(ModifyEvent e) {
                            ComputedColumnInputDialog.this.lastExpression = txtDataField.getText();
                            ComputedColumnInputDialog.this.validateSyntax();
                        }
                    });
                } else {
                    Text txtArgument = ControlProvider.createText(composite, null);
                    txtArgument.setLayoutData((Object)ControlProvider.getGridDataWithHSpan(1));
                    txtArgument.addModifyListener(new ModifyListener(){

                        public void modifyText(ModifyEvent e) {
                            ComputedColumnInputDialog.this.validateSyntax();
                        }
                    });
                    this.txtParams[i] = txtArgument;
                }
                this.txtParams[i].setToolTipText(param.getDescription());
                this.createExpressionButton(composite, this.txtParams[i]);
                ++i;
            }
            this.updateLabelWidth();
            this.updateParametersText(params);
        }

        private void updateLabelWidth() {
            GridData gd = new GridData();
            gd.widthHint = this.maxWidth;
            this.firstLabel.setLayoutData((Object)gd);
        }

        private void updateDataTypeCombo() {
            IAggrFunction aggrFunc = this.getSelectedFunction();
            if (aggrFunc != null) {
                String dataType = DataAdapterUtil.adapterToModelDataType((int)aggrFunc.getDataType());
                this.cmbDataType.setText(DataSetComputedColumnsPage.this.getTypeDisplayName(dataType));
            }
        }

        private void disposeOldParameterUI() {
            Control[] children = this.parameterContainer.getChildren();
            int i = 0;
            while (i < children.length) {
                children[i].dispose();
                ++i;
            }
        }

        private void hideParameterUISection() {
            ((GridData)this.parameterContainer.getLayoutData()).heightHint = 0;
        }

        private void showParameterUISection() {
            ((GridData)this.parameterContainer.getLayoutData()).exclude = false;
            ((GridData)this.parameterContainer.getLayoutData()).heightHint = -1;
        }

        private void updateParametersText(IParameterDefn[] params) {
            if (params.length == 0) {
                return;
            }
            Object handle = this.getStructureOrHandle();
            if (handle instanceof ComputedColumnHandle) {
                ComputedColumnHandle cHandle = (ComputedColumnHandle)handle;
                String expr = cHandle.getExpression();
                if (expr != null) {
                    this.txtParams[0].setText(expr);
                } else {
                    Iterator itr = cHandle.argumentsIterator();
                    ArrayList argHandles = new ArrayList();
                    while (itr.hasNext()) {
                        argHandles.add(itr.next());
                    }
                    int i = 0;
                    if (params[0].isDataField() && this.lastExpression != null) {
                        this.txtParams[0].setText(this.lastExpression);
                        ++i;
                    }
                    while (i < params.length) {
                        AggregationArgumentHandle argHandle = null;
                        if (i < argHandles.size()) {
                            argHandle = (AggregationArgumentHandle)argHandles.get(i);
                        }
                        String value = argHandle != null ? argHandle.getValue() : null;
                        this.txtParams[i].setText(value != null ? value : BLANK);
                        ++i;
                    }
                }
            }
        }

        private int getAggrFuncIndex(String aggrFuncName) {
            Integer selectionIndex = (Integer)this.cmbAggregation.getData(aggrFuncName != null ? aggrFuncName : BLANK);
            return selectionIndex != null ? selectionIndex : 0;
        }

        private boolean needFilter() {
            return this.cmbAggregation.getText() != null && this.cmbAggregation.getText().trim().length() > 0;
        }

        private void updateFilterUIStatus() {
            if (this.needFilter()) {
                this.txtFilter.setEnabled(true);
                this.lblFilter.setEnabled(true);
                this.btnFilter.setEnabled(true);
            } else {
                this.txtFilter.setText(BLANK);
                this.txtFilter.setEnabled(false);
                this.lblFilter.setEnabled(false);
                this.btnFilter.setEnabled(false);
            }
        }

        private void createFilterCell(Composite parent, int index) {
            this.lblFilter = ControlProvider.createLabel(parent, dialogLabels[index]);
            Composite composite = ControlProvider.getDefaultComposite(parent);
            Object handle = this.getStructureOrHandle();
            if (handle instanceof ComputedColumnHandle) {
                ComputedColumnHandle cHandle = (ComputedColumnHandle)handle;
                this.txtFilter = ControlProvider.createText(composite, cHandle.getFilterExpression());
            } else {
                this.txtFilter = ControlProvider.createText(composite, (String)this.getProperty(this.getStructureOrHandle(), cellProperties[index]));
            }
            this.txtFilter.setLayoutData((Object)ControlProvider.getGridDataWithHSpan(1));
            this.txtFilter.setEnabled(false);
            this.txtFilter.addModifyListener(new ModifyListener(){

                public void modifyText(ModifyEvent e) {
                    ComputedColumnInputDialog.this.validateSyntax();
                }
            });
            SelectionAdapter listener = new SelectionAdapter(){

                public void widgetSelected(SelectionEvent event) {
                    ExpressionBuilder expressionBuilder = new ExpressionBuilder(ComputedColumnInputDialog.this.txtFilter.getText());
                    expressionBuilder.setExpressionProvier((IExpressionProvider)new DataSetExpressionProvider((DesignElementHandle)DataSetComputedColumnsPage.this.getContainer().getModel()));
                    String expression = ComputedColumnInputDialog.this.txtFilter == null ? null : ComputedColumnInputDialog.this.txtFilter.getText();
                    ComputedColumnInputDialog.this.setExprBuilderDefaultSelection(expressionBuilder, expression);
                    if (expressionBuilder.open() == 0) {
                        ComputedColumnInputDialog.this.txtFilter.setText(expressionBuilder.getResult().trim());
                    }
                }
            };
            this.btnFilter = ControlProvider.createButton(composite, 8, (SelectionListener)listener);
            this.updateFilterUIStatus();
        }

        private Button createExpressionButton(Composite composite, final Text text) {
            SelectionAdapter listener = new SelectionAdapter(){

                public void widgetSelected(SelectionEvent event) {
                    ExpressionBuilder expressionBuilder = new ExpressionBuilder(text.getText());
                    expressionBuilder.setExpressionProvier((IExpressionProvider)new DataSetExpressionProvider((DesignElementHandle)DataSetComputedColumnsPage.this.getContainer().getModel()));
                    String expression = ComputedColumnInputDialog.this.txtParams.length > 0 && ComputedColumnInputDialog.this.txtParams[0] != null ? ComputedColumnInputDialog.this.txtParams[0].getText() : null;
                    ComputedColumnInputDialog.this.setExprBuilderDefaultSelection(expressionBuilder, expression);
                    if (expressionBuilder.open() == 0) {
                        text.setText(expressionBuilder.getResult().trim());
                    }
                }
            };
            return ControlProvider.createButton(composite, 8, (SelectionListener)listener);
        }

        private void setExprBuilderDefaultSelection(ExpressionBuilder expressionBuilder, String expression) {
            Object[] selection = null;
            String dataSets = DataSetExpressionProvider.DATASETS;
            DataSetHandle dsHandle = (DataSetHandle)DataSetComputedColumnsPage.this.getContainer().getModel();
            Object handle = this.getStructureOrHandle();
            if (handle instanceof ComputedColumnHandle) {
                try {
                    String columnName = ExpressionUtil.getColumnBindingName((String)expression);
                    DataSetViewData viewData = this.findDataSetViewData(columnName, dsHandle);
                    selection = new Object[]{dataSets, dsHandle, viewData};
                }
                catch (BirtException birtException) {
                    selection = new Object[]{dataSets, dsHandle};
                }
            } else {
                selection = new Object[]{dataSets, dsHandle};
            }
            expressionBuilder.setDefaultSelection(selection);
        }

        private DataSetViewData findDataSetViewData(String columnName, DataSetHandle handle) {
            if (columnName == null || columnName.trim().length() == 0) {
                return null;
            }
            DataSetViewData[] items = DataSetProvider.getCurrentInstance().getColumns(handle, false, true, true);
            int i = 0;
            while (i < items.length) {
                if (columnName.equals(items[i].getName())) {
                    return items[i];
                }
                ++i;
            }
            return null;
        }

        protected IStatus validateSemantics(Object structureOrHandle) {
            AggregationArgument aggrArgument = null;
            String columnName = this.txtColumnName.getText();
            String dataTypeName = DataSetComputedColumnsPage.this.getTypeName(this.cmbDataType.getText());
            IAggrFunction aggrFunc = this.getSelectedFunction();
            try {
                String funcName = aggrFunc != null ? aggrFunc.getName() : BLANK;
                String filter = this.txtFilter.getText();
                if (structureOrHandle instanceof ComputedColumnHandle) {
                    ComputedColumnHandle handle = (ComputedColumnHandle)structureOrHandle;
                    handle.setName(columnName);
                    handle.setDataType(dataTypeName);
                    handle.setAggregateFunction(funcName);
                    if (aggrFunc == null) {
                        handle.setExpression(this.txtParams[0].getText().trim());
                    } else {
                        handle.setExpression(BLANK);
                        handle.setFilterExpression(filter);
                        handle.clearArgumentList();
                        IParameterDefn[] params = aggrFunc.getParameterDefn();
                        int i = 0;
                        while (i < params.length) {
                            if (this.txtParams[i].getText().trim().length() != 0) {
                                aggrArgument = StructureFactory.createAggregationArgument();
                                aggrArgument.setName(params[i].getName());
                                aggrArgument.setValue(this.txtParams[i].getText().trim());
                                handle.addArgument(aggrArgument);
                            }
                            ++i;
                        }
                    }
                } else if (structureOrHandle instanceof ComputedColumn) {
                    ComputedColumn handle = (ComputedColumn)structureOrHandle;
                    handle.setName(columnName);
                    handle.setDataType(dataTypeName);
                    handle.setAggregateFunction(funcName);
                    if (aggrFunc == null) {
                        handle.setExpression(this.txtParams[0].getText().trim());
                    } else {
                        handle.setExpression(BLANK);
                        handle.setFilterExpression(filter);
                        IParameterDefn[] params = aggrFunc.getParameterDefn();
                        int i = 0;
                        while (i < params.length) {
                            if (this.txtParams[i].getText().trim().length() != 0) {
                                aggrArgument = StructureFactory.createAggregationArgument();
                                aggrArgument.setName(params[i].getName());
                                aggrArgument.setValue(this.txtParams[i].getText().trim());
                                handle.addArgument(aggrArgument);
                            }
                            ++i;
                        }
                    }
                    this.updateComputedColumns(handle);
                }
            }
            catch (Exception e) {
                Status status = new Status(4, "org.eclipse.birt.report.designer.ui", BLANK, (Throwable)e);
                return status;
            }
            return this.getOKStatus();
        }

        private IAggrFunction getSelectedFunction() {
            int index = this.cmbAggregation.getSelectionIndex();
            return index > 0 ? this.functions[index - 1] : null;
        }

        private void updateComputedColumns(ComputedColumn handle) {
            DataSetHandle dataSet = ((DataSetEditor)DataSetComputedColumnsPage.this.getContainer()).getHandle();
            DataSetViewData[] items = DataSetProvider.getCurrentInstance().getColumns(dataSet, false, true, true);
            int count = items.length;
            DataSetViewData[] newItems = new DataSetViewData[count + 1];
            System.arraycopy(items, 0, newItems, 0, count);
            newItems[count] = new DataSetViewData();
            newItems[count].setName(handle.getName());
            newItems[count].setDataTypeName(handle.getDataType());
            newItems[count].setAlias(handle.getDisplayName());
            newItems[count].setComputedColumn(true);
            newItems[count].setPosition(count + 1);
            newItems[count].setDataType(DataAdapterUtil.adaptModelDataType((String)handle.getDataType()));
            DataSetProvider.getCurrentInstance().updateColumnsOfDataSetHandle(dataSet, newItems);
        }

        protected IStatus validateSyntax(Object structureOrHandle) {
            if (!this.isUniqueColumnName()) {
                return this.getMiscStatus(4, Messages.getString((String)"DataSetComputedColumnsPage.duplicatedName"));
            }
            if (this.isBlankProperty(this.txtColumnName.getText())) {
                return this.getBlankPropertyStatus(dialogLabels[0]);
            }
            if (this.isBlankProperty(this.cmbDataType.getText())) {
                return this.getBlankPropertyStatus(dialogLabels[1]);
            }
            IAggrFunction aggrFunc = this.getSelectedFunction();
            if (aggrFunc != null) {
                IParameterDefn[] paramDefns = aggrFunc.getParameterDefn();
                int i = 0;
                while (i < paramDefns.length) {
                    if (!paramDefns[i].isOptional() && this.isBlankProperty(this.txtParams[i].getText())) {
                        return this.getBlankPropertyStatus(paramDefns[i].getDisplayName());
                    }
                    ++i;
                }
            } else if (this.txtParams != null && this.isBlankProperty(this.txtParams[0].getText())) {
                return this.getBlankPropertyStatus(dialogLabels[2]);
            }
            try {
                if (this.cmbAggregation != null && this.cmbAggregation.getText().trim().length() > 0 && !this.checkExpressionBindingFields()) {
                    return this.getMiscStatus(4, Messages.getString((String)"DataSetComputedColumnsPage.InputDialog.message.error.AggregationExpression"));
                }
            }
            catch (BirtException birtException) {}
            return this.getOKStatus();
        }

        private boolean checkExpressionBindingFields() throws BirtException {
            int i = 0;
            while (i < this.txtParams.length) {
                IParameterDefn paramDefn;
                if (this.txtParams[i].getData() instanceof IParameterDefn && (paramDefn = (IParameterDefn)this.txtParams[i].getData()).isDataField()) {
                    String expr = this.txtParams[i].getText();
                    List columns = ExpressionUtil.extractColumnExpressions((String)expr, (String)"row");
                    columns.addAll(ExpressionUtil.extractColumnExpressions((String)expr, (String)"dataSetRow"));
                    int k = 0;
                    while (k < columns.size()) {
                        String columnName = ((IColumnBinding)columns.get(k)).getResultSetColumnName();
                        ComputedColumnHandle item = this.findComputedColumn(columnName);
                        if (item != null && item.getAggregateFunction() != null) {
                            return false;
                        }
                        ++k;
                    }
                }
                ++i;
            }
            return true;
        }

        private ComputedColumnHandle findComputedColumn(String name) {
            if (name == null || name.trim().length() == 0) {
                return null;
            }
            PropertyHandle properyHandle = ((DataSetEditor)DataSetComputedColumnsPage.this.getContainer()).getHandle().getPropertyHandle("computedColumns");
            if (properyHandle != null) {
                for (ComputedColumnHandle computedColumn : properyHandle) {
                    if (!name.equals(computedColumn.getName())) continue;
                    return computedColumn;
                }
            }
            return null;
        }

        private final boolean isUniqueColumnName() {
            DataSetViewData[] items = DataSetProvider.getCurrentInstance().getColumns(((DataSetEditor)DataSetComputedColumnsPage.this.getContainer()).getHandle(), true, true, true);
            int i = 0;
            while (i < items.length) {
                if (!items[i].getName().equals(this.columnName) && !items[i].isComputedColumn() && (items[i].getAlias() != null && items[i].getAlias().equals(this.txtColumnName.getText()) || items[i].getName() != null && items[i].getName().equals(this.txtColumnName.getText()))) {
                    return false;
                }
                ++i;
            }
            Iterator iter = DataSetComputedColumnsPage.this.computedColumns.iterator();
            if (iter != null) {
                while (iter.hasNext()) {
                    ComputedColumnHandle handle = (ComputedColumnHandle)iter.next();
                    if (DataSetComputedColumnsPage.this.getStructure(this.getStructureOrHandle()) == handle.getStructure() || !handle.getName().equals(this.txtColumnName.getText())) continue;
                    return false;
                }
            }
            for (ColumnHintHandle hint : ((DataSetHandle)DataSetComputedColumnsPage.this.getContainer().getModel()).getPropertyHandle("columnHints")) {
                if (hint.getColumnName().equals(this.columnName) || !this.txtColumnName.getText().equals(hint.getAlias()) && !this.txtColumnName.getText().equals(hint.getColumnName())) continue;
                return false;
            }
            return true;
        }

        protected void rollback() {
        }

        protected String getTitle() {
            if (this.getStructureOrHandle() instanceof Structure) {
                return Messages.getString((String)"DataSetComputedColumnsPage.InputDialog.title.New");
            }
            return Messages.getString((String)"DataSetComputedColumnsPage.InputDialog.title.Edit");
        }
    }

    protected static class DummyParamDefn
    implements IParameterDefn {
        String name;
        String displayName;
        String description = "";
        boolean isDataField;
        boolean isOptional;

        public DummyParamDefn(String name, String displayName, boolean isOptional, boolean isDataField) {
            this.name = name;
            this.displayName = displayName;
            this.isDataField = isDataField;
            this.isOptional = isOptional;
        }

        public String getDescription() {
            return this.description;
        }

        public String getDisplayName() {
            return this.displayName;
        }

        public boolean isDataField() {
            return this.isDataField;
        }

        public boolean isOptional() {
            return this.isOptional;
        }

        public boolean supportDataType(int dataType) {
            return true;
        }

        public String getName() {
            return this.name;
        }
    }

    private class TableProvider
    implements ITableLabelProvider {
        private TableProvider() {
        }

        public Image getColumnImage(Object element, int columnIndex) {
            return null;
        }

        public String getColumnText(Object element, int columnIndex) {
            String value = null;
            ComputedColumn computedColumn = DataSetComputedColumnsPage.this.getStructure(element);
            try {
                switch (columnIndex) {
                    case 0: {
                        value = computedColumn.getName();
                        break;
                    }
                    case 1: {
                        value = DataSetComputedColumnsPage.this.getTypeDisplayName(computedColumn.getDataType());
                        break;
                    }
                    case 2: {
                        ComputedColumnHandle handle = (ComputedColumnHandle)computedColumn.getHandle((SimpleValueHandle)DataSetComputedColumnsPage.this.computedColumns);
                        Iterator iterator = handle.argumentsIterator();
                        if (iterator.hasNext()) {
                            AggregationArgumentHandle argHandle = (AggregationArgumentHandle)iterator.next();
                            value = argHandle.getValue();
                        }
                        if (value == null) {
                            value = computedColumn.getExpression();
                        }
                        break;
                    }
                    case 3: {
                        value = computedColumn.getAggregateFunction();
                        IAggrFunction aggrFunc = DataSetComputedColumnsPage.this.aggregationManager.getAggregation(value);
                        value = aggrFunc != null ? aggrFunc.getDisplayName() : value;
                        break;
                    }
                    case 4: {
                        value = computedColumn.getFilterExpression();
                    }
                }
            }
            catch (Exception e) {
                ExceptionHandler.handle((Throwable)e);
            }
            return value == null ? "" : value;
        }

        public void addListener(ILabelProviderListener listener) {
        }

        public void dispose() {
        }

        public boolean isLabelProperty(Object element, String property) {
            return false;
        }

        public void removeListener(ILabelProviderListener listener) {
        }
    }

    private class ViewerSelectionListener
    implements ISelectionChangedListener {
        private ViewerSelectionListener() {
        }

        public void selectionChanged(SelectionChangedEvent event) {
            DataSetComputedColumnsPage.this.setPageProperties();
        }
    }
}

