/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.chart.ui.swt.wizard.format.popup;

import org.eclipse.birt.chart.model.attribute.ScaleUnitType;
import org.eclipse.birt.chart.model.component.ComponentPackage;
import org.eclipse.birt.chart.model.component.Scale;
import org.eclipse.birt.chart.model.data.DataElement;
import org.eclipse.birt.chart.model.data.DateTimeDataElement;
import org.eclipse.birt.chart.ui.extension.i18n.Messages;
import org.eclipse.birt.chart.ui.swt.ChartCheckbox;
import org.eclipse.birt.chart.ui.swt.ChartCombo;
import org.eclipse.birt.chart.ui.swt.composites.TextEditorComposite;
import org.eclipse.birt.chart.ui.swt.interfaces.IDataElementComposite;
import org.eclipse.birt.chart.ui.swt.wizard.ChartWizardContext;
import org.eclipse.birt.chart.ui.swt.wizard.format.popup.AbstractPopupSheet;
import org.eclipse.birt.chart.ui.util.ChartUIUtil;
import org.eclipse.birt.chart.util.LiteralHelper;
import org.eclipse.birt.chart.util.NameSet;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Spinner;

public abstract class AbstractScaleSheet
extends AbstractPopupSheet
implements Listener,
SelectionListener {
    protected Label lblMin = null;
    protected IDataElementComposite txtScaleMin = null;
    protected Label lblMax = null;
    protected IDataElementComposite txtScaleMax = null;
    protected Button btnStepSize = null;
    protected Button btnStepNumber = null;
    protected Button btnStepAuto = null;
    protected Button btnFactor = null;
    protected TextEditorComposite txtFactor = null;
    protected TextEditorComposite txtStepSize = null;
    protected Label lblUnit = null;
    protected ChartCombo cmbScaleUnit = null;
    protected Label lblStepNumber = null;
    protected Spinner spnStepNumber = null;
    protected ChartCheckbox btnAutoExpand;
    protected ChartCheckbox btnShowOutside;

    public AbstractScaleSheet(String title, ChartWizardContext context) {
        super(title, context, true);
    }

    protected Composite getComponent(Composite parent) {
        ChartUIUtil.bindHelp((Control)parent, (String)"org.eclipse.birt.chart.cshelp.Scale_ID");
        Composite cmpContent = new Composite(parent, 0);
        GridLayout glContent = new GridLayout(4, false);
        glContent.marginHeight = 10;
        glContent.marginWidth = 10;
        glContent.horizontalSpacing = 5;
        glContent.verticalSpacing = 10;
        cmpContent.setLayout((Layout)glContent);
        Group grpScale = new Group(cmpContent, 0);
        GridData gdGRPScale = new GridData(1808);
        gdGRPScale.horizontalSpan = 4;
        grpScale.setLayoutData((Object)gdGRPScale);
        GridLayout glScale = new GridLayout();
        glScale.numColumns = 4;
        glScale.horizontalSpacing = 5;
        glScale.verticalSpacing = 5;
        glScale.marginHeight = 2;
        glScale.marginWidth = 7;
        grpScale.setLayout((Layout)glScale);
        grpScale.setText(Messages.getString("AbstractScaleSheet.Label.Step"));
        this.btnStepAuto = new Button((Composite)grpScale, 16);
        GridData gd = new GridData();
        gd.horizontalSpan = 4;
        this.btnStepAuto.setLayoutData((Object)gd);
        this.btnStepAuto.setText(Messages.getString("AbstractScaleSheet.Label.Auto"));
        this.btnStepAuto.addListener(13, (Listener)this);
        this.btnStepSize = new Button((Composite)grpScale, 16);
        this.btnStepSize.setText(Messages.getString("AbstractScaleSheet.Label.StepSize"));
        this.btnStepSize.addListener(13, (Listener)this);
        this.txtStepSize = new TextEditorComposite((Composite)grpScale, 2052, 1);
        gd = new GridData(768);
        gd.widthHint = 100;
        this.txtStepSize.setLayoutData(gd);
        String str = "";
        if (this.getScale().isSetStep()) {
            str = String.valueOf(this.getScale().getStep());
        }
        this.txtStepSize.setText(str);
        this.txtStepSize.addListener(this);
        this.txtStepSize.addListener(24, this);
        this.txtStepSize.setDefaultValue("");
        this.lblUnit = new Label((Composite)grpScale, 0);
        this.lblUnit.setText(Messages.getString("BaseAxisDataSheetImpl.Lbl.Unit"));
        this.cmbScaleUnit = this.getContext().getUIFactory().createChartCombo((Composite)grpScale, 12, (EObject)this.getScale(), "unit", this.getDefaultVauleScale().getUnit().getName());
        GridData gdCMBScaleUnit = new GridData(768);
        this.cmbScaleUnit.setLayoutData((Object)gdCMBScaleUnit);
        this.cmbScaleUnit.addListener(13, (Listener)this);
        NameSet ns = LiteralHelper.scaleUnitTypeSet;
        this.cmbScaleUnit.setItems(ns.getDisplayNames());
        this.cmbScaleUnit.setItemData(ns.getNames());
        this.cmbScaleUnit.setSelection(this.getScale().getUnit().getName());
        this.btnStepNumber = new Button((Composite)grpScale, 16);
        this.btnStepNumber.setText(Messages.getString("AbstractScaleSheet.Label.StepNumber"));
        this.btnStepNumber.addListener(13, (Listener)this);
        this.spnStepNumber = new Spinner((Composite)grpScale, 2048);
        this.spnStepNumber.setLayoutData((Object)new GridData(768));
        this.spnStepNumber.setMinimum(1);
        this.spnStepNumber.setMaximum(100);
        this.spnStepNumber.setSelection(this.getScale().getStepNumber());
        this.spnStepNumber.addListener(13, (Listener)this);
        new Label((Composite)grpScale, 0);
        new Label((Composite)grpScale, 0);
        this.btnFactor = new Button(cmpContent, 32);
        this.btnFactor.setText(Messages.getString("AbstractScaleSheet.Label.Factor"));
        gd = new GridData();
        gd.horizontalSpan = 2;
        this.btnFactor.setLayoutData((Object)gd);
        this.btnFactor.addListener(13, (Listener)this);
        if (this.getScale().isSetFactor()) {
            this.btnFactor.setSelection(true);
        } else {
            this.btnFactor.setSelection(false);
        }
        this.txtFactor = new TextEditorComposite(cmpContent, 2052, 1);
        gd = new GridData(768);
        gd.horizontalSpan = 2;
        this.txtFactor.setLayoutData(gd);
        str = "";
        if (this.getScale().isSetFactor()) {
            str = String.valueOf(this.getScale().getFactor());
        }
        this.txtFactor.setText(str);
        this.txtFactor.addListener(this);
        this.txtFactor.addListener(24, this);
        this.txtFactor.setDefaultValue("");
        this.lblMin = new Label(cmpContent, 0);
        this.lblMin.setText(Messages.getString("BaseAxisDataSheetImpl.Lbl.Minimum"));
        this.txtScaleMin = this.createValuePicker(cmpContent, this.getScale().getMin(), (EObject)this.getScale(), "min");
        this.lblMax = new Label(cmpContent, 0);
        this.lblMax.setText(Messages.getString("BaseAxisDataSheetImpl.Lbl.Maximum"));
        this.txtScaleMax = this.createValuePicker(cmpContent, this.getScale().getMax(), (EObject)this.getScale(), "max");
        this.btnAutoExpand = this.getContext().getUIFactory().createChartCheckbox(cmpContent, 0, this.getDefaultVauleScale().isAutoExpand());
        this.btnAutoExpand.setText(Messages.getString("AbstractScaleSheet.AutoExpand"));
        gd = new GridData();
        gd.horizontalSpan = 4;
        this.btnAutoExpand.setLayoutData((Object)gd);
        this.btnAutoExpand.setSelectionState(this.getScale().isSetAutoExpand() ? (this.getScale().isAutoExpand() ? 1 : 2) : 0);
        this.btnAutoExpand.addSelectionListener((SelectionListener)this);
        this.btnShowOutside = this.getContext().getUIFactory().createChartCheckbox(cmpContent, 0, this.getDefaultVauleScale().isShowOutside());
        this.btnShowOutside.setText(Messages.getString("AbstractScaleSheet.Label.ShowValuesOutside"));
        gd = new GridData();
        gd.horizontalSpan = 4;
        this.btnShowOutside.setLayoutData((Object)gd);
        this.btnShowOutside.setSelectionState(this.getScale().isSetShowOutside() ? (this.getScale().isShowOutside() ? 1 : 2) : 0);
        this.btnShowOutside.addSelectionListener((SelectionListener)this);
        this.btnShowOutside.setVisible(this.getValueType() == 1);
        this.btnStepSize.setSelection(this.getScale().isSetStep());
        if (!this.btnStepSize.getSelection()) {
            if (this.getValueType() != 1) {
                this.btnStepAuto.setSelection(true);
            } else {
                this.btnStepNumber.setSelection(this.getScale().isSetStepNumber());
                this.btnStepAuto.setSelection(!this.getScale().isSetStep() && !this.getScale().isSetStepNumber());
            }
        }
        this.setState();
        if (this.getValueType() == 2) {
            parent.getShell().addListener(21, new Listener(){

                public void handleEvent(Event event) {
                    if (event.type == 21) {
                        DataElement data = AbstractScaleSheet.this.txtScaleMin.getDataElement();
                        if (data == null) {
                            AbstractScaleSheet.this.getScale().eUnset((EStructuralFeature)ComponentPackage.eINSTANCE.getScale_Min());
                        } else {
                            AbstractScaleSheet.this.getScale().setMin(data);
                        }
                        data = AbstractScaleSheet.this.txtScaleMax.getDataElement();
                        if (data == null) {
                            AbstractScaleSheet.this.getScale().eUnset((EStructuralFeature)ComponentPackage.eINSTANCE.getScale_Max());
                        } else {
                            AbstractScaleSheet.this.getScale().setMax(data);
                        }
                        AbstractScaleSheet.this.setState();
                    }
                }
            });
        }
        return cmpContent;
    }

    protected void setState(boolean bEnabled) {
        this.btnStepSize.setEnabled(bEnabled);
        this.txtStepSize.setEnabled(bEnabled && this.btnStepSize.getSelection());
        this.btnStepNumber.setEnabled(bEnabled && this.getValueType() == 1);
        this.spnStepNumber.setEnabled(bEnabled && this.btnStepNumber.getSelection() && this.getValueType() == 1);
        this.btnFactor.setEnabled(false);
        this.txtFactor.setEnabled(false);
        this.lblMin.setEnabled(bEnabled);
        this.lblMax.setEnabled(bEnabled);
        this.txtScaleMin.setEnabled(bEnabled);
        this.txtScaleMax.setEnabled(bEnabled);
        this.btnShowOutside.setEnabled(bEnabled && (this.getScale().eIsSet((EStructuralFeature)ComponentPackage.eINSTANCE.getScale_Min()) || this.getScale().eIsSet((EStructuralFeature)ComponentPackage.eINSTANCE.getScale_Max())));
        this.lblUnit.setEnabled(bEnabled && this.btnStepSize.getSelection() && this.getValueType() == 2);
        this.cmbScaleUnit.setEnabled(bEnabled && this.btnStepSize.getSelection() && this.getValueType() == 2);
    }

    protected void setState() {
        this.setState(true);
    }

    protected IDataElementComposite createValuePicker(Composite parent, DataElement data, EObject eParent, String sProperty) {
        IDataElementComposite picker = null;
        if (this.getValueType() == 1 || this.getValueType() == 0) {
            try {
                picker = this.getContext().getUIFactory().createNumberDataElementComposite(parent, data, eParent, sProperty);
            }
            catch (Exception exception) {
                picker = this.getContext().getUIFactory().createNumberDataElementComposite(parent, null, eParent, sProperty);
            }
        } else if (this.getValueType() == 2) {
            try {
                picker = this.getContext().getUIFactory().createDateTimeDataElementComposite(parent, 2048, (DateTimeDataElement)data, true, eParent, sProperty);
            }
            catch (Exception exception) {
                picker = this.getContext().getUIFactory().createDateTimeDataElementComposite(parent, 2048, null, true, eParent, sProperty);
            }
        }
        if (picker != null) {
            GridData gd = new GridData(768);
            gd.horizontalSpan = 3;
            picker.setLayoutData((Object)gd);
            picker.addListener((Listener)this);
        }
        return picker;
    }

    public void handleEvent(Event event) {
        block36: {
            if (event.widget.equals(this.txtScaleMin)) {
                DataElement data = this.txtScaleMin.getDataElement();
                if (data == null) {
                    this.getScale().eUnset((EStructuralFeature)ComponentPackage.eINSTANCE.getScale_Min());
                } else {
                    this.getScale().setMin(data);
                }
                this.setState();
            } else if (event.widget.equals(this.txtScaleMax)) {
                DataElement data = this.txtScaleMax.getDataElement();
                if (data == null) {
                    this.getScale().eUnset((EStructuralFeature)ComponentPackage.eINSTANCE.getScale_Max());
                } else {
                    this.getScale().setMax(data);
                }
                this.setState();
            } else if (event.widget.equals((Object)this.txtStepSize)) {
                try {
                    if (this.txtStepSize.getText().length() == 0) {
                        this.getScale().eUnset((EStructuralFeature)ComponentPackage.eINSTANCE.getScale_Step());
                        break block36;
                    }
                    double dbl = Double.valueOf(this.txtStepSize.getText());
                    if (dbl == 0.0) {
                        this.getScale().eUnset((EStructuralFeature)ComponentPackage.eINSTANCE.getScale_Step());
                        break block36;
                    }
                    this.getScale().setStep(dbl);
                }
                catch (NumberFormatException numberFormatException) {
                    this.txtStepSize.setText(String.valueOf(this.getScale().getStep()));
                }
            } else if (event.widget.equals(this.cmbScaleUnit)) {
                String selectedScale = this.cmbScaleUnit.getSelectedItemData();
                if (selectedScale != null) {
                    this.getScale().setUnit(ScaleUnitType.getByName((String)selectedScale));
                }
            } else if (event.widget.equals(this.btnStepAuto)) {
                this.getScale().unsetStepNumber();
                this.getScale().unsetStep();
                this.setState();
            } else if (event.widget.equals(this.btnStepSize)) {
                this.getScale().unsetStepNumber();
                this.txtStepSize.notifyListeners(24, null);
                this.setState();
            } else if (event.widget.equals(this.btnStepNumber)) {
                this.getScale().unsetStep();
                this.getScale().setStepNumber(this.spnStepNumber.getSelection());
                this.setState();
            } else if (event.widget.equals(this.spnStepNumber)) {
                this.getScale().setStepNumber(this.spnStepNumber.getSelection());
            } else if (event.widget == this.btnFactor) {
                if (this.btnFactor.getSelection()) {
                    this.getScale().unsetStepNumber();
                    this.txtFactor.notifyListeners(24, null);
                } else {
                    this.getScale().unsetFactor();
                }
                this.setState();
            } else if (event.widget == this.txtFactor) {
                try {
                    if (this.txtFactor.getText().length() == 0) {
                        this.getScale().eUnset((EStructuralFeature)ComponentPackage.eINSTANCE.getScale_Factor());
                    } else {
                        double dbl = Double.valueOf(this.txtFactor.getText());
                        if (dbl == 0.0) {
                            this.getScale().eUnset((EStructuralFeature)ComponentPackage.eINSTANCE.getScale_Factor());
                        } else {
                            this.getScale().setFactor(dbl);
                        }
                    }
                }
                catch (NumberFormatException numberFormatException) {
                    this.txtFactor.setText(String.valueOf(this.getScale().getFactor()));
                }
            }
        }
    }

    public void widgetDefaultSelected(SelectionEvent arg0) {
    }

    public void widgetSelected(SelectionEvent event) {
        if (event.widget == this.btnShowOutside) {
            if (this.btnShowOutside.getSelectionState() == 0) {
                this.getScale().unsetShowOutside();
            } else {
                this.getScale().setShowOutside(this.btnShowOutside.getSelectionState() == 1);
            }
        } else if (event.widget == this.btnAutoExpand) {
            if (this.btnAutoExpand.getSelectionState() == 0) {
                this.getScale().unsetAutoExpand();
            } else {
                this.getScale().setAutoExpand(this.btnAutoExpand.getSelectionState() == 1);
            }
        }
    }

    protected abstract Scale getScale();

    protected abstract Scale getDefaultVauleScale();

    protected abstract int getValueType();
}

