/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.chart.ui.swt.series;

import org.eclipse.birt.chart.exception.ChartException;
import org.eclipse.birt.chart.log.ILogger;
import org.eclipse.birt.chart.log.Logger;
import org.eclipse.birt.chart.model.attribute.Fill;
import org.eclipse.birt.chart.model.component.Series;
import org.eclipse.birt.chart.model.type.DialSeries;
import org.eclipse.birt.chart.model.type.impl.DialSeriesImpl;
import org.eclipse.birt.chart.model.util.ChartElementUtil;
import org.eclipse.birt.chart.ui.extension.i18n.Messages;
import org.eclipse.birt.chart.ui.swt.AbstractChartIntSpinner;
import org.eclipse.birt.chart.ui.swt.AbstractChartNumberEditor;
import org.eclipse.birt.chart.ui.swt.composites.FillChooserComposite;
import org.eclipse.birt.chart.ui.swt.fieldassist.TextNumberEditorAssistField;
import org.eclipse.birt.chart.ui.swt.wizard.ChartWizardContext;
import org.eclipse.birt.chart.ui.util.ChartUIExtensionUtil;
import org.eclipse.birt.chart.ui.util.ChartUIUtil;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Listener;

public class MeterSeriesAttributeComposite
extends Composite
implements Listener,
ModifyListener {
    private AbstractChartNumberEditor txtRadius = null;
    private AbstractChartIntSpinner iscStartAngle = null;
    private AbstractChartIntSpinner iscStopAngle = null;
    private DialSeries series = null;
    private FillChooserComposite fcc = null;
    private ChartWizardContext wizardContext;
    private static ILogger logger = Logger.getLogger((String)"org.eclipse.birt.chart.ui.extension/swt.series");

    public MeterSeriesAttributeComposite(Composite parent, int style, ChartWizardContext wizardContext, Series series) {
        super(parent, style);
        if (!(series instanceof DialSeriesImpl)) {
            try {
                throw new ChartException("org.eclipse.birt.chart.ui.extension", 30, "MeterSeriesAttributeComposite.Exception.IllegalArgument", new Object[]{series.getClass().getName()}, Messages.getResourceBundle());
            }
            catch (ChartException e) {
                logger.log((Exception)((Object)e));
                e.printStackTrace();
            }
        }
        this.series = (DialSeries)series;
        this.wizardContext = wizardContext;
        this.init();
        this.placeComponents();
        ChartUIUtil.bindHelp((Control)parent, (String)"org.eclipse.birt.chart.cshelp.FormatMeterChartYSeries_ID");
    }

    private void init() {
        this.setSize(this.getParent().getClientArea().width, this.getParent().getClientArea().height);
    }

    private void placeComponents() {
        GridLayout glContent = new GridLayout(2, true);
        glContent.verticalSpacing = 0;
        glContent.horizontalSpacing = 10;
        glContent.marginHeight = 7;
        glContent.marginWidth = 7;
        this.setLayout((Layout)glContent);
        Composite cmpLeft = new Composite((Composite)this, 0);
        GridData gdLeft = new GridData(768);
        cmpLeft.setLayoutData((Object)gdLeft);
        GridLayout gl = new GridLayout(3, false);
        gl.horizontalSpacing = 8;
        cmpLeft.setLayout((Layout)gl);
        Label lblRadius = new Label(cmpLeft, 0);
        GridData gdLBLRadius = new GridData(128);
        lblRadius.setLayoutData((Object)gdLBLRadius);
        lblRadius.setText(Messages.getString("MeterSeriesAttributeComposite.Lbl.Radius"));
        this.txtRadius = this.wizardContext.getUIFactory().createChartNumberEditor(cmpLeft, 2052, null, (EObject)this.series.getDial(), "radius");
        new TextNumberEditorAssistField(this.txtRadius.getTextControl(), null);
        GridData gdTXTRadius = new GridData(768);
        gdTXTRadius.horizontalSpan = 2;
        if (this.series.getDial().isSetRadius()) {
            this.txtRadius.setValue(this.series.getDial().getRadius());
        }
        this.txtRadius.setLayoutData((Object)gdTXTRadius);
        this.txtRadius.addModifyListener((ModifyListener)this);
        Label lblFill = new Label(cmpLeft, 0);
        GridData gdFill = new GridData(128);
        lblFill.setLayoutData((Object)gdFill);
        lblFill.setText(Messages.getString("MeterSeriesAttributeSheetImpl.Lbl.Fill"));
        int fillStyles = 27;
        this.fcc = new FillChooserComposite(cmpLeft, 0, fillStyles |= this.wizardContext.getUIFactory().supportAutoUI() ? 4 : fillStyles, this.wizardContext, this.series.getDial().getFill());
        GridData gd = new GridData(768);
        gd.horizontalSpan = 2;
        this.fcc.setLayoutData(gd);
        this.fcc.addListener(this);
        Composite cmpRight = new Composite((Composite)this, 0);
        GridData gdRight = new GridData(768);
        cmpRight.setLayoutData((Object)gdRight);
        gl = new GridLayout(3, false);
        gl.horizontalSpacing = 8;
        cmpRight.setLayout((Layout)gl);
        Label lblStartAngle = new Label(cmpRight, 0);
        GridData gdLBLStartAngle = new GridData(128);
        lblStartAngle.setLayoutData((Object)gdLBLStartAngle);
        lblStartAngle.setText(Messages.getString("MeterSeriesAttributeComposite.Lbl.StartAngle"));
        this.iscStartAngle = this.wizardContext.getUIFactory().createChartIntSpinner(cmpRight, 0, (int)this.series.getDial().getStartAngle(), (EObject)this.series.getDial(), "startAngle", true);
        GridData gdISCStartAngle = new GridData(768);
        gdISCStartAngle.horizontalSpan = 2;
        this.iscStartAngle.setLayoutData((Object)gdISCStartAngle);
        this.iscStartAngle.setValue((int)this.series.getDial().getStartAngle());
        this.iscStartAngle.setMinimum(-360);
        this.iscStartAngle.setMaximum(360);
        this.iscStartAngle.addListener((Listener)this);
        Label lblStopAngle = new Label(cmpRight, 0);
        GridData gdLBLStopAngle = new GridData(128);
        lblStopAngle.setLayoutData((Object)gdLBLStopAngle);
        lblStopAngle.setText(Messages.getString("MeterSeriesAttributeComposite.Lbl.StopAngle"));
        this.iscStopAngle = this.wizardContext.getUIFactory().createChartIntSpinner(cmpRight, 0, (int)this.series.getDial().getStopAngle(), (EObject)this.series.getDial(), "stopAngle", true);
        GridData gdISCStopAngle = new GridData(768);
        gdISCStopAngle.horizontalSpan = 2;
        this.iscStopAngle.setLayoutData((Object)gdISCStopAngle);
        this.iscStopAngle.setValue((int)this.series.getDial().getStopAngle());
        this.iscStopAngle.setMinimum(-360);
        this.iscStopAngle.setMaximum(360);
        this.iscStopAngle.addListener((Listener)this);
    }

    public void modifyText(ModifyEvent e) {
        if (e.widget.equals(this.txtRadius) && !"Reset".equals(e.data)) {
            if (this.txtRadius.isSetValue()) {
                this.series.getDial().setRadius(this.txtRadius.getValue());
            } else {
                this.series.getDial().unsetRadius();
            }
        }
    }

    public void handleEvent(Event event) {
        if (event.widget.equals(this.iscStartAngle)) {
            ChartElementUtil.setEObjectAttribute((EObject)this.series.getDial(), (String)"startAngle", (Object)((Integer)event.data).doubleValue(), (event.detail == ChartUIExtensionUtil.PROPERTY_UNSET ? 1 : 0) != 0);
        } else if (event.widget.equals(this.iscStopAngle)) {
            ChartElementUtil.setEObjectAttribute((EObject)this.series.getDial(), (String)"stopAngle", (Object)((Integer)event.data).doubleValue(), (event.detail == ChartUIExtensionUtil.PROPERTY_UNSET ? 1 : 0) != 0);
        } else if (event.widget.equals((Object)this.fcc)) {
            this.series.getDial().setFill((Fill)event.data);
        }
    }
}

