/*
 * Decompiled with CFR 0.152.
 */
package hiro.yoshioka.ui.view.internal;

import hiro.yoshioka.chart.ChartInfo;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.eclipse.birt.chart.model.Chart;

public abstract class AbstractChartBuilder {
    protected Log log = LogFactory.getLog(this.getClass());
    protected static final String FONT_NAME = "MS Sans Serif";
    protected ChartInfo chartInfo = null;
    protected Chart chart = null;
    protected String title = null;

    public AbstractChartBuilder(ChartInfo chartInfo) {
        this.chartInfo = chartInfo;
        this.title = chartInfo.title;
    }

    public void build() {
        this.createChart();
        this.buildPlot();
        this.buildLegend();
        this.buildTitle();
        this.buildXAxis();
        this.buildYAxis();
        this.buildXSeries();
        this.buildYSeries();
    }

    protected abstract void createChart();

    protected void buildPlot() {
    }

    protected void buildXAxis() {
    }

    protected void buildYAxis() {
    }

    protected void buildXSeries() {
    }

    protected void buildYSeries() {
    }

    protected void buildLegend() {
    }

    protected void buildTitle() {
        this.chart.getTitle().getLabel().getCaption().setValue(this.title);
        this.chart.getTitle().getLabel().getCaption().getFont().setSize(14.0f);
        this.chart.getTitle().getLabel().getCaption().getFont().setName(FONT_NAME);
    }

    public Chart getChart() {
        return this.chart;
    }
}

