/*
 * Decompiled with CFR 0.152.
 */
package hiro.yoshioka.ui.action;

import hiro.yoshioka.sql.IRequestListener;
import hiro.yoshioka.sql.engine.DominoTransactionRequest;
import hiro.yoshioka.sql.engine.Request;
import hiro.yoshioka.sql.engine.SQLOperationType;
import hiro.yoshioka.sql.engine.SQLServerThread;
import hiro.yoshioka.sql.notes.ddl.ACL;
import hiro.yoshioka.sql.params.ConnectionProperties;
import hiro.yoshioka.sql.resource.IDBSchema;
import hiro.yoshioka.ui.action.Messages;
import hiro.yoshioka.ui.action.SQLAction;
import hiro.yoshioka.ui.view.ExplorerView;
import hiro.yoshioka.util.FileUtil;
import hiro.yoshioka.util.StringUtil;
import hiro.yoshioka.wolfdbmanager.Application;
import java.io.File;
import java.io.IOException;
import java.util.Date;
import org.eclipse.swt.program.Program;

public class ShowACLAction
extends SQLAction {
    ExplorerView view;
    IDBSchema schema;
    static String TEXT = "Show ACL";
    static String TOOL_TIP = "Show ACL";

    public ShowACLAction(ExplorerView view, ConnectionProperties connectionProperties, IDBSchema schema) {
        super(SQLOperationType.SHOW_ACL, 1, connectionProperties);
        this.view = view;
        this.schema = schema;
        this.configureAction(TEXT, TOOL_TIP, null);
    }

    @Override
    public void run() {
        try {
            try {
                this.setEnabled(false);
                SQLServerThread.getSQLServer().getConnectionSettingBean().getConnectionList();
                DominoTransactionRequest req = new DominoTransactionRequest(this.fOperation, this.connectionProperties, null);
                this.fRequest = req;
                req.setSchema(this.schema);
                req.addListener((IRequestListener)this);
                SQLServerThread.putRequest((Request)req);
            }
            catch (RuntimeException e) {
                this.fLogger.error((Object)"", (Throwable)e);
                if (this.finalClearConnectionFlg) {
                    this.connectionProperties = null;
                }
                this.setEnabled(true);
            }
        }
        finally {
            if (this.finalClearConnectionFlg) {
                this.connectionProperties = null;
            }
            this.setEnabled(true);
        }
    }

    @Override
    public void called_done(Request request, SQLOperationType operation, ConnectionProperties properteis, Object o) {
        Application.setStatus(String.format(Messages.getString("ConnectAction.result_message"), new Date(), properteis.getDisplayString(), operation.name(), request.result));
        Throwable ex = this.fRequest.getException();
        if (ex != null) {
            Application.openErrorDialog(null, String.format(Messages.getString("ConnectAction.error_message"), properteis.getDisplayString()), ex);
        }
        DominoTransactionRequest req = (DominoTransactionRequest)request;
        ACL acl = req.getAcl();
        try {
            File f = File.createTempFile("acl_" + this.schema.getName(), ".html");
            FileUtil.writeFile((File)f, (String)acl.getHtml(), (String)StringUtil.DEFAULT_ENCODING);
            Program.launch((String)f.getAbsolutePath());
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }
}

