/*
 * Decompiled with CFR 0.152.
 */
package hiro.yoshioka.ui.action;

import hiro.yoshioka.sql.resource.IDBColumn;
import hiro.yoshioka.sql.resource.IDBResource;
import hiro.yoshioka.sql.resource.IDBSchema;
import hiro.yoshioka.sql.resource.IDBTable;
import hiro.yoshioka.ui.action.CreateSQLToClipAction;
import hiro.yoshioka.ui.view.ExplorerView;
import hiro.yoshioka.util.StringUtil;
import java.util.Iterator;
import org.eclipse.jface.viewers.IStructuredSelection;

public class CreateDMLSQLToClipAction
extends CreateSQLToClipAction {
    public static final int SELECT = 10;
    public static final int INSERT = 20;
    public static final int UPDATE = 30;
    public static final int TRUNCATE = 500;

    public CreateDMLSQLToClipAction(ExplorerView view, int kind) {
        super(view, kind);
    }

    @Override
    protected void selectionChangedAfter() {
        if (this.isEnabled()) {
            if (this.fSQL_KIND <= 30) {
                if (this.fSelectionResource instanceof IDBSchema) {
                    this.setEnabled(false);
                }
            } else if (!(this.fSQL_KIND != 500 || this.fSelectionResource instanceof IDBTable || !this.fSelection.hasMultiResource() && this.fSelectionResource instanceof IDBSchema)) {
                this.setEnabled(false);
            }
        }
    }

    @Override
    public void run() {
        StringBuffer buf = new StringBuffer();
        String string = this.getSelectionString();
        boolean quot = false;
        switch (this.fSQL_KIND) {
            case 10: {
                buf.append("SELECT" + StringUtil.LINE_SEPARATOR);
                if (this.fSelectionResource instanceof IDBColumn) {
                    buf.append(string);
                } else {
                    buf.append("  * ");
                }
                buf.append("\nFROM\n").append("  ").append(this.fHelper.getTables(quot));
                break;
            }
            case 20: {
                buf.append("INSERT INTO ").append(this.fHelper.getTables(quot));
                buf.append(" (").append(string).append(") \n VALUES(");
                buf.append(" ) \n ");
                break;
            }
            case 30: {
                buf.append("UPDATE ").append(this.fHelper.getTables(quot));
                buf.append("\n SET").append(string);
                break;
            }
            case 500: {
                if (this.fSelectionResource instanceof IDBSchema) {
                    IDBTable[] tables = ((IDBSchema)this.fSelectionResource).getTableOrViews();
                    if (tables.length == 1) {
                        buf.append("TRUNCATE TABLE ").append(this.fSelectionResource.getUName());
                        break;
                    }
                    if (tables.length <= 1) break;
                    int i = 0;
                    while (i < tables.length) {
                        buf.append("TRUNCATE TABLE ").append(tables[i].getUName()).append(";\n");
                        ++i;
                    }
                    break;
                }
                if (!(this.fSelectionResource instanceof IDBTable)) break;
                IStructuredSelection sel = (IStructuredSelection)this.fView.getTreeViewer().getSelection();
                if (sel.size() > 1) {
                    Iterator ite = sel.iterator();
                    while (ite.hasNext()) {
                        buf.append("TRUNCATE TABLE ").append(((IDBResource)ite.next()).getUName()).append(";\n");
                    }
                    break;
                }
                buf.append("TRUNCATE TABLE ").append(this.fSelectionResource.getUName());
            }
        }
        this.setContents(buf.toString());
    }
}

