/*
 * Decompiled with CFR 0.152.
 */
package hiro.yoshioka.sql.ui.editor;

import hiro.yoshioka.ast.sql.RowColumn;
import hiro.yoshioka.ast.sql.util.ASTProposalableAssist;
import hiro.yoshioka.ast.sql.util.IProposalableParserUtil;
import hiro.yoshioka.sql.ui.editor.ISQLTemplateContext;
import hiro.yoshioka.util.StringUtil;
import hiro.yoshioka.wolfdbmanager.Application;
import hiro.yoshioka.wolfdbmanager.resource.ImageManager;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Vector;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.eclipse.jface.text.IRegion;
import org.eclipse.jface.text.ITextViewer;
import org.eclipse.jface.text.TextPresentation;
import org.eclipse.jface.text.contentassist.ICompletionProposal;
import org.eclipse.jface.text.contentassist.IContextInformation;
import org.eclipse.jface.text.contentassist.IContextInformationPresenter;
import org.eclipse.jface.text.contentassist.IContextInformationValidator;
import org.eclipse.jface.text.templates.GlobalTemplateVariables;
import org.eclipse.jface.text.templates.Template;
import org.eclipse.jface.text.templates.TemplateCompletionProcessor;
import org.eclipse.jface.text.templates.TemplateContextType;
import org.eclipse.jface.text.templates.TemplateVariableResolver;
import org.eclipse.jface.text.templates.persistence.TemplateStore;
import org.eclipse.swt.custom.StyledText;
import org.eclipse.swt.graphics.Image;

public class SQLCompletionProcessorUsingAST
extends TemplateCompletionProcessor
implements ISQLTemplateContext {
    private Log fLogger = LogFactory.getLog(this.getClass());
    protected Vector _proposalsList = new Vector();
    protected IContextInformationValidator fValidator = new Validator();
    private TemplateStore _templateStore;
    private static final Template[] DEFAULT_TEMPLATE = new Template[0];
    private List fExpectedTemplateList = new ArrayList();
    private List expectedListInTokenManager = new ArrayList();
    String fBackString;

    private void initialComputeCompletionProposals(ITextViewer viewer, int documentOffset) {
        this.expectedListInTokenManager.clear();
        this._proposalsList.clear();
        try {
            IProposalableParserUtil util = Application.getActiveSQLEditor().getUtil(true);
            StyledText stext = viewer.getTextWidget();
            int line_num = stext.getLineCount();
            int line_offset = 0;
            int i = 0;
            while (i < line_num) {
                int first_offset = stext.getOffsetAtLine(i);
                if (stext.getCaretOffset() - first_offset < 0) break;
                line_offset = stext.getCaretOffset() - first_offset;
                ++i;
            }
            RowColumn p = new RowColumn(stext.getLineAtOffset(stext.getCaretOffset()) + 1, line_offset + 1);
            util.setRowColumn(p);
            util.parse();
            ASTProposalableAssist assist = util.getASTProposalableAssist();
            this.fBackString = util.getBackWord().getLastWord();
            this.fExpectedTemplateList.clear();
            String[] keys = assist.getKeyWords(util.getBackWord());
            int i2 = 0;
            while (i2 < keys.length) {
                String keyword = keys[i2];
                if (!this.hasTemplate(keyword)) {
                    this.expectedListInTokenManager.add(keyword);
                }
                ++i2;
            }
            this._proposalsList.addAll(assist.getProposalList());
            viewer.getTextWidget().redraw();
        }
        catch (Throwable e) {
            e.printStackTrace();
        }
    }

    private boolean hasTemplate(String keyword) {
        if (this._templateStore == null) {
            return false;
        }
        Template[] expectedTemplates = this._templateStore.getTemplates();
        boolean ret = false;
        int i = 0;
        while (i < expectedTemplates.length) {
            if (expectedTemplates[i].getName().toUpperCase().equals(keyword)) {
                this.fExpectedTemplateList.add(expectedTemplates[i]);
                ret = true;
            }
            ++i;
        }
        return ret;
    }

    public ICompletionProposal[] computeCompletionProposals(ITextViewer viewer, int offset) {
        this.initialComputeCompletionProposals(viewer, offset);
        ICompletionProposal[] templats = super.computeCompletionProposals(viewer, offset);
        ICompletionProposal[] ret = new ICompletionProposal[templats.length + this._proposalsList.size()];
        int i = 0;
        while (i < templats.length) {
            ret[i] = templats[i];
            ++i;
        }
        Iterator ite = this._proposalsList.iterator();
        while (ite.hasNext()) {
            ret[i] = (ICompletionProposal)ite.next();
            ++i;
        }
        return ret;
    }

    public char[] getCompletionProposalAutoActivationCharacters() {
        return new char[]{'.'};
    }

    public String getErrorMessage() {
        return null;
    }

    public IContextInformationValidator getContextInformationValidator() {
        return this.fValidator;
    }

    public void setTemplateStore(TemplateStore store) {
        this._templateStore = store;
    }

    protected Template[] getTemplates(String contextTypeId) {
        System.out.println("getTemplates " + contextTypeId + "/" + this.fExpectedTemplateList);
        if (this._templateStore != null) {
            ArrayList<Template> retList = new ArrayList<Template>();
            int i = 0;
            while (i < this.fExpectedTemplateList.size()) {
                Template template = (Template)this.fExpectedTemplateList.get(i);
                System.out.println("template search.. " + template.getName() + "/" + this.fBackString);
                if (StringUtil.isIgnoreCaseStartsWith((String)template.getName(), (String)this.fBackString)) {
                    retList.add(template);
                }
                ++i;
            }
            return retList.toArray(new Template[retList.size()]);
        }
        System.out.println("template matching fault.........");
        return DEFAULT_TEMPLATE;
    }

    protected TemplateContextType getContextType(ITextViewer viewer, IRegion region) {
        TemplateContextType ret = null;
        ret = new TemplateContextType("ANYTHING");
        ret.addResolver((TemplateVariableResolver)new GlobalTemplateVariables.Cursor());
        ret.addResolver((TemplateVariableResolver)new GlobalTemplateVariables.LineSelection());
        ret.addResolver((TemplateVariableResolver)new GlobalTemplateVariables.Time());
        ret.addResolver((TemplateVariableResolver)new GlobalTemplateVariables.WordSelection());
        return ret;
    }

    protected Image getImage(Template template) {
        return ImageManager.getImageDescriptor("action/edit_sql.png").createImage();
    }

    protected class Validator
    implements IContextInformationValidator,
    IContextInformationPresenter {
        private int textStartPos;
        private int textEndPos;

        protected Validator() {
        }

        public void install(IContextInformation info, ITextViewer viewer, int documentPosition) {
            this.textEndPos = documentPosition;
            this.textStartPos = documentPosition - info.getInformationDisplayString().length();
        }

        public boolean isContextInformationValid(int documentPosition) {
            return documentPosition - this.textStartPos > 0 && documentPosition <= this.textEndPos;
        }

        public boolean updatePresentation(int documentPosition, TextPresentation presentation) {
            presentation.clear();
            return true;
        }
    }
}

