/*
 * Decompiled with CFR 0.152.
 */
package hiro.yoshioka.selenium;

import hiro.yoshioka.util.StringUtil;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.openqa.selenium.Dimension;

public class WindowSize {
    private int width;
    private int height;
    public DisplayResolution display_resolution;
    Pattern p1 = Pattern.compile("[ ]*(\\d+)[ ]*,[ ]*(\\d+)[ ]*");

    WindowSize(String target) {
        Matcher m = this.p1.matcher(target);
        if (m.find()) {
            this.width = StringUtil.parseIntNoneException((String)m.group(1), (int)100);
            this.height = StringUtil.parseIntNoneException((String)m.group(2), (int)100);
        } else {
            this.display_resolution = DisplayResolution.parse(target);
        }
    }

    public int getWidth() {
        if (this.display_resolution != null) {
            return Integer.parseInt(this.display_resolution.getWidth());
        }
        return this.width;
    }

    public int getHeight() {
        if (this.display_resolution != null) {
            return Integer.parseInt(this.display_resolution.getHeight());
        }
        return this.height;
    }

    public Dimension getDimension() {
        return new Dimension(this.getWidth(), this.getHeight());
    }

    public DisplayResolution getDisplay_resolution() {
        return this.display_resolution;
    }

    public boolean isMaximize() {
        if (this.display_resolution == null) {
            return false;
        }
        return DisplayResolution.Maximize.equals((Object)this.display_resolution);
    }

    public static enum DisplayResolution {
        HVGA("480", "320", "iPhone, 3G, 3GS"),
        VGA("640", "480", "DOS/V"),
        WVGA("800", "480", "Nexus One"),
        SVGA("800", "600", "DOS/V"),
        XGA("1024", "768", "IBM PS/2"),
        HD720p("1280", "720", "HD (720p)"),
        WXGA("1280", "768", "B5\u7e67\uff75\u7e67\uff64\u7e67\uff7a\u905e\u53e5\uff7a\uff66\u7e3a\uff6e\u7e5d\u5f31\ufffd\uff7c\u7e5d\u533b\u30f1\u7e67\uff7d\u7e67\uff73\u7e5d\uff73"),
        XGAplus("1152", "864", "XGA+"),
        iPhone6("1334", "750", "iPhone6"),
        WXGAWideXGA("1280", "800", "WXGA (Wide XGA)"),
        HD("1366", "768", "2008\u87f7\uff74\u7e5d\u5f31\ufffd\uff7c\u7e5d\u533b\u30f1\u7e67\uff7d\u7e67\uff73\u7e5d\uff73"),
        FWXGAFull_WXGA("1366", "768", "FWXGA (Full-WXGA)"),
        SXGA("1280", "1024", "SXGA"),
        SXGAplus("1400", "1050", "SXGA+"),
        FHD("1920", "1080", "\u8373\ufffd\u95ca\uff6c\u9027\ufffd\u7e3a\uff6a\u7e5d\ufffd\u7e67\uff63\u7e67\uff79\u7e5d\u52b1\u039e\u7e67\uff64"),
        Maximize("", "", "");

        public String width;
        public String height;
        public String info;

        private DisplayResolution(String width, String height, String info) {
            this.width = width;
            this.height = height;
            this.info = info;
        }

        public String getWidth() {
            return this.width;
        }

        public String getHeight() {
            return this.height;
        }

        public String getInfo() {
            return this.info;
        }

        public static DisplayResolution parse(String itypeString) {
            if (itypeString.equalsIgnoreCase("max") || itypeString.equalsIgnoreCase("maximize")) {
                return Maximize;
            }
            DisplayResolution[] displayResolutionArray = DisplayResolution.values();
            int n = displayResolutionArray.length;
            int n2 = 0;
            while (n2 < n) {
                DisplayResolution me = displayResolutionArray[n2];
                if (me.name().equalsIgnoreCase(itypeString) || me.getInfo().equals(itypeString)) {
                    return me;
                }
                ++n2;
            }
            return null;
        }
    }
}

