/*
 * Decompiled with CFR 0.152.
 */
package hiro.yoshioka.job;

import com.mongodb.util.ThreadUtil;
import hiro.yoshioka.sdh.ResultSetDataHolder;
import hiro.yoshioka.sql.IRequestListener;
import hiro.yoshioka.sql.engine.MirroringRequest;
import hiro.yoshioka.sql.engine.Request;
import hiro.yoshioka.sql.engine.RequestAdaptor;
import hiro.yoshioka.sql.engine.SQLOperationType;
import hiro.yoshioka.sql.params.ConnectionProperties;
import hiro.yoshioka.ui.view.ResultSetView;
import hiro.yoshioka.wolfdbmanager.Application;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.Job;

public class MirrorJob
extends Job {
    protected Log fLogger = LogFactory.getLog(((Object)((Object)this)).getClass());
    MirroringRequest fRequest;

    public MirrorJob(MirroringRequest request) {
        super("Mirroring ...");
        this.fRequest = request;
    }

    protected void canceling() {
        this.fRequest.cancel();
        super.canceling();
    }

    protected IStatus run(IProgressMonitor monitor) {
        IStatus ret = Status.CANCEL_STATUS;
        try {
            this.fRequest.addListener((IRequestListener)new ResourceRefreshRequest(monitor));
            this.fRequest.execute();
            ThreadUtil.sleep((long)200L);
            ret = Status.OK_STATUS;
        }
        catch (Exception e) {
            this.fLogger.error((Object)"", (Throwable)e);
            ret = Status.CANCEL_STATUS;
        }
        return ret;
    }

    class ResourceRefreshRequest
    extends RequestAdaptor {
        IProgressMonitor fmonitor;
        long startTime;
        boolean doneTableTask;

        public ResourceRefreshRequest(IProgressMonitor monitor) {
            this.fmonitor = monitor;
        }

        public void called_pre(Request request, SQLOperationType operation) {
            Application.setStatus("Mirroring Job initializing...");
            this.startTime = System.currentTimeMillis();
        }

        public void beginTask(final String taskName, final int row) {
            try {
                Application.exec(new Runnable(){

                    @Override
                    public void run() {
                        ResourceRefreshRequest.this.fmonitor.beginTask(taskName, row);
                    }
                });
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }

        public void called_done(final Request request, SQLOperationType operation, final ConnectionProperties properteis, Object o) {
            Application.exec(new Runnable(){

                @Override
                public void run() {
                    ResourceRefreshRequest.this.fmonitor.subTask("");
                    String n = String.format("Refresh Done... %1$,dmsec.", System.currentTimeMillis() - ResourceRefreshRequest.this.startTime);
                    MirrorJob.this.setName(n);
                    Application.setStatus(n);
                    ResultSetView rView = Application.showAndCreateRstView("MirroringResult");
                    rView.setInput((ResultSetDataHolder)request.getRdh(), properteis);
                    rView.showBusy(true);
                    if (request.getException() == null) {
                        if (ResourceRefreshRequest.this.fmonitor.isCanceled()) {
                            Application.openDialog("Information", "Resource caption canseled", 2);
                        }
                    } else if (ResourceRefreshRequest.this.fmonitor.isCanceled()) {
                        Application.openErrorDialog(null, "ResourceCaption Canseled", request.getException());
                    } else {
                        Application.openErrorDialog(null, "ResourceCaption", request.getException());
                    }
                }
            });
        }

        public void subTask(final String subTaskName) {
            try {
                Application.exec(new Runnable(){

                    @Override
                    public void run() {
                        ResourceRefreshRequest.this.fmonitor.subTask(subTaskName);
                    }
                });
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }

        public void worked(final int i) {
            try {
                Application.exec(new Runnable(){

                    @Override
                    public void run() {
                        if (ResourceRefreshRequest.this.fmonitor.isCanceled()) {
                            ((ResourceRefreshRequest)ResourceRefreshRequest.this).MirrorJob.this.fRequest.cancel();
                        } else {
                            ResourceRefreshRequest.this.fmonitor.worked(i);
                        }
                    }
                });
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    }
}

