/*
 * Decompiled with CFR 0.152.
 */
package hiro.yoshioka.gef.part;

import hiro.yoshioka.gef.figures.ColumnLabel;
import hiro.yoshioka.gef.figures.EditableLabel;
import hiro.yoshioka.gef.model.Column;
import hiro.yoshioka.gef.part.PropertyAwarePart;
import hiro.yoshioka.gef.policy.ColumnNodeEditPolicy;
import java.util.List;
import org.eclipse.draw2d.ChopboxAnchor;
import org.eclipse.draw2d.ConnectionAnchor;
import org.eclipse.draw2d.IFigure;
import org.eclipse.gef.ConnectionEditPart;
import org.eclipse.gef.EditPolicy;
import org.eclipse.gef.NodeEditPart;
import org.eclipse.gef.Request;

public class ColumnPart
extends PropertyAwarePart
implements NodeEditPart {
    protected IFigure createFigure() {
        Column column = this.getColumn();
        ColumnLabel columnLabel = new ColumnLabel(column.getColumn());
        return columnLabel;
    }

    protected void createEditPolicies() {
        this.installEditPolicy("GraphicalNodeEditPolicy", (EditPolicy)new ColumnNodeEditPolicy());
        this.installEditPolicy("LayoutEditPolicy", null);
    }

    public void revertNameChange(String oldValue) {
        EditableLabel label = (EditableLabel)this.getFigure();
        label.setVisible(true);
        this.setSelected(2);
        label.revalidate();
    }

    protected void refreshVisuals() {
        Column column = (Column)this.getModel();
        ColumnLabel columnLabel = (ColumnLabel)this.getFigure();
        columnLabel.setText(column.getNameWithComment());
    }

    private Column getColumn() {
        return (Column)this.getModel();
    }

    public List getModelSourceConnections() {
        return this.getColumn().getSourceConnectionList();
    }

    protected List getModelTargetConnections() {
        return this.getColumn().getTargetConnectionList();
    }

    public ConnectionAnchor getSourceConnectionAnchor(ConnectionEditPart connection) {
        return new ChopboxAnchor(this.getFigure());
    }

    public ConnectionAnchor getSourceConnectionAnchor(Request request) {
        return new ChopboxAnchor(this.getFigure());
    }

    public ConnectionAnchor getTargetConnectionAnchor(ConnectionEditPart connection) {
        return new ChopboxAnchor(this.getFigure());
    }

    public ConnectionAnchor getTargetConnectionAnchor(Request request) {
        return new ChopboxAnchor(this.getFigure());
    }
}

