/*
 * Decompiled with CFR 0.152.
 */
package hiro.yoshioka.gef.figures;

import hiro.yoshioka.gef.figures.ColumnLabel;
import hiro.yoshioka.gef.figures.ColumnsFigure;
import hiro.yoshioka.gef.figures.EditableLabel;
import hiro.yoshioka.gef.figures.Messages;
import hiro.yoshioka.gef.model.Table;
import java.util.List;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.eclipse.draw2d.AbstractBorder;
import org.eclipse.draw2d.Border;
import org.eclipse.draw2d.ColorConstants;
import org.eclipse.draw2d.Figure;
import org.eclipse.draw2d.Graphics;
import org.eclipse.draw2d.IFigure;
import org.eclipse.draw2d.LayoutManager;
import org.eclipse.draw2d.LineBorder;
import org.eclipse.draw2d.ToolbarLayout;
import org.eclipse.draw2d.geometry.Insets;
import org.eclipse.draw2d.geometry.Point;

public class TableFigure
extends Figure {
    protected Log fLogger = LogFactory.getLog(((Object)((Object)this)).getClass());
    private ColumnsFigure pkColumnsFigure = new ColumnsFigure();
    private ColumnsFigure columnsFigure = new ColumnsFigure();
    private EditableLabel nameLabel;
    private EditableLabel conditionLabel = new EditableLabel(Messages.TableFigure_Condition);
    private EditableLabel orderByLabel = new EditableLabel(Messages.TableFigure_Order);

    public TableFigure(Table table) {
        this(table, null);
    }

    public TableFigure(Table table, List colums) {
        EditableLabel name;
        this.nameLabel = name = new EditableLabel(table.getNameWithComment(), true);
        ToolbarLayout layout = new ToolbarLayout();
        layout.setVertical(true);
        layout.setStretchMinorAxis(true);
        this.setLayoutManager((LayoutManager)layout);
        this.setBorder((Border)new LineBorder(ColorConstants.black, 1));
        this.setForegroundColor(ColorConstants.black);
        this.setOpaque(true);
        this.add((IFigure)name);
        name.setBorder((Border)new TableLabelBorder());
        this.add((IFigure)this.pkColumnsFigure);
        this.add((IFigure)this.columnsFigure);
        this.add((IFigure)this.conditionLabel);
        this.conditionLabel.setText(table.getConditionValue());
        this.conditionLabel.setBorder((Border)new LineBorder(ColorConstants.black, 1));
        this.add((IFigure)this.orderByLabel);
        this.orderByLabel.setText(table.getOrderByValue());
        this.resetHeaderLabelColor(table.isExecute_select());
    }

    public void setSelected(boolean isSelected) {
        LineBorder lineBorder = (LineBorder)this.getBorder();
        if (isSelected) {
            lineBorder.setWidth(2);
        } else {
            lineBorder.setWidth(1);
        }
    }

    public void resetHeaderLabelColor(boolean b) {
        if (b) {
            this.nameLabel.setGradientMode(true);
            this.nameLabel.resetColor(ColorConstants.black);
        } else {
            this.nameLabel.setGradientMode(false);
            this.nameLabel.resetColor(ColorConstants.lightGray);
        }
    }

    public EditableLabel getNameLabel(Point point) {
        if (this.conditionLabel.containsPoint(point)) {
            return this.conditionLabel;
        }
        if (this.orderByLabel.containsPoint(point)) {
            return this.orderByLabel;
        }
        return null;
    }

    public ColumnsFigure getPkColumnsFigure() {
        return this.pkColumnsFigure;
    }

    public ColumnsFigure getColumnsFigure() {
        return this.columnsFigure;
    }

    public void addColumn(IFigure fig, int index) {
        ColumnLabel res;
        if (fig instanceof ColumnLabel && (res = (ColumnLabel)fig).isPkey()) {
            this.pkColumnsFigure.add(fig);
            return;
        }
        this.columnsFigure.add(fig);
    }

    public void setConditionText(String string) {
        this.conditionLabel.setText(string);
    }

    public void setOrderByText(String string) {
        this.orderByLabel.setText(string);
    }

    class TableLabelBorder
    extends AbstractBorder {
        TableLabelBorder() {
        }

        public Insets getInsets(IFigure figure) {
            return new Insets(3, 7, 3, 7);
        }

        public void paint(IFigure figure, Graphics graphics, Insets insets) {
            graphics.drawLine(TableLabelBorder.getPaintRectangle((IFigure)figure, (Insets)insets).getTopLeft(), tempRect.getTopRight());
        }
    }
}

