package hiro.yoshioka.job;

import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.util.HashMap;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

import org.apache.poi.hssf.usermodel.HSSFCell;
import org.apache.poi.hssf.usermodel.HSSFCellStyle;
import org.apache.poi.hssf.usermodel.HSSFErrorConstants;
import org.apache.poi.hssf.usermodel.HSSFFont;
import org.apache.poi.hssf.usermodel.HSSFRow;
import org.apache.poi.hssf.usermodel.HSSFSheet;
import org.apache.poi.hssf.usermodel.HSSFWorkbook;
import org.apache.poi.hssf.util.HSSFColor;
import org.apache.poi.hssf.util.Region;

public abstract class AbsBasicPoiWriter {
	protected transient Logger fLogger = Logger.getLogger(getClass().getName());

	// --------------------------------------------------------------------------
	// PRIVATE
	// --------------------------------------------------------------------------

	private BufferedInputStream fFileInputStream; // Excelt@C̓Xg[

	// --------------------------------------------------------------------------
	// PROTECTED
	// --------------------------------------------------------------------------

	protected File fFile; // Excelt@C

	protected HSSFWorkbook fHSSFWorkbook; // ubN

	protected HashMap fStyleMap = new HashMap();

	static final Pattern fRowNumPattern = Pattern.compile("([a-zA-Z]+)(\\d+)");

	/**
	 * RXgN^
	 * 
	 * @param file
	 *            ΏExcelt@C
	 */
	public AbsBasicPoiWriter(File file) {
		fFile = file;
	}

	public AbsBasicPoiWriter() {
		fHSSFWorkbook = new HSSFWorkbook();
	}

	public AbsBasicPoiWriter(BufferedInputStream stream) {
		fFileInputStream = stream;
	}

	public boolean init() {
		try {
			if (fFileInputStream == null) {
				fFileInputStream = new BufferedInputStream(new FileInputStream(
						fFile));
			}
			fHSSFWorkbook = new HSSFWorkbook(fFileInputStream);
			return true;
		} catch (IOException ex) {
			fLogger.log(Level.SEVERE, "Excel̃t@C`sł", ex);
		} finally {
			try {
				fFileInputStream.close();
			} catch (IOException e) {
				fLogger.log(Level.FINE, "", e);
			}
		}
		return false;
	}

	private short getIndexByColAlphName(String col) {
		int icol = 0;
		col = col.toLowerCase();
		if (col.length() == 1) {
			char c = col.charAt(0);
			icol = c - 'a';
		} else if (col.length() == 2) {
			char c = col.charAt(0);
			if (c == 'a') {
				icol = ('z' - 'a' + 1) + (col.charAt(1) - 'a');
			}
		} else {
			throw new IllegalArgumentException("AAȏ̗w肷ꍇ͎ŌvZĂ");
		}
		return (short) icol;
	}

	// --------------------------------------------------------------------------
	// PRIVATE METHODS
	// --------------------------------------------------------------------------

	// --------------------------------------------------------------------------
	// PROTECTED METHODS
	// --------------------------------------------------------------------------
	/**
	 * Z̏ݒ𕡐܂B
	 * 
	 * @param originalStyle
	 *            ƂȂPOĨZX^CIuWFNg
	 * @return ꂽPOĨZX^CIuWFNg
	 */
	protected HSSFCellStyle cloneCellStyle(HSSFCellStyle originalStyle) {
		HSSFCellStyle newStyle = fHSSFWorkbook.createCellStyle();
		newStyle.setAlignment(originalStyle.getAlignment());
		newStyle.setBorderBottom(originalStyle.getBorderBottom());
		newStyle.setBorderLeft(originalStyle.getBorderLeft());
		newStyle.setBorderRight(originalStyle.getBorderRight());
		newStyle.setBorderTop(originalStyle.getBorderTop());
		newStyle.setBottomBorderColor(originalStyle.getBottomBorderColor());
		newStyle.setDataFormat(originalStyle.getDataFormat());
		newStyle.setFillBackgroundColor(originalStyle.getFillBackgroundColor());
		newStyle.setFillForegroundColor(originalStyle.getFillForegroundColor());
		newStyle.setFillPattern(originalStyle.getFillPattern());
		newStyle.setFont(fHSSFWorkbook.getFontAt(originalStyle.getFontIndex()));
		newStyle.setHidden(originalStyle.getHidden());
		newStyle.setIndention(originalStyle.getIndention());
		newStyle.setLeftBorderColor(originalStyle.getLeftBorderColor());
		newStyle.setLocked(originalStyle.getLocked());
		newStyle.setRightBorderColor(originalStyle.getRightBorderColor());
		newStyle.setRotation(originalStyle.getRotation());
		newStyle.setTopBorderColor(originalStyle.getTopBorderColor());
		newStyle.setVerticalAlignment(originalStyle.getVerticalAlignment());
		newStyle.setWrapText(originalStyle.getWrapText());
		return newStyle;
	}

	protected void setBorderThin(HSSFCellStyle style, short bkind) {
		style.setBorderTop(bkind);
		style.setBorderBottom(bkind);
		style.setBorderLeft(bkind);
		style.setBorderRight(bkind);
	}

	protected HSSFCellStyle getHSSFCellStyle(boolean wrap, short border,
			String font, short fontsize, boolean fItalic, short fg,
			short cell_color, short fill_pattern) {
		String key = wrap + "/" + border + "/" + font + "/" + fontsize + "/"
				+ fg + "/" + cell_color + "/" + fill_pattern;
		HSSFCellStyle style = (HSSFCellStyle) fStyleMap.get(key);

		if (style == null) {
			style = fHSSFWorkbook.createCellStyle();
			style.setWrapText(wrap);
			setBorderThin(style, border);
			if (font != null && fontsize > 0) {
				HSSFFont font2 = fHSSFWorkbook.createFont();
				font2.setFontName(font);
				font2.setFontHeightInPoints(fontsize);
				if (fg >= 0) {
					font2.setColor(fg);
				}
				font2.setItalic(fItalic);
				style.setFont(font2);
			}
			if (cell_color >= 0) {
				style.setFillForegroundColor(cell_color);
				style.setFillPattern(fill_pattern);
			}
			fStyleMap.put(key, style);
		}
		return style;

	}

	//
	// protected HSSFCellStyle getBoxStyle() {
	// HSSFCellStyle style = fStyleMap.get("BOX");
	// if (style == null) {
	// style = fHSSFWorkbook.createCellStyle();
	// style.setWrapText(true);
	// setBorderThin(style, HSSFCellStyle.BORDER_THIN);
	// HSSFFont font2 = fHSSFWorkbook.createFont();
	// font2.setFontName("lr o");
	// font2.setFontHeightInPoints((short) 9);
	// style.setFont(font2);
	// fStyleMap.put("BOX", style);
	// }
	// return style;
	// }

	// protected HSSFCellStyle getOrangeBoxStyle() {
	// HSSFCellStyle style = fStyleMap.get("ORANGE_BOX");
	// if (style == null) {
	// style = fHSSFWorkbook.createCellStyle();
	// setBorderThin(style, HSSFCellStyle.BORDER_THIN);
	// style.setFillForegroundColor(HSSFColor.LIGHT_YELLOW.index);
	// style.setFillPattern(HSSFCellStyle.SOLID_FOREGROUND);
	// style.setWrapText(true);
	// HSSFFont font2 = fHSSFWorkbook.createFont();
	// font2.setFontName("lr o");
	// font2.setFontHeightInPoints((short) 9);
	// style.setFont(font2);
	// fStyleMap.put("ORANGE_BOX", style);
	// }
	// return style;
	// }

	// protected HSSFCellStyle getAddBoxStyle() {
	// HSSFCellStyle style = fStyleMap.get("ADD_BOX");
	// if (style == null) {
	// style = fHSSFWorkbook.createCellStyle();
	// setBorderThin(style, HSSFCellStyle.BORDER_DOTTED);
	// style.setFillForegroundColor(HSSFColor.LIGHT_GREEN.index);
	// style.setFillPattern(HSSFCellStyle.SOLID_FOREGROUND);
	// style.setWrapText(true);
	// HSSFFont font2 = fHSSFWorkbook.createFont();
	// font2.setFontName("lr o");
	// font2.setFontHeightInPoints((short) 9);
	// style.setFont(font2);
	// fStyleMap.put("ADD_BOX", style);
	// }
	// return style;
	// }

	protected HSSFCellStyle getChangeBoxStyle() {
		HSSFCellStyle style = (HSSFCellStyle) fStyleMap.get("CHANGE_BOX");
		if (style == null) {
			style = fHSSFWorkbook.createCellStyle();
			setBorderThin(style, HSSFCellStyle.BORDER_SLANTED_DASH_DOT);
			style.setFillForegroundColor(HSSFColor.LIGHT_TURQUOISE.index);
			style.setFillPattern(HSSFCellStyle.SOLID_FOREGROUND);
			style.setWrapText(true);
			HSSFFont font2 = fHSSFWorkbook.createFont();
			font2.setFontName("lr o");
			font2.setFontHeightInPoints((short) 9);
			style.setFont(font2);
			fStyleMap.put("CHANGE_BOX", style);
		}
		return style;
	}

	/**
	 * ̓t@C̃Xg[
	 */
	protected boolean close() {
		boolean ret = false;
		if (fFileInputStream != null) {
			try {
				fFileInputStream.close();
				ret = true;
			} catch (IOException e) {
				fLogger.log(Level.SEVERE, "̓t@C邱Ƃł܂łB", e);
			}
			fFileInputStream = null;
		}
		return ret;
	}

	/**
	 * wV[g̎wsCellV쐬B
	 * 
	 * @param sheet
	 *            V[g
	 * @param col
	 *            񖼁iA,B,EEE,AZj
	 * @param row
	 *            sԍ
	 * @return HSSFCell
	 */
	protected HSSFCell createHSSFCell(HSSFSheet sheet, String col, int row) {
		return createHSSFCell(sheet, getIndexByColAlphName(col), row);
	}

	protected HSSFCell createHSSFCell(HSSFSheet sheet, short col, int row) {
		HSSFCell ret = null;
		HSSFRow grow = sheet.getRow(row - 1);
		if (grow == null) {
			grow = sheet.createRow(row - 1);
		}
		ret = grow.createCell(col);
		try {
			ret.setEncoding(HSSFCell.ENCODING_UTF_16);
		} catch (NullPointerException e) {
			fLogger.log(Level.SEVERE, "sy" + row + "/" + col + "z", e);
			throw e;
		}
		return ret;
	}

	/**
	 * wV[g̎wsCell폜B
	 * 
	 * @param sheet
	 *            V[g
	 * @param col
	 *            񖼁iA,B,EEE,AZj
	 * @param row
	 *            sԍ
	 * @return HSSFCell
	 */
	protected void removeHSSFCellByA1(HSSFSheet sheet, String col, int row) {
		HSSFCell ret = null;

		HSSFRow rows = sheet.getRow(row - 1);
		try {
			ret = rows.getCell(getIndexByColAlphName(col));
			if (ret != null) {
				rows.removeCell(ret);
			}
		} catch (NullPointerException e) {
			fLogger.log(Level.SEVERE, "sy" + row + "/" + col + "z", e);
			throw e;
		}
	}

	/**
	 * wV[g̎wsCelluNɂB
	 * 
	 * @param sheet
	 *            V[g
	 * @param col
	 *            񖼁iA,B,EEE,AZj
	 * @param row
	 *            sԍ
	 * @return HSSFCell
	 */
	protected void setBlankHSSFCellByA1(HSSFSheet sheet, String col, int row) {
		HSSFCell ret = null;

		HSSFRow rows = sheet.getRow(row - 1);
		try {
			ret = rows.getCell(getIndexByColAlphName(col));
			if (ret != null) {
				ret.setCellType(HSSFCell.CELL_TYPE_BLANK);
			}
		} catch (NullPointerException e) {
			fLogger.log(Level.SEVERE, "sy" + row + "/" + col + "z", e);
			throw e;
		}
	}

	/**
	 * wV[g̎wsCell擾B
	 * 
	 * @param sheet
	 *            V[g
	 * @param col
	 *            񖼁iA,B,EEE,AZj
	 * @param row
	 *            sԍ
	 * @return HSSFCell
	 */
	protected HSSFCell getHSSFCellByA1(HSSFSheet sheet, String col, int row) {
		HSSFCell ret = null;

		HSSFRow rows = sheet.getRow(row - 1);
		try {
			ret = rows.getCell(getIndexByColAlphName(col));
			ret.setEncoding(HSSFCell.ENCODING_UTF_16);
		} catch (NullPointerException e) {
			fLogger.log(Level.SEVERE, "sy" + row + "/" + col + "z", e);
			throw new NullPointerException("sy" + row + "/" + col + "z");
		}

		return ret;
	}

	/**
	 * w肵V[g̃V[g폜 ev[gV[g𕡐AwV[gŃl[B
	 * 
	 * @param sheet
	 *            V[g
	 * @return HSSFSheet
	 */
	protected HSSFSheet copySheet(String makeSheetName, String useSheetName,
			boolean remove) {
		if (remove) {
			int index = fHSSFWorkbook.getSheetIndex(makeSheetName);
			if (index >= 0) {
				fHSSFWorkbook.removeSheetAt(index);
			}
		}

		int cindex = fHSSFWorkbook.getSheetIndex(useSheetName);

		HSSFSheet cSheet = this.fHSSFWorkbook.cloneSheet(cindex);
		fHSSFWorkbook.setSheetName(fHSSFWorkbook.getNumberOfSheets() - 1,
				makeSheetName);

		return cSheet;
	}

	/**
	 * s̕
	 * 
	 * @param sheet
	 *            POIExcelV[gIuWFNg
	 * @param rowNum
	 *            s̔ԍ
	 * @param templateRowNum
	 *            Rs[ƂȂs̔ԍ
	 */
	protected void insertRow(HSSFSheet sheet, int rowNum, int templateRowNum,
			boolean doRefStyle) {

		sheet
				.shiftRows(rowNum, sheet.getPhysicalNumberOfRows(), 1, true,
						false);
		HSSFRow row = sheet.createRow(rowNum - 1);
		HSSFRow templateRow = sheet.getRow(templateRowNum - 1);
		// s̍𕡐B
		row.setHeight(templateRow.getHeight());
		row.setHeightInPoints(templateRow.getHeightInPoints());
		for (int i = 0; i < templateRow.getPhysicalNumberOfCells(); i++) {
			HSSFCell templateCell = templateRow.getCell((short) i);
			HSSFCell cell = row.createCell((short) i);
			if (doRefStyle) {
				cell.setCellStyle(templateCell.getCellStyle());
			} else {
				cell.setCellStyle(cloneCellStyle(templateCell.getCellStyle()));
			}
			copy(templateCell, cell, rowNum - templateRowNum);
		}
	}

	/**
	 * w肵s̃ZĂꍇɂ̌B
	 * 
	 * @param sheet
	 *            V[g
	 * @param col
	 *            񖼁iA,B,EEE,AZj
	 * @param row
	 *            sԍ
	 */
	protected void removeMergedRegion(HSSFSheet sheet, String col, int row) {
		try {
			for (int i = 0; i < sheet.getNumMergedRegions(); i++) {
				Region reg = sheet.getMergedRegionAt(i);
				if (reg.contains(row - 1, getIndexByColAlphName(col))) {
					sheet.removeMergedRegion(i);
					fLogger.warning("sy" + row + "/" + col + "z̃Z܂B");
				}
			}
		} catch (NullPointerException e) {
			fLogger.log(Level.SEVERE, "sy" + row + "/" + col + "z", e);
			throw new NullPointerException("sy" + row + "/" + col + "z");
		}
	}

	/**
	 * ܂ލsOɍs}ꍇ͎̎QƂsԍB<BR>
	 * 𒲐B
	 * 
	 * @param sheet
	 *            V[g
	 * @param rowNum
	 *            sԍ
	 * @param addRowNum
	 *            s̎Oɉs}H
	 */
	protected void tuneInExactlyRow(HSSFSheet sheet, int rowNum, int addRowNum) {
		HSSFRow row = sheet.getRow(rowNum - 1);
		for (int i = 0; i < row.getPhysicalNumberOfCells(); i++) {
			HSSFCell cell = row.getCell((short) i);
			// 񂩂V֐ݒ ܂ރZ͏㏑ݒs\̂ߐVK쐬
			if (HSSFCell.CELL_TYPE_FORMULA == cell.getCellType()) {
				String f = getTunedCellFormula(cell, addRowNum);
				// HSSFCellStyle style = cloneCellStyle(cell.getCellStyle());
				HSSFCellStyle style = cell.getCellStyle();
				cell.setCellType(HSSFCell.CELL_TYPE_BLANK);
				HSSFCell new_cell = row.createCell((short) (i));
				new_cell.setCellStyle(style);
				try {
					new_cell.setEncoding(HSSFCell.ENCODING_UTF_16);
				} catch (NullPointerException e) {
					fLogger.log(Level.SEVERE, "sy" + row + "/" + i + "z", e);
					throw new NullPointerException("sy" + row + "/" + i + "z");
				}
				new_cell.setCellFormula(f);
			}
		}
	}

	/**
	 * ꂽ̒l
	 * 
	 * @param cell
	 *            Z
	 * @param addRowNum
	 *            ǉs̐
	 * @return ꂽ̒l
	 */
	private String getTunedCellFormula(HSSFCell cell, int addRowNum) {
		String f = cell.getCellFormula();
		Matcher matcher = fRowNumPattern.matcher(f);
		StringBuffer sb = new StringBuffer();
		while (matcher.find()) {
			int irow = Integer.parseInt(matcher.group(2));
			String newRow = String.valueOf(irow + addRowNum);
			matcher.appendReplacement(sb, matcher.group(1) + newRow);
		}
		matcher.appendTail(sb);
		return sb.toString();
	}

	/**
	 * wiFFÂ
	 * 
	 * @param sheet
	 *            POIExcelV[gIuWFNg
	 * @param rowNum
	 *            s̔ԍ
	 * 
	 * @param color
	 *            F
	 * @param beginColumn
	 *            Ft͈̔ START
	 * @param endColumn
	 *            Ft͈̔ END
	 */
	protected void setBackGround(HSSFSheet sheet, short color, int rownum,
			String beginColumn, String endColumn) {
		int begin = getIndexByColAlphName(beginColumn);
		int end = getIndexByColAlphName(endColumn);
		HSSFRow row = sheet.getRow(rownum - 1);
		for (int i = begin; i <= end; i++) {
			HSSFCellStyle cellstyle = row.getCell((short) i).getCellStyle();
			cellstyle.setFillForegroundColor(color);
			cellstyle.setFillPattern(HSSFCellStyle.SOLID_FOREGROUND);
		}
	}

	protected void copy(HSSFCell from, HSSFCell to, int divRow) {
		to.setEncoding(from.getEncoding());
		to.setCellType(from.getCellType());
		switch (from.getCellType()) {
		case HSSFCell.CELL_TYPE_NUMERIC:
			to.setCellValue(from.getNumericCellValue());
			break;
		case HSSFCell.CELL_TYPE_STRING:
			to.setCellValue(from.getStringCellValue());
			break;
		case HSSFCell.CELL_TYPE_BLANK:
			break;
		case HSSFCell.CELL_TYPE_BOOLEAN:
			to.setCellValue(from.getBooleanCellValue());
			break;
		case HSSFCell.CELL_TYPE_FORMULA:
			to.setCellFormula(getTunedCellFormula(from, divRow));
			break;
		default:
			break;
		}
	}

	/**
	 * K\ŕ̒usAuꂽԂB
	 * 
	 * @param p
	 *            p^[
	 * @param r
	 *            u̕
	 * @param s
	 *            ̓V[PX
	 * @return ϊ㕶
	 */
	public static String regReplace(String p, String r, String s) {
		Pattern pattern = Pattern.compile(p);
		Matcher matcher = pattern.matcher(s);
		StringBuffer sb = new StringBuffer();
		while (matcher.find()) {
			matcher.appendReplacement(sb, r);
		}
		matcher.appendTail(sb);
		return sb.toString();
	}

	protected String getCellString(HSSFCell cell) {
		String cellValue = null;
		switch (cell.getCellType()) {
		case HSSFCell.CELL_TYPE_NUMERIC:
			cellValue = "" + cell.getNumericCellValue();
			break;
		case HSSFCell.CELL_TYPE_STRING:
			cellValue = "" + cell.getStringCellValue();
			break;
		case HSSFCell.CELL_TYPE_BLANK:
			cellValue = "";
			break;
		case HSSFCell.CELL_TYPE_BOOLEAN:
			cellValue = "" + cell.getBooleanCellValue();
			break;
		case HSSFCell.CELL_TYPE_FORMULA:
			cellValue = "" + cell.getCellFormula();
			break;
		case HSSFCell.CELL_TYPE_ERROR:
			switch (cell.getErrorCellValue()) {
			case HSSFErrorConstants.ERROR_DIV_0:
				cellValue = "#DIV/0!";
				break;
			case HSSFErrorConstants.ERROR_NA:
				cellValue = "#N/A";
				break;
			case HSSFErrorConstants.ERROR_NAME:
				cellValue = "#NAME?";
				break;
			case HSSFErrorConstants.ERROR_NULL:
				cellValue = "#NULL!";
				break;
			case HSSFErrorConstants.ERROR_NUM:
				cellValue = "#NUM!";
				break;
			case HSSFErrorConstants.ERROR_REF:
				cellValue = "#REF!";
				break;
			case HSSFErrorConstants.ERROR_VALUE:
				cellValue = "#VALUE!";
				break;
			default:
				cellValue = "undefined error...";
			}
			break;
		default:
			cellValue = "" + cell.getStringCellValue();
			break;
		}
		return cellValue;
	}

	// --------------------------------------------------------------------------
	// PUBLIC METHODS
	// --------------------------------------------------------------------------
	/**
	 * ۑB
	 * 
	 * @return
	 */
	public boolean save() {
		FileOutputStream outStream = null;
		try {
			File fout = new File(fFile.getAbsolutePath());
			outStream = new FileOutputStream(fout);
			fHSSFWorkbook.write(outStream);
			return true;
		} catch (Exception ex) {
			fLogger.log(Level.SEVERE, "t@C݃G[", ex);
			return false;
		} finally {
			try {
				if (outStream != null) {
					outStream.close();
				}
			} catch (IOException ex) {
				fLogger.log(Level.SEVERE, "t@C݃G[", ex);
			}
		}
	}

	/**
	 * ۑB
	 * 
	 * @return
	 */
	public boolean save(File outFile) {
		FileOutputStream outStream = null;
		try {
			outStream = new FileOutputStream(outFile);
			fHSSFWorkbook.write(outStream);
			return true;
		} catch (Exception ex) {
			ex.printStackTrace();
			return false;
		} finally {
			try {
				if (outStream != null) {
					outStream.close();
				}
			} catch (IOException ex) {
				ex.printStackTrace();
			}
		}
	}

	/**
	 * V[g폜B
	 * 
	 * @param sheetName
	 *            폜V[g
	 */
	public void removeSheetAt(int index) {
		fHSSFWorkbook.removeSheetAt(index);
	}

	/**
	 * V[gύXB
	 * 
	 * @param index
	 *            OύXV[gindex
	 * @param sheetName
	 *            V[g
	 */
	public void renameSheet(int index, String sheetName) {
		fHSSFWorkbook.setSheetName(index, sheetName,
				HSSFWorkbook.ENCODING_UTF_16);
	}

	/**
	 * s𒲐B
	 * 
	 * @param sheetName
	 *            폜V[g
	 */
	public void tuneRowHeight(HSSFSheet sheet, int row, int height) {
		HSSFRow row1 = sheet.createRow((short) row);
		row1.setHeightInPoints((short) height);

	}

	/**
	 * Z̉ʒuyяcʒu̔zuw
	 * 
	 * @param alignment
	 *            ̒l
	 * @param verticalAlignment
	 *            ƂȂPOĨZX^CIuWFNg
	 * @return ꂽPOĨZX^CIuWFNg
	 */
	public HSSFCellStyle setCellAlignment(short alignment,
			short verticalAlignment, HSSFCellStyle style) {
		HSSFCellStyle newStyle = style;
		newStyle.setAlignment(alignment);
		newStyle.setVerticalAlignment(verticalAlignment);
		return newStyle;
	}

}
