package hiro.yoshioka.javadoc2excel.gui;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.GridLayout;
import java.awt.Point;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.io.File;
import java.util.ArrayList;

import javax.swing.ButtonGroup;
import javax.swing.DefaultListModel;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JDialog;
import javax.swing.JFileChooser;
import javax.swing.JFrame;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JScrollPane;
import javax.swing.JTextField;
import javax.swing.ListCellRenderer;
import javax.swing.border.TitledBorder;

public class Main extends JFrame implements MouseListener {
	public static JDialog dialog;
	JTextField RootDirPathTextField;

	JTextField executeCommand;

	JPanel sourceSelectPanel;

	protected JList list;

	protected DefaultListModel model;

	private String selectedVisiblity = "-protected";

	JButton selectAllButton;

	private String[] commandArgs = new String[0];

	public static void main(String[] args) {
		Main obj = new Main();
		obj.doWork();
	}

	public static void resetProgresDialog() {

	}

	private void doWork() {
		setDefaultCloseOperation(JFrame.EXIT_ON_CLOSE);
		setSize(540, 420);
		setTitle("JavaDoc2Excel ver1.0");
		createPane(getContentPane());
		setVisible(true);
		refreshCommand();
	}

	private JPanel createVisiblity() {
		TitledBorder tb = new TitledBorder("Visiblity");
		JPanel panel = new JPanel(new GridLayout(1, 4));
		panel.setBorder(tb);
		JRadioButton radio1 = new JRadioButton("public");
		JRadioButton radio2 = new JRadioButton("protected");
		radio2.setSelected(true);
		JRadioButton radio3 = new JRadioButton("package");
		JRadioButton radio4 = new JRadioButton("private");

		ButtonGroup group = new ButtonGroup();
		MyActionListner lis = new MyActionListner();
		radio1.addActionListener(lis);
		radio2.addActionListener(lis);
		radio3.addActionListener(lis);
		radio4.addActionListener(lis);

		group.add(radio1);
		group.add(radio2);
		group.add(radio3);
		group.add(radio4);

		panel.add(radio1);
		panel.add(radio2);
		panel.add(radio3);
		panel.add(radio4);

		return panel;
	}

	class MyActionListner implements ActionListener {
		public void actionPerformed(ActionEvent e) {
			String str = ((JRadioButton) e.getSource()).getText();
			selectedVisiblity = "-" + str;
			refreshCommand();
		}
	}

	private void refreshCommand() {
		ArrayList<String> comList = new ArrayList<String>();
		comList.add("-doclet");
		comList.add("YonDoc");
		comList.add(selectedVisiblity);
		comList.add("-sourcepath");
		comList.add(RootDirPathTextField.getText());

		for (int i = 0; i < model.size(); i++) {
			JCheckBox ch = (JCheckBox) model.get(i);
			if (ch.isSelected()) {
				comList.add(ch.getText());
			}
		}

		StringBuffer buf = new StringBuffer();
		for (int i = 0; i < comList.size(); i++) {
			buf.append(" ").append(comList.get(i));
		}
		commandArgs = comList.toArray(new String[comList.size()]);
		if (executeCommand != null) {
			executeCommand.setText(buf.toString());
		}
	}

	private void createPane(Container contentPane) {
		contentPane.add(createVisiblity(), BorderLayout.NORTH);
		contentPane.add(crateRootFolder());
		contentPane.add(createExecutor(), BorderLayout.SOUTH);
	}

	private Component createExecutor() {
		TitledBorder tb = new TitledBorder("javadoc Command");
		JPanel panel = new JPanel();
		panel.setBorder(tb);
		executeCommand = new JTextField("javadoc.exe ");
		Dimension d = executeCommand.getPreferredSize();
		d.width = d.width + 330;
		executeCommand.setPreferredSize(d);
		panel.add(executeCommand);
		final JButton bt = new JButton("Execute");
		bt.addActionListener(new ActionListener() {
			public void actionPerformed(ActionEvent e) {
				try {
					bt.setEnabled(false);
					for (int i = 0; i < commandArgs.length; i++) {
						System.out.println("param[" + (i + 1) + "]y"
								+ commandArgs[i] + "z");
					}
					dialog = new JDialog(Main.this, "Forget-me-Not", true);

					com.sun.tools.javadoc.Main.execute(commandArgs);

				} catch (Exception e1) {
					e1.printStackTrace();
				}
			}
		});
		panel.add(bt, BorderLayout.EAST);
		return panel;
	}

	private JPanel crateRootFolder() {
		TitledBorder tb = new TitledBorder("SourcePath");
		sourceSelectPanel = new JPanel();
		sourceSelectPanel.setBorder(tb);
		FlowLayout fl = new FlowLayout(FlowLayout.LEFT, 1, 1);
		JPanel topPanel = new JPanel(fl);
		JButton bt = new JButton("RootDir...");
		topPanel.add(bt);
		RootDirPathTextField = new JTextField(".");
		RootDirPathTextField.addKeyListener(new KeyAdapter() {
			@Override
			public void keyReleased(KeyEvent e) {
				resetFileList();
			}
		});
		Dimension d = RootDirPathTextField.getPreferredSize();
		d.width = d.width + 360;
		RootDirPathTextField.setPreferredSize(d);
		topPanel.add(RootDirPathTextField);
		bt.addActionListener(new ActionListener() {
			public void actionPerformed(ActionEvent e) {
				File f = new File(RootDirPathTextField.getText());
				JFileChooser ch = null;
				if (f.exists()) {
					ch = new JFileChooser(f);
				} else {
					ch = new JFileChooser(".");
				}
				ch.setFileSelectionMode(JFileChooser.DIRECTORIES_ONLY);
				ch.showOpenDialog(getContentPane());
				RootDirPathTextField.setText(ch.getSelectedFile()
						.getAbsolutePath());
				resetFileList();
			}

		});

		sourceSelectPanel.add(topPanel, BorderLayout.NORTH);

		JPanel leftPanel = new JPanel(new GridLayout(2, 1));
		selectAllButton = new JButton("SelectAll");
		selectAllButton.addActionListener(new MySelection(true));
		JButton radio2 = new JButton("clearAll");
		radio2.addActionListener(new MySelection(false));
		selectAllButton.setSelected(true);

		ButtonGroup group = new ButtonGroup();
		group.add(selectAllButton);
		group.add(radio2);
		leftPanel.add(selectAllButton);
		leftPanel.add(radio2);
		sourceSelectPanel.add(leftPanel, BorderLayout.WEST);

		model = new DefaultListModel();

		list = new JList(model);

		resetFileList();
		list.addMouseListener(this);

		/* CellRendererݒ肷 */
		MyCellRenderer renderer = new MyCellRenderer();
		list.setCellRenderer(renderer);
		JScrollPane sp = new JScrollPane();
		sp.getViewport().setView(list);
		sourceSelectPanel.add(sp);

		return sourceSelectPanel;
	}

	private void resetFileList() {
		model.removeAllElements();
		list.removeAll();
		String[] initData = getFileList(new File(RootDirPathTextField.getText()));
		for (int i = 0; i < initData.length; i++) {
			JCheckBox jc = new JCheckBox(initData[i]);
			jc.setSelected(true);
			model.addElement(jc);
		}
		list.repaint();
		refreshCommand();
	}

	String[] getFileList(File f) {
		ArrayList<String> retList = new ArrayList<String>();
		if (f != null) {
			fl(f, retList);
		}
		return retList.toArray(new String[retList.size()]);
	}

	private void fl(File f, ArrayList<String> retList) {
		boolean hasJava = false;
		File[] children = f.listFiles();
		if (children == null) {
			return;
		}
		for (int i = 0; i < children.length; i++) {
			if (children[i].isDirectory()) {
				fl(children[i], retList);
			} else if (children[i].isFile()) {
				if (children[i].getName().endsWith(".java")) {
					hasJava = true;
				}
			}
		}
		if (hasJava) {
			File rd = new File(RootDirPathTextField.getText());
			int len = rd.getAbsolutePath().length();
			String path = f.getAbsolutePath().substring(len);

			if (path.startsWith("\\") || path.startsWith("/")) {
				path = path.substring(1);
			}
			path = path.replace(File.separator, ".");
			if (path.trim().length() > 0) {
				retList.add(path);
			}
		}
	}

	// -------------------------------------------------------------------------
	class MySelection implements ActionListener {
		boolean state;

		public MySelection(boolean state) {
			this.state = state;
		}

		public void actionPerformed(ActionEvent e) {
			for (int i = 0; i < model.size(); i++) {
				((JCheckBox) model.elementAt(i)).setSelected(state);
			}
			list.repaint();
			refreshCommand();
		}
	}

	class MyCellRenderer extends JCheckBox implements ListCellRenderer {
		public Component getListCellRendererComponent(JList list, Object value,
				int index, boolean isSelected, boolean cellHasFocus) {

			/* ڂ̒lǂݏoĉ߂ĕ\ */
			JCheckBox checkBox = (JCheckBox) value;
			setText(checkBox.getText());

			setSelected(checkBox.isSelected());

			return this;
		}
	}

	public void mouseClicked(MouseEvent e) {
		/* NbNꂽWIndexԍo */
		Point p = e.getPoint();
		int index = list.locationToIndex(p);

		JCheckBox checkBox = (JCheckBox) model.getElementAt(index);
		if (checkBox.isSelected()) {
			checkBox.setSelected(false);
		} else {
			checkBox.setSelected(true);
		}

		/* ĕ`悵Ă݂ */
		list.repaint();
		refreshCommand();
	}

	public void mouseEntered(MouseEvent e) {
		// TODO Auto-generated method stub

	}

	public void mouseExited(MouseEvent e) {
		// TODO Auto-generated method stub

	}

	public void mousePressed(MouseEvent e) {
		// TODO Auto-generated method stub

	}

	public void mouseReleased(MouseEvent e) {
		// TODO Auto-generated method stub

	}

}
