/*
 * Decompiled with CFR 0.152.
 */
package hiro.yoshioka.job;

import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.util.HashMap;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.poi.hssf.usermodel.HSSFCell;
import org.apache.poi.hssf.usermodel.HSSFCellStyle;
import org.apache.poi.hssf.usermodel.HSSFFont;
import org.apache.poi.hssf.usermodel.HSSFRow;
import org.apache.poi.hssf.usermodel.HSSFSheet;
import org.apache.poi.hssf.usermodel.HSSFWorkbook;
import org.apache.poi.hssf.util.Region;

public abstract class AbsBasicPoiWriter {
    protected transient Logger fLogger = Logger.getLogger(this.getClass().getName());
    private BufferedInputStream fFileInputStream;
    protected File fFile;
    protected HSSFWorkbook fHSSFWorkbook;
    protected HashMap fStyleMap = new HashMap();
    static final Pattern fRowNumPattern = Pattern.compile("([a-zA-Z]+)(\\d+)");

    public AbsBasicPoiWriter(File file) {
        this.fFile = file;
    }

    public AbsBasicPoiWriter() {
        this.fHSSFWorkbook = new HSSFWorkbook();
    }

    public AbsBasicPoiWriter(BufferedInputStream stream) {
        this.fFileInputStream = stream;
    }

    public boolean init() {
        try {
            if (this.fFileInputStream == null) {
                this.fFileInputStream = new BufferedInputStream(new FileInputStream(this.fFile));
            }
            this.fHSSFWorkbook = new HSSFWorkbook(this.fFileInputStream);
            return true;
        }
        catch (IOException ex) {
            this.fLogger.log(Level.SEVERE, "Excel\u306e\u30d5\u30a1\u30a4\u30eb\u5f62\u5f0f\u304c\u4e0d\u6b63\u3067\u3059", ex);
        }
        finally {
            try {
                this.fFileInputStream.close();
            }
            catch (IOException e) {
                this.fLogger.log(Level.FINE, "", e);
            }
        }
        return false;
    }

    private short getIndexByColAlphName(String col) {
        int icol = 0;
        if ((col = col.toLowerCase()).length() == 1) {
            char c = col.charAt(0);
            icol = c - 97;
        } else if (col.length() == 2) {
            char c = col.charAt(0);
            if (c == 'a') {
                icol = 26 + (col.charAt(1) - 97);
            }
        } else {
            throw new IllegalArgumentException("AA\u4ee5\u4e0a\u306e\u5217\u3092\u6307\u5b9a\u3059\u308b\u5834\u5408\u306f\u81ea\u5206\u3067\u8a08\u7b97\u3057\u3066\u304f\u3060\u3055\u3044");
        }
        return (short)icol;
    }

    protected HSSFCellStyle cloneCellStyle(HSSFCellStyle originalStyle) {
        HSSFCellStyle newStyle = this.fHSSFWorkbook.createCellStyle();
        newStyle.setAlignment(originalStyle.getAlignment());
        newStyle.setBorderBottom(originalStyle.getBorderBottom());
        newStyle.setBorderLeft(originalStyle.getBorderLeft());
        newStyle.setBorderRight(originalStyle.getBorderRight());
        newStyle.setBorderTop(originalStyle.getBorderTop());
        newStyle.setBottomBorderColor(originalStyle.getBottomBorderColor());
        newStyle.setDataFormat(originalStyle.getDataFormat());
        newStyle.setFillBackgroundColor(originalStyle.getFillBackgroundColor());
        newStyle.setFillForegroundColor(originalStyle.getFillForegroundColor());
        newStyle.setFillPattern(originalStyle.getFillPattern());
        newStyle.setFont(this.fHSSFWorkbook.getFontAt(originalStyle.getFontIndex()));
        newStyle.setHidden(originalStyle.getHidden());
        newStyle.setIndention(originalStyle.getIndention());
        newStyle.setLeftBorderColor(originalStyle.getLeftBorderColor());
        newStyle.setLocked(originalStyle.getLocked());
        newStyle.setRightBorderColor(originalStyle.getRightBorderColor());
        newStyle.setRotation(originalStyle.getRotation());
        newStyle.setTopBorderColor(originalStyle.getTopBorderColor());
        newStyle.setVerticalAlignment(originalStyle.getVerticalAlignment());
        newStyle.setWrapText(originalStyle.getWrapText());
        return newStyle;
    }

    protected void setBorderThin(HSSFCellStyle style, short bkind) {
        style.setBorderTop(bkind);
        style.setBorderBottom(bkind);
        style.setBorderLeft(bkind);
        style.setBorderRight(bkind);
    }

    protected HSSFCellStyle getHSSFCellStyle(boolean wrap, short border, String font, short fontsize, boolean fItalic, short fg, short cell_color, short fill_pattern) {
        String key = String.valueOf(wrap) + "/" + border + "/" + font + "/" + fontsize + "/" + fg + "/" + cell_color + "/" + fill_pattern;
        HSSFCellStyle style = (HSSFCellStyle)this.fStyleMap.get(key);
        if (style == null) {
            style = this.fHSSFWorkbook.createCellStyle();
            style.setWrapText(wrap);
            this.setBorderThin(style, border);
            if (font != null && fontsize > 0) {
                HSSFFont font2 = this.fHSSFWorkbook.createFont();
                font2.setFontName(font);
                font2.setFontHeightInPoints(fontsize);
                if (fg >= 0) {
                    font2.setColor(fg);
                }
                font2.setItalic(fItalic);
                style.setFont(font2);
            }
            if (cell_color >= 0) {
                style.setFillForegroundColor(cell_color);
                style.setFillPattern(fill_pattern);
            }
            this.fStyleMap.put(key, style);
        }
        return style;
    }

    protected HSSFCellStyle getChangeBoxStyle() {
        HSSFCellStyle style = (HSSFCellStyle)this.fStyleMap.get("CHANGE_BOX");
        if (style == null) {
            style = this.fHSSFWorkbook.createCellStyle();
            this.setBorderThin(style, (short)13);
            style.setFillForegroundColor((short)41);
            style.setFillPattern((short)1);
            style.setWrapText(true);
            HSSFFont font2 = this.fHSSFWorkbook.createFont();
            font2.setFontName("\uff2d\uff33 \uff30\u660e\u671d");
            font2.setFontHeightInPoints((short)9);
            style.setFont(font2);
            this.fStyleMap.put("CHANGE_BOX", style);
        }
        return style;
    }

    protected boolean close() {
        boolean ret = false;
        if (this.fFileInputStream != null) {
            try {
                this.fFileInputStream.close();
                ret = true;
            }
            catch (IOException e) {
                this.fLogger.log(Level.SEVERE, "\u5165\u529b\u30d5\u30a1\u30a4\u30eb\u3092\u9589\u3058\u308b\u3053\u3068\u304c\u3067\u304d\u307e\u305b\u3093\u3067\u3057\u305f\u3002", e);
            }
            this.fFileInputStream = null;
        }
        return ret;
    }

    protected HSSFCell createHSSFCell(HSSFSheet sheet, String col, int row) {
        return this.createHSSFCell(sheet, this.getIndexByColAlphName(col), row);
    }

    protected HSSFCell createHSSFCell(HSSFSheet sheet, short col, int row) {
        HSSFCell ret = null;
        HSSFRow grow = sheet.getRow(row - 1);
        if (grow == null) {
            grow = sheet.createRow(row - 1);
        }
        ret = grow.createCell(col);
        try {
            ret.setEncoding((short)1);
        }
        catch (NullPointerException e) {
            this.fLogger.log(Level.SEVERE, "\u884c\u5217\u3010" + row + "/" + col + "\u3011", e);
            throw e;
        }
        return ret;
    }

    protected void removeHSSFCellByA1(HSSFSheet sheet, String col, int row) {
        HSSFCell ret = null;
        HSSFRow rows = sheet.getRow(row - 1);
        try {
            ret = rows.getCell(this.getIndexByColAlphName(col));
            if (ret != null) {
                rows.removeCell(ret);
            }
        }
        catch (NullPointerException e) {
            this.fLogger.log(Level.SEVERE, "\u884c\u5217\u3010" + row + "/" + col + "\u3011", e);
            throw e;
        }
    }

    protected void setBlankHSSFCellByA1(HSSFSheet sheet, String col, int row) {
        HSSFCell ret = null;
        HSSFRow rows = sheet.getRow(row - 1);
        try {
            ret = rows.getCell(this.getIndexByColAlphName(col));
            if (ret != null) {
                ret.setCellType(3);
            }
        }
        catch (NullPointerException e) {
            this.fLogger.log(Level.SEVERE, "\u884c\u5217\u3010" + row + "/" + col + "\u3011", e);
            throw e;
        }
    }

    protected HSSFCell getHSSFCellByA1(HSSFSheet sheet, String col, int row) {
        HSSFCell ret = null;
        HSSFRow rows = sheet.getRow(row - 1);
        try {
            ret = rows.getCell(this.getIndexByColAlphName(col));
            ret.setEncoding((short)1);
        }
        catch (NullPointerException e) {
            this.fLogger.log(Level.SEVERE, "\u884c\u5217\u3010" + row + "/" + col + "\u3011", e);
            throw new NullPointerException("\u884c\u5217\u3010" + row + "/" + col + "\u3011");
        }
        return ret;
    }

    protected HSSFSheet copySheet(String makeSheetName, String useSheetName, boolean remove) {
        int index;
        if (remove && (index = this.fHSSFWorkbook.getSheetIndex(makeSheetName)) >= 0) {
            this.fHSSFWorkbook.removeSheetAt(index);
        }
        int cindex = this.fHSSFWorkbook.getSheetIndex(useSheetName);
        HSSFSheet cSheet = this.fHSSFWorkbook.cloneSheet(cindex);
        this.fHSSFWorkbook.setSheetName(this.fHSSFWorkbook.getNumberOfSheets() - 1, makeSheetName);
        return cSheet;
    }

    protected void insertRow(HSSFSheet sheet, int rowNum, int templateRowNum, boolean doRefStyle) {
        sheet.shiftRows(rowNum, sheet.getPhysicalNumberOfRows(), 1, true, false);
        HSSFRow row = sheet.createRow(rowNum - 1);
        HSSFRow templateRow = sheet.getRow(templateRowNum - 1);
        row.setHeight(templateRow.getHeight());
        row.setHeightInPoints(templateRow.getHeightInPoints());
        int i = 0;
        while (i < templateRow.getPhysicalNumberOfCells()) {
            HSSFCell templateCell = templateRow.getCell((short)i);
            HSSFCell cell = row.createCell((short)i);
            if (doRefStyle) {
                cell.setCellStyle(templateCell.getCellStyle());
            } else {
                cell.setCellStyle(this.cloneCellStyle(templateCell.getCellStyle()));
            }
            this.copy(templateCell, cell, rowNum - templateRowNum);
            ++i;
        }
    }

    protected void removeMergedRegion(HSSFSheet sheet, String col, int row) {
        try {
            int i = 0;
            while (i < sheet.getNumMergedRegions()) {
                Region reg = sheet.getMergedRegionAt(i);
                if (reg.contains(row - 1, this.getIndexByColAlphName(col))) {
                    sheet.removeMergedRegion(i);
                    this.fLogger.warning("\u884c\u5217\u3010" + row + "/" + col + "\u3011\u306e\u30bb\u30eb\u7d50\u5408\u3092\u89e3\u9664\u3057\u307e\u3057\u305f\u3002");
                }
                ++i;
            }
        }
        catch (NullPointerException e) {
            this.fLogger.log(Level.SEVERE, "\u884c\u5217\u3010" + row + "/" + col + "\u3011", e);
            throw new NullPointerException("\u884c\u5217\u3010" + row + "/" + col + "\u3011");
        }
    }

    protected void tuneInExactlyRow(HSSFSheet sheet, int rowNum, int addRowNum) {
        HSSFRow row = sheet.getRow(rowNum - 1);
        int i = 0;
        while (i < row.getPhysicalNumberOfCells()) {
            HSSFCell cell = row.getCell((short)i);
            if (2 == cell.getCellType()) {
                String f = this.getTunedCellFormula(cell, addRowNum);
                HSSFCellStyle style = cell.getCellStyle();
                cell.setCellType(3);
                HSSFCell new_cell = row.createCell((short)i);
                new_cell.setCellStyle(style);
                try {
                    new_cell.setEncoding((short)1);
                }
                catch (NullPointerException e) {
                    this.fLogger.log(Level.SEVERE, "\u884c\u5217\u3010" + row + "/" + i + "\u3011", e);
                    throw new NullPointerException("\u884c\u5217\u3010" + row + "/" + i + "\u3011");
                }
                new_cell.setCellFormula(f);
            }
            ++i;
        }
    }

    private String getTunedCellFormula(HSSFCell cell, int addRowNum) {
        String f = cell.getCellFormula();
        Matcher matcher = fRowNumPattern.matcher(f);
        StringBuffer sb = new StringBuffer();
        while (matcher.find()) {
            int irow = Integer.parseInt(matcher.group(2));
            String newRow = String.valueOf(irow + addRowNum);
            matcher.appendReplacement(sb, String.valueOf(matcher.group(1)) + newRow);
        }
        matcher.appendTail(sb);
        return sb.toString();
    }

    protected void setBackGround(HSSFSheet sheet, short color, int rownum, String beginColumn, String endColumn) {
        int begin = this.getIndexByColAlphName(beginColumn);
        short end = this.getIndexByColAlphName(endColumn);
        HSSFRow row = sheet.getRow(rownum - 1);
        int i = begin;
        while (i <= end) {
            HSSFCellStyle cellstyle = row.getCell((short)i).getCellStyle();
            cellstyle.setFillForegroundColor(color);
            cellstyle.setFillPattern((short)1);
            ++i;
        }
    }

    protected void copy(HSSFCell from, HSSFCell to, int divRow) {
        to.setEncoding(from.getEncoding());
        to.setCellType(from.getCellType());
        switch (from.getCellType()) {
            case 0: {
                to.setCellValue(from.getNumericCellValue());
                break;
            }
            case 1: {
                to.setCellValue(from.getStringCellValue());
                break;
            }
            case 3: {
                break;
            }
            case 4: {
                to.setCellValue(from.getBooleanCellValue());
                break;
            }
            case 2: {
                to.setCellFormula(this.getTunedCellFormula(from, divRow));
                break;
            }
        }
    }

    public static String regReplace(String p, String r, String s) {
        Pattern pattern = Pattern.compile(p);
        Matcher matcher = pattern.matcher(s);
        StringBuffer sb = new StringBuffer();
        while (matcher.find()) {
            matcher.appendReplacement(sb, r);
        }
        matcher.appendTail(sb);
        return sb.toString();
    }

    protected String getCellString(HSSFCell cell) {
        String cellValue = null;
        block0 : switch (cell.getCellType()) {
            case 0: {
                cellValue = "" + cell.getNumericCellValue();
                break;
            }
            case 1: {
                cellValue = cell.getStringCellValue();
                break;
            }
            case 3: {
                cellValue = "";
                break;
            }
            case 4: {
                cellValue = "" + cell.getBooleanCellValue();
                break;
            }
            case 2: {
                cellValue = cell.getCellFormula();
                break;
            }
            case 5: {
                switch (cell.getErrorCellValue()) {
                    case 7: {
                        cellValue = "#DIV/0!";
                        break block0;
                    }
                    case 42: {
                        cellValue = "#N/A";
                        break block0;
                    }
                    case 29: {
                        cellValue = "#NAME?";
                        break block0;
                    }
                    case 0: {
                        cellValue = "#NULL!";
                        break block0;
                    }
                    case 36: {
                        cellValue = "#NUM!";
                        break block0;
                    }
                    case 23: {
                        cellValue = "#REF!";
                        break block0;
                    }
                    case 15: {
                        cellValue = "#VALUE!";
                        break block0;
                    }
                }
                cellValue = "undefined error...";
                break;
            }
            default: {
                cellValue = cell.getStringCellValue();
            }
        }
        return cellValue;
    }

    public boolean save() {
        FileOutputStream outStream = null;
        try {
            File fout = new File(this.fFile.getAbsolutePath());
            outStream = new FileOutputStream(fout);
            this.fHSSFWorkbook.write(outStream);
            return true;
        }
        catch (Exception ex) {
            this.fLogger.log(Level.SEVERE, "\u30d5\u30a1\u30a4\u30eb\u66f8\u304d\u8fbc\u307f\u30a8\u30e9\u30fc", ex);
            return false;
        }
        finally {
            try {
                if (outStream != null) {
                    outStream.close();
                }
            }
            catch (IOException ex) {
                this.fLogger.log(Level.SEVERE, "\u30d5\u30a1\u30a4\u30eb\u66f8\u304d\u8fbc\u307f\u30a8\u30e9\u30fc", ex);
            }
        }
    }

    public boolean save(File outFile) {
        FileOutputStream outStream = null;
        try {
            outStream = new FileOutputStream(outFile);
            this.fHSSFWorkbook.write(outStream);
            return true;
        }
        catch (Exception ex) {
            ex.printStackTrace();
            return false;
        }
        finally {
            try {
                if (outStream != null) {
                    outStream.close();
                }
            }
            catch (IOException ex) {
                ex.printStackTrace();
            }
        }
    }

    public void removeSheetAt(int index) {
        this.fHSSFWorkbook.removeSheetAt(index);
    }

    public void renameSheet(int index, String sheetName) {
        this.fHSSFWorkbook.setSheetName(index, sheetName, (short)1);
    }

    public void tuneRowHeight(HSSFSheet sheet, int row, int height) {
        HSSFRow row1 = sheet.createRow((short)row);
        row1.setHeightInPoints((short)height);
    }

    public HSSFCellStyle setCellAlignment(short alignment, short verticalAlignment, HSSFCellStyle style) {
        HSSFCellStyle newStyle = style;
        newStyle.setAlignment(alignment);
        newStyle.setVerticalAlignment(verticalAlignment);
        return newStyle;
    }
}

