/*
 * Decompiled with CFR 0.152.
 */
import com.sun.javadoc.ClassDoc;
import com.sun.javadoc.MethodDoc;
import hiro.yoshioka.job.AbsBasicPoiWriter;
import java.io.File;
import java.util.HashMap;
import org.apache.poi.hssf.usermodel.HSSFCell;
import org.apache.poi.hssf.usermodel.HSSFCellStyle;
import org.apache.poi.hssf.usermodel.HSSFFont;
import org.apache.poi.hssf.usermodel.HSSFSheet;

public class MsgWriter
extends AbsBasicPoiWriter {
    private int fOffset = 3;
    private int fClassCnt = 0;
    private HSSFCellStyle fHSSFCellStyle;
    private HSSFCellStyle fHSSFCellWhiteStyle;
    private HashMap nameMap = new HashMap();

    public MsgWriter() {
        super(new File("template/template1.xls"));
        this.init();
        this.createFont8();
    }

    private void createFont8() {
        HSSFFont font = this.fHSSFWorkbook.createFont();
        font.setFontHeightInPoints((short)8);
        font.setFontName("Verdana");
        this.fHSSFCellStyle = this.fHSSFWorkbook.createCellStyle();
        this.fHSSFCellStyle.setFont(font);
        this.setBorderThin(this.fHSSFCellStyle, (short)1);
        HSSFFont font2 = this.fHSSFWorkbook.createFont();
        font2.setFontHeightInPoints((short)8);
        font2.setColor((short)9);
        font2.setFontName("Verdana");
        this.fHSSFCellWhiteStyle = this.fHSSFWorkbook.createCellStyle();
        this.fHSSFCellWhiteStyle.setFont(font2);
        this.setBorderThin(this.fHSSFCellWhiteStyle, (short)1);
    }

    @Override
    public HSSFCell createHSSFCell(HSSFSheet sheet, String colno, int row) {
        HSSFCell cell = super.createHSSFCell(sheet, colno, row);
        cell.setCellStyle(this.fHSSFCellStyle);
        return cell;
    }

    @Override
    public HSSFCell createHSSFCell(HSSFSheet sheet, short colno, int row) {
        HSSFCell cell = super.createHSSFCell(sheet, colno, row);
        cell.setCellStyle(this.fHSSFCellStyle);
        return cell;
    }

    public void doWork(ClassDoc clazz) {
        HSSFSheet sheet = null;
        sheet = this.fHSSFWorkbook.getSheet("Sheet1");
        MethodDoc[] methodDocs = clazz.methods();
        ++this.fClassCnt;
        String pack = "";
        if (clazz.qualifiedName().indexOf(46) >= 0) {
            pack = clazz.qualifiedName().replaceAll("(.*)[.].*", "$1");
        }
        int i = 0;
        while (i < methodDocs.length) {
            HSSFCell cell = this.createHSSFCell(sheet, "B", this.fOffset);
            cell.setCellValue(this.fClassCnt);
            if (i > 0) {
                cell.setCellStyle(this.fHSSFCellWhiteStyle);
            }
            cell = this.createHSSFCell(sheet, "C", this.fOffset);
            cell.setCellValue(pack);
            if (i > 0) {
                cell.setCellStyle(this.fHSSFCellWhiteStyle);
            }
            cell = this.createHSSFCell(sheet, "D", this.fOffset);
            cell.setCellValue(clazz.modifiers());
            if (i > 0) {
                cell.setCellStyle(this.fHSSFCellWhiteStyle);
            }
            cell = this.createHSSFCell(sheet, "E", this.fOffset);
            cell.setCellValue(clazz.name());
            if (i > 0) {
                cell.setCellStyle(this.fHSSFCellWhiteStyle);
            }
            cell = this.createHSSFCell(sheet, "F", this.fOffset);
            cell.setCellValue(clazz.commentText());
            if (i > 0) {
                cell.setCellStyle(this.fHSSFCellWhiteStyle);
            }
            cell = this.createHSSFCell(sheet, "G", this.fOffset);
            cell.setCellValue(methodDocs[i].modifiers());
            cell = this.createHSSFCell(sheet, "H", this.fOffset);
            cell.setCellValue(methodDocs[i].name());
            cell = this.createHSSFCell(sheet, "I", this.fOffset);
            cell.setCellValue(methodDocs[i].commentText());
            cell = this.createHSSFCell(sheet, "J", this.fOffset);
            cell.setCellValue(methodDocs[i].position().line());
            ++this.fOffset;
            ++i;
        }
    }
}

