package hiro.yoshioka.sql.view;

import hiro.yoshioka.sql.params.ConnectionProperties;
import hiro.yoshioka.sql.resource.DBColumn;
import hiro.yoshioka.sql.resource.DBConstraint;
import hiro.yoshioka.sql.resource.DBCrossRefference;
import hiro.yoshioka.sql.resource.DBIndexRoot;
import hiro.yoshioka.sql.resource.DBResource;
import hiro.yoshioka.sql.resource.DBRoot;
import hiro.yoshioka.sql.resource.DBSchema;
import hiro.yoshioka.sql.resource.IDBColumn;
import hiro.yoshioka.sql.resource.IDBSchema;
import hiro.yoshioka.sql.resource.IDBSequence;
import hiro.yoshioka.sql.resource.IDBTable;
import hiro.yoshioka.sql.resource.IDBTrigger;
import hiro.yoshioka.sql.resource.RecentryUsedResource;
import hiro.yoshioka.util.ImageUtil;
import hiro.yoshioka.util.StringUtil;

import org.eclipse.jface.resource.ColorRegistry;
import org.eclipse.jface.resource.JFaceResources;
import org.eclipse.jface.viewers.StyledCellLabelProvider;
import org.eclipse.jface.viewers.StyledString;
import org.eclipse.jface.viewers.StyledString.Styler;
import org.eclipse.jface.viewers.ViewerCell;

public class DBTreeLabelProvider extends StyledCellLabelProvider {
	boolean isResource;
	boolean isType;

	public DBTreeLabelProvider(String columnName) {
		isResource = DBResourceTreeViewer.HEADER_NAME[0].equals(columnName);
		isType = DBResourceTreeViewer.HEADER_NAME[1].equals(columnName);
	}

	private void doResource(ViewerCell cell) {
		Object element = cell.getElement();

		StyledString styledString = null;
		if (element instanceof ConnectionProperties) {
			ConnectionProperties prop = (ConnectionProperties) element;
			styledString = new StyledString(prop.getDisplayString());
			styledString.append("(" + prop.getHost() + ")",
					StyledString.COUNTER_STYLER);
			if (prop.isConnected()) {
				cell.setImage(ImageUtil.getImage(ImageUtil.ACTION_32_CONNECT));
			} else {
				cell.setImage(ImageUtil
						.getImage(ImageUtil.ACTION_33_DISCONNECT));
			}
		} else if (element instanceof RecentryUsedResource) {
			RecentryUsedResource prop = (RecentryUsedResource) element;
			styledString = new StyledString(prop.getName(),
					styledString.COUNTER_STYLER);
		} else if (element instanceof DBResource) {
			DBResource resource = (DBResource) element;

			if (resource instanceof DBRoot) {
				styledString = new StyledString(resource.getName());
				cell.setImage(ImageUtil
						.getImage(ImageUtil.DBRESOURCE_01_DATABASE));
			} else if (resource instanceof DBConstraint) {
				styledString = new StyledString(
						((DBConstraint) resource).toString());
				String decoration = resource.getImageString();
				styledString.append(decoration, StyledString.COUNTER_STYLER);
			} else if (resource instanceof IDBColumn) {
				DBColumn obj = (DBColumn) resource;
				if (-1 != obj.getColumnType()) {
					String t = obj.cnvColumnType(obj.getColumnType()) + " "
							+ obj.getName() + " ";
					styledString = new StyledString(t);
					String decoration = obj.getDataTypeString() + "("
							+ obj.getSizeString() + ")";
					styledString
							.append(decoration, StyledString.COUNTER_STYLER);
				} else {
					String t = obj.getName() + " ";
					if (obj.isPkey()) {
						ColorRegistry reg = JFaceResources.getColorRegistry();
						Styler styler = StyledString.createColorRegistryStyler(
								"ERROR_COLOR", null);
						styledString = new StyledString(t, styler);
					} else if (obj.isNotNull()) {
						Styler styler = StyledString.createColorRegistryStyler(
								"ACTIVE_HYPERLINK_COLOR", null);
						styledString = new StyledString(t, styler);
					} else {
						styledString = new StyledString(t);
					}
					if (obj.getComment().length() > 0) {
						String decoration = "(" + obj.getComment() + ")";
						styledString.append(decoration,
								StyledString.COUNTER_STYLER);
					}
				}

				if (obj.isDate()) {
					cell.setImage(ImageUtil
							.getImage(ImageUtil.DBRESOURCE_50_DATE));
				} else if (obj.isString()) {
					cell.setImage(ImageUtil
							.getImage(ImageUtil.DBRESOURCE_51_LABEL));
				} else if (obj.isBlob() || obj.isBinary()) {
					cell.setImage(ImageUtil
							.getImage(ImageUtil.DBRESOURCE_52_GENERIC_REG));
				} else if (obj.isNumeric()) {
					cell.setImage(ImageUtil
							.getImage(ImageUtil.DBRESOURCE_53_NUMBER));
				} else {
					cell.setImage(ImageUtil
							.getImage(ImageUtil.DBRESOURCE_54_COLUMN));
				}
			} else if (resource instanceof IDBTable) {
				IDBTable table = (IDBTable) resource;
				if (!table.isValid()) {
					styledString = new StyledString("\u2620 "
							+ table.toString());
				} else {
					styledString = new StyledString(table.toString());
				}
				if (table.isView()) {
					cell.setImage(ImageUtil
							.getImage(ImageUtil.DBRESOURCE_04_VIEW));
				} else if (table.isFunction()) {
					cell.setImage(ImageUtil
							.getImage(ImageUtil.DBRESOURCE_08_FUNCTION));
				} else if (table.isTable()) {
					cell.setImage(ImageUtil
							.getImage(ImageUtil.DBRESOURCE_03_TABLE));
				} else if (table.isFunction()) {
					cell.setImage(ImageUtil
							.getImage(ImageUtil.DBRESOURCE_04_VIEW));
				} else if (table.isProcudeure()) {
					cell.setImage(ImageUtil
							.getImage(ImageUtil.DBRESOURCE_06_PROCEDURE));
				} else if (table.isSynonym()) {
					cell.setImage(ImageUtil
							.getImage(ImageUtil.DBRESOURCE_07_SYNONYM));
				}
			} else if (resource instanceof IDBTrigger) {
				IDBTrigger trigger = (IDBTrigger) resource;
				if (!trigger.isValid()) {
					styledString = new StyledString("\u2620 "
							+ trigger.toString());
				} else {
					styledString = new StyledString(trigger.toString());
				}
				cell.setImage(ImageUtil
						.getImage(ImageUtil.DBRESOURCE_05_TRIGGER));
			} else if (resource instanceof DBCrossRefference) {
				styledString = new StyledString(
						((DBCrossRefference) resource).toString());
				String decoration = resource.getImageString();
				styledString.append(decoration, StyledString.COUNTER_STYLER);
			} else if (resource instanceof DBSchema) {
				IDBSchema schema = (IDBSchema) resource;
				styledString = new StyledString(resource.getName());
				if (schema.isCurrent() || schema.isDefault()) {
					String decoration = String.format(" [%s]",
							schema.getCurrentDefaultString());
					styledString.append(decoration,
							StyledString.QUALIFIER_STYLER);
				}
				cell.setImage(ImageUtil
						.getImage(ImageUtil.DBRESOURCE_02_SCHEMA));
			} else if (resource instanceof IDBSequence) {
				styledString = new StyledString(resource.getName());
				cell.setImage(ImageUtil
						.getImage(ImageUtil.DBRESOURCE_80_SEQUENCE));
			} else if (resource instanceof DBIndexRoot) {
				styledString = new StyledString("INDEX");
				styledString.append("(" + resource.childrenNum() + ")",
						StyledString.COUNTER_STYLER);
				cell.setImage(ImageUtil.getImage(ImageUtil.DBRESOURCE_55_INDEX));
			} else {
				styledString = new StyledString(resource.getName());
			}

		} else {
			styledString = new StyledString("Unknown element");
		}
		cell.setText(styledString.toString());
		cell.setStyleRanges(styledString.getStyleRanges());
	}

	private void doType(ViewerCell cell) {
		Object element = cell.getElement();

		StyledString styledString = null;
		if (element instanceof ConnectionProperties) {
			ConnectionProperties prop = (ConnectionProperties) element;
			styledString = new StyledString(StringUtil.EMPTY_STRING);
		} else if (element instanceof RecentryUsedResource) {
			RecentryUsedResource prop = (RecentryUsedResource) element;
			styledString = new StyledString(String.format("%d/%d",
					prop.childrenNum(), prop.getSizeOfRecentryUsedResources()),
					styledString.COUNTER_STYLER);
		} else if (element instanceof DBResource) {
			DBResource resource = (DBResource) element;

			if (resource instanceof DBRoot) {
				styledString = new StyledString(StringUtil.EMPTY_STRING);
			} else if (resource instanceof IDBColumn) {
				DBColumn obj = (DBColumn) resource;
				styledString = new StyledString(StringUtil.nvl(obj
						.getDataTypeString()));
				if (obj.isDate() || obj.isTimeStamp()) {
					cell.setImage(ImageUtil
							.getImage(ImageUtil.DBRESOURCE_50_DATE));
				} else if (obj.isTime()) {
					cell.setImage(ImageUtil
							.getImage(ImageUtil.DBRESOURCE_56_TIME_OBJ));
				} else if (obj.isString()) {
					cell.setImage(ImageUtil
							.getImage(ImageUtil.DBRESOURCE_51_LABEL));
				} else if (obj.isBlob() || obj.isBinary()) {
					cell.setImage(ImageUtil
							.getImage(ImageUtil.DBRESOURCE_52_GENERIC_REG));
				} else if (obj.isNumeric()) {
					cell.setImage(ImageUtil
							.getImage(ImageUtil.DBRESOURCE_53_NUMBER));
				} else {
					cell.setImage(ImageUtil
							.getImage(ImageUtil.DBRESOURCE_54_COLUMN));
				}
				// String decoration = obj.getDataTypeString() + "("
				// + obj.getSizeString() + ")";
				// styledString.append(decoration, StyledString.COUNTER_STYLER);
				String decoration = String.format("(%s)", obj.getSizeString());
				styledString.append(decoration, StyledString.QUALIFIER_STYLER);
			} else if (resource instanceof IDBTable) {
				IDBTable table = (IDBTable) resource;
				styledString = new StyledString(StringUtil.EMPTY_STRING);
			} else {
				styledString = new StyledString(StringUtil.EMPTY_STRING);
			}

		} else {
			styledString = new StyledString("Unknown type");
		}
		cell.setText(styledString.toString());
		cell.setStyleRanges(styledString.getStyleRanges());
	}

	public void update(ViewerCell cell) {

		if (isResource) {
			doResource(cell);
		} else if (isType) {
			doType(cell);
		}

		super.update(cell);
	}
}