package hiro.yoshioka.sql.util;

import hiro.yoshioka.sql.IRequestListener;
import hiro.yoshioka.sql.engine.MongoTransactionRequest;
import hiro.yoshioka.sql.engine.Request;
import hiro.yoshioka.sql.engine.RequestAdaptor;
import hiro.yoshioka.sql.engine.SQLOperationType;
import hiro.yoshioka.sql.engine.SQLServerThread;
import hiro.yoshioka.sql.engine.TransactionRequest;
import hiro.yoshioka.sql.params.ConnectionProperties;
import hiro.yoshioka.sql.resource.IDBColumn;
import hiro.yoshioka.sql.resource.IDBTable;
import hiro.yoshioka.util.ColorNameEnum;
import hiro.yoshioka.util.ColorUtil;
import hiro.yoshioka.util.ImageUtil;
import hiro.yoshioka.util.StringUtil;

import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.List;
import java.util.regex.Pattern;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.eclipse.jface.dialogs.IMessageProvider;
import org.eclipse.jface.viewers.CellEditor;
import org.eclipse.jface.viewers.CheckboxCellEditor;
import org.eclipse.jface.viewers.ComboBoxCellEditor;
import org.eclipse.jface.viewers.ICellEditorListener;
import org.eclipse.jface.viewers.ICellModifier;
import org.eclipse.jface.viewers.ILabelProviderListener;
import org.eclipse.jface.viewers.IStructuredContentProvider;
import org.eclipse.jface.viewers.ITableLabelProvider;
import org.eclipse.jface.viewers.StructuredViewer;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.jface.viewers.TextCellEditor;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.window.ApplicationWindow;
import org.eclipse.swt.SWT;
import org.eclipse.swt.custom.CCombo;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Spinner;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableColumn;
import org.eclipse.swt.widgets.TableItem;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.forms.widgets.FormToolkit;
import org.eclipse.ui.forms.widgets.ScrolledForm;
import org.eclipse.ui.forms.widgets.Section;
import org.eclipse.ui.forms.widgets.TableWrapData;
import org.eclipse.ui.forms.widgets.TableWrapLayout;

import com.mongodb.BasicDBObject;
import com.mongodb.DBObject;

public class SelectTableDialog extends ApplicationWindow implements
		SelectionListener {

	protected Log fLogger = LogFactory.getLog(getClass());
	protected Spinner fMaxRowsFromDB;
	protected Spinner fMaxRowsInCell;
	protected Spinner fMaxColumnNameLength;
	protected IDBTable fIDBTable;
	protected Combo fScriptSelection;
	protected Combo fCharsetSelection;
	protected Section sqlSection;
	protected Text sqlText;
	protected String sqlStatementString;
	private TableViewer mainConditionTable;
	Label maxColumnNameSizeLabel, encodingCharSetLabel;
	Button btUpd;
	private Button fLogicalBtn, fBarBtn;
	static final String[] COMP = { "=", "<", "<=", ">=", ">", "LIKE", //$NON-NLS-1$ //$NON-NLS-2$ //$NON-NLS-3$ //$NON-NLS-4$ //$NON-NLS-5$ //$NON-NLS-6$
			"IS NULL", "IS NOT NULL" }; //$NON-NLS-1$ //$NON-NLS-2$
	static final String[] SORT = { StringUtil.EMPTY_STRING, "ASC", "DESC" }; //$NON-NLS-1$ //$NON-NLS-2$ //$NON-NLS-3$
	static final String[] HEADER = { "Display", "ColumnName", "Operator",
			"ConditionValue", "Sort" };
	static final int[] COL_SIZE = { 60, 230, 111, 230, 62 };
	Section section4;
	protected ConnectionProperties connectionProperties;
	IRequestListener requestListener;
	protected List<String> fCondList = new ArrayList<String>();

	protected DBObject returnFields;
	protected DBObject queryUsesedToSearch;
	protected DBObject orderBy;
	private Button unidUsingButton;

	public SelectTableDialog(ConnectionProperties connectionProperties,
			Shell parent, IDBTable dbTable, IRequestListener requestListener) {
		super(parent);
		this.requestListener = requestListener;
		this.connectionProperties = connectionProperties;
		this.fIDBTable = dbTable;
	}

	MyModel[] myModel;

	protected void execute(boolean upd) {
		sqlStatementString = sqlText.getText();
		setReturnCode(OK);
		if (isMongo()) {
			MongoTransactionRequest req = new MongoTransactionRequest(
					SQLOperationType.PREPARED_EXECUTE_QUERY,
					connectionProperties, fIDBTable);
			req.requestForUpdatable = upd;
			req.setQueryUsesedToSearch(queryUsesedToSearch);
			req.setReturnFields(returnFields);
			req.setOrderBy(orderBy);
			req.setMaxRownum(fMaxRowsFromDB.getSelection());
			req.setPartName(fIDBTable.getName());
			req.addListener(requestListener);

			SQLServerThread.putRequest(req);
			close();
		} else if (isDomino()) {
			TransactionRequest req = null;
			if (unidUsingButton.getSelection()) {
				String[] uids = sqlStatementString.split("\r\n|\r|\n");
				req = new TransactionRequest(
						SQLOperationType.UNID_EXECUTE_QUERY,
						connectionProperties, uids);
				req.setTable(fIDBTable);
			} else {
				req = new TransactionRequest(
						SQLOperationType.PREPARED_EXECUTE_QUERY,
						connectionProperties, fIDBTable);
			}
			// TODO:
			// req.requestForUpdatable = upd;
			// req.setQueryUsesedToSearch(queryUsesedToSearch);
			// req.setReturnFields(returnFields);
			//
			req.setMaxRownum(fMaxRowsFromDB.getSelection());
			// req.setPartName(fIDBTable.getName());
			req.addListener(requestListener);

			SQLServerThread.putRequest(req);
			close();
		} else {
			String[] bind = null;
			if (fCondList.size() > 0) {
				bind = fCondList.toArray(new String[fCondList.size()]);
			}
			TransactionRequest req = new TransactionRequest(
					SQLOperationType.PREPARED_EXECUTE_QUERY,
					connectionProperties, sqlText.getText(), bind, fIDBTable);
			req.requestForUpdatable = upd;
			req.setMaxRownum(fMaxRowsFromDB.getSelection());
			req.setPartName(fIDBTable.getName());
			req.addListener(requestListener);

			SQLServerThread.putRequest(req);
			close();
		}
	}

	protected void refreshStatement() {
		if (isMongo()) {
			refreshMongoStatement();
		} else {
			refreshSqlStatement();
		}
	}

	private void refreshMongoStatement() {
		try {
			IDBColumn[] columns = fIDBTable.getColumns();
			queryUsesedToSearch = null;

			boolean doWhere = false;
			for (int i = 0; i < myModel.length; i++) {
				if (myModel[i].condition.trim().length() > 0
						|| myModel[i].compareOperator >= 6) {
					doWhere = true;
					queryUsesedToSearch = new BasicDBObject();
					break;
				}
			}
			returnFields = new BasicDBObject();
			fCondList.clear();
			//			static final String[] COMP = { "=", "<", "<=", ">=", ">", "LIKE", //$NON-NLS-1$ //$NON-NLS-2$ //$NON-NLS-3$ //$NON-NLS-4$ //$NON-NLS-5$ //$NON-NLS-6$
			//				"IS NULL", "IS NOT NULL" }; //$NON-NLS-1$ //$NON-NLS-2$
			if (doWhere) {
				for (int i = 0; i < myModel.length; i++) {
					if (myModel[i].condition.trim().length() > 0
							|| myModel[i].compareOperator >= 6) {
						switch (myModel[i].compareOperator) {
						case 0:
							queryUsesedToSearch.put(columns[i].getName(),
									myModel[i].condition);
							break;
						case 1:
							queryUsesedToSearch.put(columns[i].getName(),
									new BasicDBObject("$lt",
											myModel[i].condition));
							break;
						case 2:
							queryUsesedToSearch.put(columns[i].getName(),
									new BasicDBObject("$le",
											myModel[i].condition));
							break;
						case 3:
							queryUsesedToSearch.put(columns[i].getName(),
									new BasicDBObject("$ge",
											myModel[i].condition));
							break;
						case 4:
							queryUsesedToSearch.put(columns[i].getName(),
									new BasicDBObject("$gt",
											myModel[i].condition));
							break;
						case 5:
							queryUsesedToSearch.put(columns[i].getName(),
									Pattern.compile(myModel[i].condition));
							break;
						case 6:
							queryUsesedToSearch.put(columns[i].getName(),
									new BasicDBObject("$exists", false));
							break;
						case 7:
							queryUsesedToSearch.put(columns[i].getName(),
									new BasicDBObject("$exists", true));
							break;
						}
					}
				}
			}

			String targetDB = null;
			StringBuilder colBuilder = null;
			if (fIDBTable.getParent().getName().trim().length() > 0) {
				targetDB = String
						.format("%s.%s", fIDBTable.getParent().getName(), fIDBTable.getName()); //$NON-NLS-1$
			} else {
				targetDB = fIDBTable.getName();
			}
			if (columns.length == 0) {
				if (doWhere) {
					sqlText.setText(String.format("%s.find( %s )", targetDB,
							queryUsesedToSearch.toString()));
				} else {
					sqlText.setText(String.format("%s.find()", targetDB));
				}
			} else {
				colBuilder = new StringBuilder();
				for (int i = 0, j = 0; i < columns.length; i++) {
					if (myModel[i].doDisplay) {
						if (j > 0) {
							colBuilder.append(","); //$NON-NLS-1$
						}
						colBuilder.append(String.format("\"%s\":1",
								columns[i].getName()));
						j++;
						returnFields.put(columns[i].getName(), "1");
					}
					if (i > 0 && i % 5 == 0 && (i + 1 < columns.length)) {
						colBuilder.append(StringUtil.LINE_SEPARATOR + " "); //$NON-NLS-1$
					}
				}
				System.out.println("retu=" + returnFields);
				if (doWhere) {
					sqlText.setText(String.format(
							"%s.find(%n  %s,%n  {%s} %n)", targetDB,
							queryUsesedToSearch.toString(),
							colBuilder.toString()));
				} else {
					sqlText.setText(String.format(
							"%s.find(%n  {},%n  {%s} %n)", targetDB,
							colBuilder.toString()));
				}
			}
			boolean doOrder = false;
			for (int i = 0; i < myModel.length; i++) {
				if (myModel[i].sort > 0) {
					doOrder = true;
					break;
				}
			}
			orderBy = new BasicDBObject();
			if (doOrder) {
				colBuilder = new StringBuilder();
				for (int i = 0; i < myModel.length; i++) {
					if (myModel[i].sort == 1) {
						colBuilder.append(String.format("\"%s\":1,",
								columns[i].getName()));
					} else if (myModel[i].sort == 2) {
						colBuilder.append(String.format("\"%s\":-1,",
								columns[i].getName()));
					}
				}
				colBuilder.setLength(colBuilder.length() - 1);
				sqlText.setText(String.format("%s.sort({%s})",
						sqlText.getText(), colBuilder.toString()));
			}
			sqlStatementString = sqlText.getText();
		} catch (RuntimeException e) {
			e.printStackTrace();
		}
	}

	private void refreshSqlStatement() {
		try {
			StringBuffer buf = new StringBuffer();
			if (fBarBtn.getSelection()) {
				buf.append("-- BAR_GRAPH_ON_CHART=true").append( //$NON-NLS-1$
						StringUtil.LINE_SEPARATOR);
			}
			if (fMaxRowsInCell.getSelection() > 1) {
				buf.append(String.format("-- multi_line=%d %n", fMaxRowsInCell //$NON-NLS-1$
						.getSelection()));
			}
			if (fScriptSelection.getSelectionIndex() > 0) {
				buf.append(String.format("-- interceptors [ %s ] %n", //$NON-NLS-1$
						fScriptSelection.getText()));
			}
			buf.append("SELECT ").append(StringUtil.LINE_SEPARATOR); //$NON-NLS-1$
			IDBColumn[] columns = fIDBTable.getColumns();
			if (columns.length == 0) {
				buf.append("* ").append(StringUtil.LINE_SEPARATOR); //$NON-NLS-1$
			} else {
				for (int i = 0, j = 0; i < columns.length; i++) {
					if (myModel[i].doDisplay) {
						if (j > 0) {
							buf.append(","); //$NON-NLS-1$
						}
						if (fLogicalBtn.getSelection()) {
							if (Charset
									.isSupported(fCharsetSelection.getText())) {
								buf.append(columns[i].getNameWithAsComment(
										Charset.forName(fCharsetSelection
												.getText()),
										fMaxColumnNameLength.getSelection()));
							}
						} else {
							buf.append(columns[i].getName());
						}
						j++;
					}
					if (i > 0 && i % 5 == 0 && (i + 1 < columns.length)) {
						buf.append(StringUtil.LINE_SEPARATOR + " "); //$NON-NLS-1$
					}
				}

			}
			buf.append(StringUtil.LINE_SEPARATOR).append("FROM "); //$NON-NLS-1$
			if (fIDBTable.getParent().getName().trim().length() > 0) {
				buf.append(String
						.format("%s.", fIDBTable.getParent().getName())); //$NON-NLS-1$
			}
			buf.append(String.format("%s %n", fIDBTable.getName())); //$NON-NLS-1$
			boolean doWhere = false;
			for (int i = 0; i < myModel.length; i++) {
				if (myModel[i].condition.trim().length() > 0
						|| myModel[i].compareOperator >= 6) {
					doWhere = true;
					break;
				}
			}
			fCondList.clear();
			if (doWhere) {
				buf.append("WHERE " + StringUtil.LINE_SEPARATOR); //$NON-NLS-1$
				for (int i = 0; i < myModel.length; i++) {
					if (myModel[i].condition.trim().length() > 0
							|| myModel[i].compareOperator >= 6) {
						if (myModel[i].compareOperator >= 6) {
							buf.append(String.format("%s %s ", columns[i] //$NON-NLS-1$
									.getName(),
									COMP[myModel[i].compareOperator]));
						} else {
							buf.append(String.format("%s %s ? ", columns[i] //$NON-NLS-1$
									.getName(),
									COMP[myModel[i].compareOperator]));
							fCondList.add(myModel[i].condition);
						}
						buf.append(" AND "); //$NON-NLS-1$
					}
				}
				buf.setLength(buf.length() - 5);
				buf.append(StringUtil.LINE_SEPARATOR);
			}

			boolean doOrder = false;
			for (int i = 0; i < myModel.length; i++) {
				if (myModel[i].sort > 0) {
					doOrder = true;
					break;
				}
			}
			if (doOrder) {
				buf.append("ORDER BY " + StringUtil.LINE_SEPARATOR); //$NON-NLS-1$
				for (int i = 0; i < myModel.length; i++) {
					if (myModel[i].sort > 0) {
						buf.append(columns[i].getName() + " " //$NON-NLS-1$
								+ SORT[myModel[i].sort] + ","); //$NON-NLS-1$
					}
				}
				buf.setLength(buf.length() - 1);
			}
			sqlStatementString = buf.toString();
			sqlText.setText(buf.toString());
		} catch (RuntimeException e) {
			// TODO Auto-generated catch block
			e.printStackTrace();
		}
	}

	private class MyLabelProvider implements ITableLabelProvider {

		@Override
		public Image getColumnImage(Object element, int columnIndex) {
			if (columnIndex == 0) {
				MyModel model = (MyModel) element;
				if (model.doDisplay) {
					return ImageUtil.getImage(ImageUtil.ACTION_83_INFO);
				}
			}
			return null;
		}

		@Override
		public String getColumnText(Object element, int columnIndex) {
			try {
				MyModel model = (MyModel) element;
				switch (columnIndex) {
				case 0:
					return StringUtil.EMPTY_STRING; //$NON-NLS-1$
				case 1:
					return StringUtil.EMPTY_STRING + model.columnName; //$NON-NLS-1$
				case 2:
					return COMP[model.compareOperator];
				case 3:
					return model.condition;
				case 4:
					return SORT[model.sort];
				}
				return StringUtil.EMPTY_STRING; //$NON-NLS-1$
			} catch (RuntimeException e) {
				// TODO Auto-generated catch block
				e.printStackTrace();
			}
			return "a"; //$NON-NLS-1$
		}

		@Override
		public void addListener(ILabelProviderListener listener) {
		}

		@Override
		public void dispose() {
		}

		@Override
		public boolean isLabelProperty(Object element, String property) {
			return false;
		}

		@Override
		public void removeListener(ILabelProviderListener listener) {
		}
	}

	public class MyModel {
		boolean doDisplay = true;

		String columnName;

		int compareOperator;

		String condition = StringUtil.EMPTY_STRING; //$NON-NLS-1$

		int sort;

		public MyModel(String columnName) {
			this.columnName = columnName;
		}

		public String toString() {
			return columnName + "=" + condition; //$NON-NLS-1$
		}
	}

	private class MyCellModifier implements ICellModifier {

		private TableViewer viewer;

		public void setViewer(TableViewer viewer) {
			this.viewer = viewer;
		}

		public boolean canModify(Object element, String property) {
			MyModel model = (MyModel) element;
			if (HEADER[1].equals(property)) {
				return false;
			} else if (HEADER[3].equals(property) && model.compareOperator >= 6) {
				return false;
			} else {
				return true;
			}
		}

		public Object getValue(Object element, String property) {
			MyModel model = (MyModel) element;
			if (HEADER[0].equals(property)) {
				return model.doDisplay;
			} else if (HEADER[1].equals(property)) {
				return model.columnName;
			} else if (HEADER[2].equals(property)) {
				return model.compareOperator;
			} else if (HEADER[3].equals(property)) {
				return model.condition;
			} else {
				return model.sort;
			}
		}

		public void modify(Object element, String property, Object value) {
			TableItem item = (TableItem) element;

			MyModel model = (MyModel) item.getData();
			if (HEADER[0].equals(property)) {
				model.doDisplay = ((Boolean) value).booleanValue();
			} else if (HEADER[1].equals(property)) {
				model.columnName = (String) value;
			} else if (HEADER[2].equals(property)) {
				model.compareOperator = ((Integer) value).intValue();
			} else if (HEADER[3].equals(property)) {
				model.condition = (String) value;
			} else {
				model.sort = ((Integer) value).intValue();
			}
			viewer.update(item.getData(), null);
			refreshStatement();
		}
	}

	private class MyContentProvider implements IStructuredContentProvider {

		public Object[] getElements(Object inputElement) {
			return (MyModel[]) inputElement;
		}

		public void dispose() {

		}

		public void inputChanged(Viewer viewer, Object oldInput, Object newInput) {

		}

	}

	public class DelegatingEditor extends CellEditor {
		private int colIdx;
		private StructuredViewer viewer;

		private CellEditor delegatingTextEditor;

		private CellEditor delegatingDropDownCompEditor;

		private CellEditor delegatingDropDownSortEditor;

		private CellEditor activeEditor;

		private CellEditor delegatingCheckBoxEditor;

		private class DelegatingListener implements ICellEditorListener {

			public void applyEditorValue() {
				fireApplyEditorValue();
			}

			public void cancelEditor() {
				fireCancelEditor();
			}

			public void editorValueChanged(boolean oldValidState,
					boolean newValidState) {
				fireEditorValueChanged(oldValidState, newValidState);
			}

		}

		public DelegatingEditor(int colIdx, StructuredViewer viewer,
				Composite parent) {
			super(parent);
			this.colIdx = colIdx;
			this.viewer = viewer;
			DelegatingListener l = new DelegatingListener();
			this.delegatingTextEditor = new TextCellEditor(parent);
			this.delegatingTextEditor.addListener(l);

			this.delegatingDropDownCompEditor = new ComboBoxCellEditor(parent,
					COMP, SWT.READ_ONLY);
			Control ctl = this.delegatingDropDownCompEditor.getControl();
			if (ctl instanceof CCombo) {
				CCombo cmb = (CCombo) ctl;
				cmb.setVisibleItemCount(COMP.length);
			}
			this.delegatingDropDownCompEditor.addListener(l);

			this.delegatingDropDownSortEditor = new ComboBoxCellEditor(parent,
					SORT, SWT.READ_ONLY);
			this.delegatingDropDownSortEditor.addListener(l);

			this.delegatingCheckBoxEditor = new CheckboxCellEditor(parent);
			this.delegatingCheckBoxEditor.addListener(l);

		}

		protected Control createControl(Composite parent) {
			return null;
		}

		protected Object doGetValue() {
			return activeEditor.getValue();
		}

		protected void doSetFocus() {
			activeEditor.setFocus();
		}

		public void activate() {
			if (activeEditor != null) {
				activeEditor.activate();
			}
		}

		protected void doSetValue(Object value) {
			switch (colIdx) {
			case 0:
				activeEditor = delegatingCheckBoxEditor;
				break;
			case 1:
				throw new RuntimeException("dont edit"); //$NON-NLS-1$
			case 2:
				activeEditor = delegatingDropDownCompEditor;
				break;
			case 3:
				activeEditor = delegatingTextEditor;
				break;
			case 4:
				activeEditor = delegatingDropDownSortEditor;
			}
			activeEditor.setValue(value);
		}

		public void deactivate() {
			if (activeEditor != null) {
				Control control = activeEditor.getControl();
				if (control != null && !control.isDisposed()) {
					control.setVisible(false);
				}
			}
		}

		public void dispose() {

		}

		public Control getControl() {
			return activeEditor.getControl();
		}
	}

	protected Control createContents(Composite parent) {
		getShell().setText(
				String.format("Select columns From %s", fIDBTable.getUName()));

		try {
			TableWrapLayout layout = new TableWrapLayout();
			layout.numColumns = 3;

			FormToolkit toolkit = new FormToolkit(parent.getDisplay());
			ScrolledForm root = toolkit.createScrolledForm(parent);
			Composite body = root.getBody();
			body.setLayout(layout);

			// ---------------------------------------
			if (isDomino()) {
				Section UNIDSection = toolkit.createSection(root.getBody(),
						Section.TITLE_BAR | Section.EXPANDED);
				TableWrapData twd00 = new TableWrapData(TableWrapData.FILL_GRAB,
						TableWrapData.TOP, 1, 3);

				UNIDSection.setLayoutData(twd00);
				UNIDSection.setText("using UNID or else");

				unidUsingButton = toolkit.createButton(UNIDSection, "check",
						SWT.CHECK);
				UNIDSection.setClient(unidUsingButton);
			}
			// ---------------------------------------

			int maxColumnNameSize = 0;
			root.setText("Select Condition");

			Section section = toolkit.createSection(root.getBody(),
					Section.EXPANDED | Section.TITLE_BAR);

			section.setText("Column Condition");
			TableWrapData twd0 = new TableWrapData(TableWrapData.FILL_GRAB,
					TableWrapData.TOP, 1, 3);

			section.setLayoutData(twd0);
			section.setLayout(new GridLayout());

			Composite c = new Composite(section, SWT.BORDER);
			c.setLayoutData(new GridData(GridData.FILL_HORIZONTAL));

			TableWrapLayout tr = new TableWrapLayout();
			tr.numColumns = 1;
			c.setLayout(tr);

			Table table = new Table(c, SWT.BORDER | SWT.FULL_SELECTION
					| SWT.V_SCROLL);
			final MyCellModifier modifier = new MyCellModifier();

			mainConditionTable = new TableViewer(table);
			modifier.setViewer(mainConditionTable);
			table.setLinesVisible(true);

			table.setHeaderVisible(true);
			CellEditor[] cellEditor = new CellEditor[HEADER.length];
			for (int i = 0; i < HEADER.length; i++) {
				TableColumn column = new TableColumn(table, SWT.NONE);
				column.setText(HEADER[i]);
				column.setWidth(COL_SIZE[i]);
				cellEditor[i] = new DelegatingEditor(i, mainConditionTable,
						mainConditionTable.getTable());
			}

			mainConditionTable.setLabelProvider(new MyLabelProvider());
			mainConditionTable.setContentProvider(new MyContentProvider());
			mainConditionTable.setCellModifier(modifier);
			mainConditionTable.setColumnProperties(HEADER);
			mainConditionTable.setCellEditors(cellEditor);

			TableWrapData layoutData = new TableWrapData(
					TableWrapData.FILL_GRAB);
			layoutData.heightHint = 5 + table.getItemHeight() * 9;
			twd0.heightHint = 19 + table.getItemHeight() * 10;
			table.setLayoutData(layoutData);

			IDBColumn[] cols = fIDBTable.getColumns();

			myModel = new MyModel[cols.length];
			for (int i = 0; i < cols.length; i++) {
				myModel[i] = new MyModel(cols[i].getName());
				maxColumnNameSize = cols[i].getMaxColumnNameLength();
			}
			mainConditionTable.setInput(myModel);

			section.setClient(c);

			// ---------------------------------------
			Section section2 = toolkit.createSection(root.getBody(),
					Section.EXPANDED | Section.TITLE_BAR);
			section2.setText("COLUMN AS Logial Name");
			section2.setLayoutData(new TableWrapData(TableWrapData.FILL_GRAB,
					TableWrapData.TOP, 1, 3));

			Composite inner2 = toolkit.createComposite(section2);
			section2.setClient(inner2);
			inner2.setLayout(new GridLayout(6, false));
			fLogicalBtn = toolkit
					.createButton(inner2, "LogicalName", SWT.CHECK);
			fLogicalBtn.addSelectionListener(this);
			fLogicalBtn.setSelection(false);
			maxColumnNameSizeLabel = toolkit.createLabel(inner2,
					"MaxColumnNameSize:");
			maxColumnNameSizeLabel.setForeground(ColorUtil
					.getColor(ColorNameEnum.GLAY));
			fMaxColumnNameLength = new Spinner(inner2, SWT.BORDER);
			fMaxColumnNameLength
					.setToolTipText("Column Name or the Alias maximum byte size");
			fMaxColumnNameLength.setMinimum(0);
			fMaxColumnNameLength.setMaximum(100);
			fMaxColumnNameLength.setSelection(maxColumnNameSize);
			fMaxColumnNameLength.setEnabled(false);
			encodingCharSetLabel = toolkit.createLabel(inner2,
					"Charset use in calc max name size:");
			encodingCharSetLabel.setForeground(ColorUtil
					.getColor(ColorNameEnum.GLAY));
			fCharsetSelection = new Combo(inner2, SWT.BORDER);
			fCharsetSelection
					.setToolTipText("Charset use in calc max name size");
			fCharsetSelection.setItems(StringUtil.ENCODINGS);
			fCharsetSelection.setEnabled(false);
			boolean doAddDefEncode = true;
			for (int i = 0; i < StringUtil.ENCODINGS.length; i++) {
				if (StringUtil.ENCODINGS[i]
						.equalsIgnoreCase(StringUtil.DEFAULT_ENCODING)) {
					fCharsetSelection.select(i);
					doAddDefEncode = false;
				}
			}
			if (doAddDefEncode) {
				fCharsetSelection.add(StringUtil.DEFAULT_ENCODING, 0);
				fCharsetSelection.select(0);
			}
			fCharsetSelection.setLayoutData(new GridData(
					GridData.FILL_HORIZONTAL));

			// ---------------------------------------
			Section section2_2 = toolkit.createSection(root.getBody(),
					Section.EXPANDED | Section.TITLE_BAR);
			section2_2.setText("MaxRows Selection");
			section2_2.setLayoutData(new TableWrapData(TableWrapData.FILL_GRAB,
					TableWrapData.TOP, 1, 1));

			fMaxRowsFromDB = new Spinner(section2_2, SWT.BORDER);
			fMaxRowsFromDB.setToolTipText("Max row num from database");
			fMaxRowsFromDB.setMinimum(1);
			fMaxRowsFromDB.setMaximum(100000);
			fMaxRowsFromDB.setSelection(connectionProperties.getMaxRowNum());
			fMaxRowsFromDB
					.setLayoutData(new GridData(GridData.FILL_HORIZONTAL));
			section2_2.setClient(fMaxRowsFromDB);
			// ---------------------------------------
			Section section2_3 = toolkit.createSection(root.getBody(),
					Section.TITLE_BAR);
			section2_3.setLayoutData(new TableWrapData(TableWrapData.FILL,
					TableWrapData.TOP, 1, 1));
			section2_3.setText("Current Row Num");
			final Label numOfRow = toolkit.createLabel(section2_3,
					StringUtil.HALF_SPACE__STRING);
			section2_3.setClient(numOfRow);

			if (connectionProperties.isConnected()) {
				TransactionRequest tr_count = new TransactionRequest(
						SQLOperationType.COUNT, connectionProperties, fIDBTable);
				tr_count.addListener(new RequestAdaptor() {
					@Override
					public void called_done(Request request,
							SQLOperationType operation,
							ConnectionProperties properteis, final Object o) {
						Display.getDefault().asyncExec(new Runnable() {
							@Override
							public void run() {
								if (!numOfRow.isDisposed()) {
									numOfRow.setText("" + o);
								}
							}
						});
					}
				});
				SQLServerThread.putRequest(tr_count);
			} else {
				root.setMessage("Now Disconnected...", IMessageProvider.ERROR);
			}

			// ---------------------------------------
			Section section2_4 = toolkit.createSection(root.getBody(),
					Section.EXPANDED | Section.TITLE_BAR);
			section2_4.setText("MaxRows In Cell");
			section2_4.setLayoutData(new TableWrapData(TableWrapData.FILL,
					TableWrapData.TOP, 1, 1));
			fMaxRowsInCell = new Spinner(section2_4, SWT.BORDER);
			section2_4.setClient(fMaxRowsInCell);
			fMaxRowsInCell
					.setToolTipText("Maximum row number in cell.default is 1. and all return code are trimed when display on cell.");
			fMaxRowsInCell.setMinimum(1);
			fMaxRowsInCell.setMaximum(10);
			fMaxRowsInCell.setSelection(1);
			fMaxRowsInCell
					.setLayoutData(new GridData(GridData.FILL_HORIZONTAL));
			fMaxRowsInCell.addSelectionListener(this);
			// ---------------------------------------
			Section section23_1 = toolkit.createSection(root.getBody(),
					Section.EXPANDED | Section.TITLE_BAR);
			section23_1
					.setText("JavaScript Interceptor, the file at [Navigator]-[script]");
			section23_1.setLayoutData(new TableWrapData(TableWrapData.FILL,
					TableWrapData.TOP, 1, 2));

			fScriptSelection = new Combo(section23_1, SWT.READ_ONLY);
			section23_1.setClient(fScriptSelection);
			// fScriptSelection.setItems(ResourceMarker.getScriptFolder().list());
			fScriptSelection.add("<Use Nothing Interceptor>", 0);
			fScriptSelection.select(0);

			fScriptSelection.addSelectionListener(this);

			// ---------------------------------------
			Section section23_2 = toolkit.createSection(root.getBody(),
					Section.EXPANDED | Section.TITLE_BAR);
			section23_2.setText("DISPLAY BAR-CHART IN CELL");
			section23_2.setLayoutData(new TableWrapData(TableWrapData.LEFT,
					TableWrapData.TOP, 1, 1));
			fBarBtn = toolkit.createButton(section23_2, "BAR CHART", SWT.CHECK);
			fBarBtn.addSelectionListener(this);
			fBarBtn.setSelection(false);
			section23_2.setClient(fBarBtn);

			// ---------------------------------------
			sqlSection = toolkit.createSection(root.getBody(), Section.TWISTIE
					| Section.TITLE_BAR | Section.EXPANDED);
			sqlSection.setLayout(new FillLayout());
			sqlSection.setText("SQL STATEMENT");
			if (isMongo()) {
				sqlSection.setText("Mongo Query Language Statement");
			}
			TableWrapData twd = new TableWrapData(TableWrapData.FILL,
					TableWrapData.FILL, 1, 3);
			twd.heightHint = 90 + (table.getItemCount() / 4 + 1) * 5;
			sqlSection.setLayoutData(twd);

			sqlText = toolkit.createText(sqlSection, "sel", SWT.MULTI
					| SWT.V_SCROLL | SWT.H_SCROLL);
			sqlSection.setClient(sqlText);

			// ---------------------------------------
			section4 = toolkit.createSection(root.getBody(), Section.EXPANDED
					| Section.TITLE_BAR);
			section4.setText("Execution");
			section4.setLayoutData(new TableWrapData(TableWrapData.FILL,
					TableWrapData.TOP, 1, 3));

			Composite inner4 = toolkit.createComposite(section4, SWT.NONE);
			inner4.setLayout(new GridLayout(3, false));

			btUpd = toolkit
					.createButton(inner4, "Execute For Update", SWT.PUSH);
			if (connectionProperties.isConnected()) {
				btUpd.addSelectionListener(new SelectionAdapter() {
					@Override
					public void widgetSelected(SelectionEvent e) {
						execute(true);
					}
				});
			} else {
				btUpd.setEnabled(false);
			}
			if (fIDBTable.hasPk()) {
				section4.setDescription(StringUtil.EMPTY_STRING);
			} else {
				section4.setDescription("The Table have no PrimaryKey\nIf you push [Select For Update],you can only insert...");
			}

			Button btOK = toolkit.createButton(inner4, "Execute", SWT.PUSH);
			if (connectionProperties.isConnected()) {
				btOK.addSelectionListener(new SelectionAdapter() {
					@Override
					public void widgetSelected(SelectionEvent e) {
						execute(false);
					}
				});
			} else {
				btOK.setEnabled(false);
			}

			Button btCan = toolkit.createButton(inner4, "Cansel", SWT.PUSH);
			btCan.addSelectionListener(new SelectionAdapter() {
				@Override
				public void widgetSelected(SelectionEvent e) {
					close();
				}
			});

			section4.setClient(inner4);

			refreshStatement();
			root.computeSize(540, 540);
			// root.setSize(540, 540);
			return root;
		} catch (RuntimeException e) {
			e.printStackTrace();
		}

		return parent;
	}

	public boolean isMongo() {
		if (connectionProperties == null) {
			return false;
		}
		return connectionProperties.getDatabaseType().isMongo();
	}

	public boolean isDomino() {
		if (connectionProperties == null) {
			return false;
		}
		return connectionProperties.getDatabaseType().isDomino();
	}

	// ------------------------------------------------------------
	// CLASS
	// ------------------------------------------------------------

	public String getSqlStatementString() {
		return StringUtil.nvl(sqlStatementString);
	}

	@Override
	public void widgetDefaultSelected(SelectionEvent e) {
	}

	@Override
	public void widgetSelected(SelectionEvent e) {
		if (e.getSource() == fLogicalBtn) {
			maxColumnNameSizeLabel
					.setForeground(fLogicalBtn.getSelection() ? ColorUtil
							.getColor(ColorNameEnum.BLACK) : ColorUtil
							.getColor(ColorNameEnum.GLAY));
			encodingCharSetLabel
					.setForeground(fLogicalBtn.getSelection() ? ColorUtil
							.getColor(ColorNameEnum.BLACK) : ColorUtil
							.getColor(ColorNameEnum.GLAY));
			fMaxColumnNameLength.setEnabled(fLogicalBtn.getSelection());
			fCharsetSelection.setEnabled(fLogicalBtn.getSelection());
			if (fLogicalBtn.getSelection()) {
				btUpd.setEnabled(false);
			} else {
				btUpd.setEnabled(true);
				if (fIDBTable.hasPk()) {
					section4.setDescription(StringUtil.EMPTY_STRING);
				} else {
					section4.setDescription("The Table have no PrimaryKey\nIf you push [Select For Update],you can only insert...");
				}
			}
		}
		refreshStatement();
	}
}