package hiro.yoshioka.sql.util;

import hiro.yoshioka.util.FileUtil;

import java.io.File;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class FileExtUtil {
	private static final Ext[] EXT_LIST;
	static {
		EXT_LIST = new Ext[] {
				new Ext("mpg", "RIFF.*CDXAfmt"),
				new Ext("avi", "RIFF.*AVI"),
				new Ext("jpg", "JFIF"),
				new Ext("jpg", "Exif"),
				new Ext("png", "NG"),
				new Ext("bmp", "BM"),
				new Ext("gif", "GIF87a"),
				new Ext("gif", "GIF89a"),
				new Ext("tif", "II[*]"),
				new Ext("wav", "RIFF....WAVEfmt"),
				new Ext("mp3", "..鐃縦"),
				new Ext("cda", "RIFF....CDDAfmt"),
				new Ext("ogg", "OggS.*vorbis"),
				new Ext("lzh", ".-lh5-"),
				new Ext("zip", "PK"),
				new Ext("exe", "This program cannot be run in DOS mode"),
				new Ext("rar", "Rar!"),
				new Ext("cab", "MSCF"),
				new Ext("tgz", "1F 8B 08 00 00"),
				new Ext("mpg", "鐔此"),
				new Ext("mpg", "鐔債"),
				new Ext("wmv", "0&"),
				new Ext("rm", "RMF.*PROP2"),
				new Ext("pdf", "^%PDF"),
				new Ext("mov", "....oov...lmvhd"),
				new Ext("ogm",
						"OggS........video...DIV3............OggS.........vorbis"),
				new Ext("gz", "1F 8B 08 00 00"), };
	}

	public static void main(String[] args) {
		String text = FileUtil.getText(new File(
				"D:/eclipse/blob/PICTURE/DATA7057"));
		System.out.println(getExt(text.substring(0, 256)));
	}

	public static String getExt(String firstPattern) {
		for (int i = 0; i < EXT_LIST.length; i++) {
			Matcher m = EXT_LIST[i].pattern.matcher(firstPattern);
			if (m.find()) {
				return EXT_LIST[i].name;
			}
		}
		return null;
	}
}

class Ext {
	String name;
	Pattern pattern;

	public Ext(String name, String pattern) {
		this.name = name;
		this.pattern = Pattern.compile(pattern);
	}
}