package hiro.yoshioka.sql.util;

import hiro.yoshioka.sql.params.ConnectionProperties;
import hiro.yoshioka.sql.params.ConnectionSettingBean;
import hiro.yoshioka.sql.params.PropetiesChangeType;

import java.util.Collection;
import java.util.LinkedHashSet;
import java.util.Set;

import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.swt.SWT;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.layout.RowLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.FileDialog;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.List;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Spinner;

public class ConnectionSettingDialog extends Dialog {
	ConnectionSettingBean fConnectionSettingBean;
	Set<ConnectionProperties> connectionSet;
	PropetiesChangeType changedType;

	public ConnectionSettingDialog(Shell shell,
			ConnectionSettingBean connectionSetBean) {
		super(shell);
		this.fConnectionSettingBean = connectionSetBean;
		this.connectionSet = connectionSetBean.getCloneConnectionSet();
		System.out.println("conedset=" + connectionSet);
	}

	List fJarList;

	DBDefineTableEditor fTableEditor;

	public static String[] COLUMN_PROPERTIES = { "USER", "URL" };

	boolean createdEditors;

	Spinner fQueryTimeOut;

	Spinner fPort;

	private void createDriverGroup(Composite inner) {
		Group gr = new Group(inner, SWT.SHADOW_ETCHED_OUT);
		GridLayout gl = new GridLayout(2, false);
		gl.marginHeight = 0;
		gl.marginWidth = 0;
		gl.horizontalSpacing = 0;
		gr.setLayout(gl);
		gr.setText("JDBC Driver Files");
		fJarList = new List(gr, SWT.SINGLE | SWT.BORDER | SWT.V_SCROLL);
		fJarList.setLayoutData(new GridData(GridData.FILL_BOTH));

		System.out.println("path="
				+ fConnectionSettingBean.getJdbcDriverFilePathSet());

		fJarList.setItems(fConnectionSettingBean.getJdbcDriverFilePathSet()
				.toArray(
						new String[fConnectionSettingBean
								.getJdbcDriverFilePathSet().size()]));

		Composite rightCmp = new Composite(gr, SWT.NONE);
		rightCmp.setLayout(new RowLayout(SWT.VERTICAL));
		rightCmp.setLayoutData(new GridData(GridData.FILL_VERTICAL));

		final FileDialog dialog = new FileDialog(getShell(), SWT.OPEN);
		Button addButton = new Button(rightCmp, SWT.NONE);
		addButton.setText("ADD File");
		addButton.addSelectionListener(new SelectionAdapter() {
			@Override
			public void widgetSelected(SelectionEvent e) {
				String openFile = dialog.open();
				if (openFile != null) {
					String[] items = fJarList.getItems();
					for (int i = 0; i < items.length; i++) {
						if (items[i].equals(openFile)) {
							return;
						}
					}
					fJarList.add(openFile);
				}
			}
		});

		Button delButton = new Button(rightCmp, SWT.NONE);
		delButton.setText("Del File");
		delButton.addSelectionListener(new SelectionAdapter() {
			@Override
			public void widgetSelected(SelectionEvent e) {
				if (fJarList.getSelectionIndex() >= 0) {
					fJarList.remove(fJarList.getSelectionIndex());
				}
			}
		});
	}

	protected Control createDialogArea(Composite parent) {
		try {

			parent.getShell().setText("Database Settings");

			Composite inner = new Composite(parent, SWT.NONE);
			inner.setLayout(new FillLayout());
			GridData gd3 = new GridData(GridData.FILL_HORIZONTAL);
			inner.setLayoutData(gd3);
			createDriverGroup(inner);
			// String[] pathes = PreferenceUtil.getString(
			// PreferenceConstants.JDBC_DRIVER_FILE_PATHS).split(
			// File.pathSeparator);
			// for (int i = 0; i < pathes.length; i++) {
			// if (pathes[i].trim().length() > 0) {
			// fJarList.add(pathes[i]);
			// }
			// }

			// --------------------------------------------------------------
			Group gr = new Group(parent, SWT.SHADOW_ETCHED_OUT);
			gr.setLayoutData(new GridData(GridData.FILL_BOTH));
			GridLayout gl = new GridLayout(2, false);
			gl.marginHeight = 0;
			gl.marginWidth = 0;
			gl.horizontalSpacing = 0;
			gr.setLayout(gl);
			gr.setText("Connection Properties");
			fTableEditor = new DBDefineTableEditor(this, gr);

			// fTableEditor.setLayoutData(new
			// GridData(GridData.FILL_HORIZONTAL));

			// // --------------------------------------------------------------
			// Section section3 = toolkit.createSection(root.getBody(),
			// Section.EXPANDED | Section.TITLE_BAR);
			// section3.setText("Statement Properties");
			//
			// Composite inner3 = toolkit.createComposite(section3);
			// GridLayout layout3 = new GridLayout();
			// layout3.numColumns = 3;
			// inner3.setLayout(layout3);
			//
			// toolkit.createLabel(inner3, "QueryTimeout");
			// toolkit.createLabel(inner3, "：");
			// fQueryTimeOut = new Spinner(inner3, SWT.BORDER);
			// fQueryTimeOut.setMinimum(0); // 最小値を指定
			// fQueryTimeOut.setMaximum(300); // 最大値を指定
			// fQueryTimeOut.setSelection(PreferenceUtil
			// .getInt(PreferenceConstants.SQL_TIMEOUT_NUM)); // 初期値を指定
			// fQueryTimeOut.setLayoutData(new
			// GridData(GridData.FILL_HORIZONTAL));
			//
			// section3.setClient(inner3);
			// section3.setLayoutData(new GridData(GridData.FILL_HORIZONTAL));
			//
			// // --------------------------------------------------------------
			// Section section4 = toolkit.createSection(root.getBody(),
			// Section.EXPANDED | Section.TITLE_BAR);
			// section4.setText("[LocalServer]HyperSonicSQL Properties");
			//
			// Composite inner4 = toolkit.createComposite(section4);
			// GridLayout layout4 = new GridLayout();
			// layout4.numColumns = 3;
			// inner4.setLayout(layout4);
			//
			// toolkit.createLabel(inner4, "Listern Port");
			// toolkit.createLabel(inner4, "：");
			// fPort = new Spinner(inner4, SWT.BORDER);
			//
			// fPort.setMinimum(1000); // 最小値を指定
			// fPort.setMaximum(10000); // 最大値を指定
			// fPort.setSelection(PreferenceUtil
			// .getInt(PreferenceConstants.HQL_PORT)); // 初期値を指定
			// fPort.setLayoutData(new GridData(GridData.FILL_HORIZONTAL));
			//
			// section4.setClient(inner4);
			// section4.setLayoutData(new GridData(GridData.FILL_HORIZONTAL));
			return parent;
		} catch (RuntimeException e) {
			// TODO 自動生成された catch ブロック
			e.printStackTrace();
		}
		return null;
	}

	public String[] listFiles() {
		return fJarList.getItems();
	}

	@Override
	protected void okPressed() {
		for (String jarFilePath : listFiles()) {
			fConnectionSettingBean.getJdbcDriverFilePathSet().add(jarFilePath);
		}
		super.okPressed();
	}

	public Collection<ConnectionProperties> getConnectionSet() {
		return connectionSet;
	}

	public PropetiesChangeType getChangeType() {
		return changedType;
	}

}