package hiro.yoshioka.sql.resource.notes;

import hiro.yoshioka.sdh.ResultSetDataHolder;
import hiro.yoshioka.sql.notes.ddl.Database;
import hiro.yoshioka.sql.notes.ddl.NotesDXLParser2;
import hiro.yoshioka.sql.resource.DBRoot;
import hiro.yoshioka.sql.resource.DBSchema;

import java.io.Serializable;

public class NotesDBSchema extends DBSchema implements Serializable {
	private static final long serialVersionUID = -3884377631040454806L;
	private Database db;

	public NotesDBSchema(DBRoot root) {
		super(root);
	}

	public void setDatabase(Database db) {
		this.db = db;
	}

	public Database getDatabase() {
		return db;
	}

	public String toHtmlString(ResultSetDataHolder rdh, int row) {
		return NotesDXLParser2.toHtmlString(rdh, row, db, null);
	}
}