package hiro.yoshioka.sql.resource;

import java.io.Serializable;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Properties;

public class RecentryUsedResource implements IDBResource, Serializable {
	private static final long serialVersionUID = -2460575492452593961L;
	private List<IDBTable> tableList;
	private int sizeOfRecentryUsedResources = 10;
	private DBRoot parent;

	public RecentryUsedResource(DBRoot root) {
		parent = root;
	}

	public void setSizeOfRecentryUsedResources(int sizeOfRecentryUsedResources) {
		if (sizeOfRecentryUsedResources > 0) {
			this.sizeOfRecentryUsedResources = sizeOfRecentryUsedResources;
			if (tableList.size() > this.sizeOfRecentryUsedResources) {
				tableList = tableList.subList(0,
						this.sizeOfRecentryUsedResources);
			}
		}
	}

	public int getSizeOfRecentryUsedResources() {
		return sizeOfRecentryUsedResources;
	}

	public void add(IDBTable table) {
		if (table == null) {
			return;
		}
		if (tableList == null) {
			tableList = new ArrayList<IDBTable>();
		}
		if (tableList.contains(table)) {
			int idx = tableList.indexOf(table);
			tableList.add(tableList.remove(idx));
		} else {
			if (tableList.size() > sizeOfRecentryUsedResources) {
				tableList.remove(0);
			}
			tableList.add(table);
		}
	}

	public void removeAll() {
		tableList.clear();
		tableList = null;
	}

	public void remove(String name) {
		if (tableList == null) {
			return;
		}
		tableList.remove(name);
	}

	@Override
	public void setName(String name) {
		// TODO Auto-generated method stub

	}

	@Override
	public DBRoot getRoot() {
		return parent;
	}

	@Override
	public void slimUp() {
		// TODO Auto-generated method stub

	}

	@Override
	public String getName() {
		return "RecentryUsed";
	}

	@Override
	public String getNameWithComment() {
		// TODO Auto-generated method stub
		return null;
	}

	@Override
	public String getNameWithComment(Charset charset, int maxColumnNameLen) {
		// TODO Auto-generated method stub
		return null;
	}

	@Override
	public String getNameWithAsComment() {
		// TODO Auto-generated method stub
		return null;
	}

	@Override
	public String getNameWithAsComment(Charset charset, int maxColumnNameLen) {
		// TODO Auto-generated method stub
		return null;
	}

	@Override
	public String getUName() {
		return getName().toUpperCase();
	}

	@Override
	public boolean startsNameWith(String string) {
		// TODO Auto-generated method stub
		return false;
	}

	@Override
	public List<IDBResource> startsWithResourceLists(String pattern) {
		// TODO Auto-generated method stub
		return null;
	}

	@Override
	public boolean startsCommentWith(String string) {
		// TODO Auto-generated method stub
		return false;
	}

	@Override
	public void setPropertyValue(String key, String value) {
		// TODO Auto-generated method stub

	}

	@Override
	public String getPropertyValue(String key) {
		// TODO Auto-generated method stub
		return null;
	}

	@Override
	public Properties getProperties() {
		// TODO Auto-generated method stub
		return null;
	}

	@Override
	public void setProperties(Properties p) {
		// TODO Auto-generated method stub

	}

	@Override
	public boolean isValid() {
		// TODO Auto-generated method stub
		return false;
	}

	@Override
	public void setValid(boolean valid) {
		// TODO Auto-generated method stub

	}

	@Override
	public Object getImage() {
		// TODO Auto-generated method stub
		return null;
	}

	@Override
	public String getComment() {
		// TODO Auto-generated method stub
		return null;
	}

	@Override
	public String getUComment() {
		// TODO Auto-generated method stub
		return null;
	}

	@Override
	public String getImageString() {
		// TODO Auto-generated method stub
		return null;
	}

	@Override
	public void setComment(String comment) {
		// TODO Auto-generated method stub

	}

	@Override
	public IDBResource[] listArrayResources() {
		if (tableList == null) {
			return EMPTY_DBRESOURCE_ARRAY;
		}
		return tableList.toArray(new IDBTable[tableList.size()]);
	}

	@Override
	public void setResources(Map<String, IDBResource> map) {
		// TODO Auto-generated method stub

	}

	@Override
	public IDBResource getResource(String key) {
		// TODO Auto-generated method stub
		return null;
	}

	@Override
	public void putResource(String key, IDBResource child) {
		// TODO Auto-generated method stub

	}

	@Override
	public IDBResource getParent() {
		return parent;
	}

	@Override
	public int childrenNum() {
		if (tableList == null) {
			return 0;
		}
		return tableList.size();
	}

	@Override
	public boolean contain(String pattern) {
		// TODO Auto-generated method stub
		return false;
	}

	public void addAll(RecentryUsedResource recentryUsedResource) {
		for (IDBTable moto : recentryUsedResource.tableList) {
			IDBResource motoSchema = moto.getParent();
			if (motoSchema != null) {
				IDBTable newTble = parent.getTable(motoSchema.getName(),
						moto.getName());
				add(newTble);
			}
		}
	}
}
