package hiro.yoshioka.sql.notes.reflect;

import hiro.yoshioka.classmanager.ClassManager;

import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.net.MalformedURLException;

public class WolfNoteCollection extends AbsWolfDominoReflection {

	Method add_form;
	Method add_string;
	Method selectAllDesignElements;
	Method setSelectHelpAbout;
	Method buildCollection;

	public WolfNoteCollection(ClassManager classManager, Object targetInstance)
			throws MalformedURLException, ClassNotFoundException,
			SecurityException, NoSuchMethodException {
		super(classManager, targetInstance);

		add_form = dominoClass.getMethod("add",
				new WolfForm(classManager, null).getDominoClass());
		add_string = dominoClass.getMethod("add", String.class);
		selectAllDesignElements = dominoClass.getMethod(
				"selectAllDesignElements", boolean.class);
		setSelectHelpAbout = dominoClass.getMethod("setSelectHelpAbout",
				boolean.class);
		buildCollection = dominoClass.getMethod("buildCollection");

	}

	@Override
	public String getDominoClassName() {
		return "lotus.domino.NoteCollection";
	}

	public void add_string(String str) throws IllegalArgumentException,
			IllegalAccessException, InvocationTargetException {
		add_string.invoke(targetInstance, str);
	}

	public void add_form(Object form) throws IllegalArgumentException,
			IllegalAccessException, InvocationTargetException {
		add_form.invoke(targetInstance, form);
	}

	public void selectAllDesignElements(boolean b)
			throws IllegalArgumentException, IllegalAccessException,
			InvocationTargetException {
		selectAllDesignElements.invoke(targetInstance, b);
	}

	public void setSelectHelpAbout(boolean b) throws IllegalArgumentException,
			IllegalAccessException, InvocationTargetException {
		setSelectHelpAbout.invoke(targetInstance, b);
	}

	public void buildCollection() throws IllegalArgumentException,
			IllegalAccessException, InvocationTargetException {
		buildCollection.invoke(targetInstance);
	}
}
