package hiro.yoshioka.sql.notes.reflect;

import hiro.yoshioka.classmanager.ClassManager;
import hiro.yoshioka.sql.resource.notes.ItemType;
import hiro.yoshioka.util.StringUtil;

import java.io.File;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.net.MalformedURLException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Vector;

public class WolfItem extends AbsWolfDominoReflection {
	Method getName;
	Method getType;
	Class richTextItemClass;
	Method getEmbeddedObjects;

	public WolfItem(ClassManager classManager, Object instance)
			throws MalformedURLException, ClassNotFoundException,
			SecurityException, NoSuchMethodException {
		super(classManager, instance);
		// lotus.domino.ACLEntry
		// wolf_acl_entry = new WolfACLEntry(classManager);
		getName = dominoClass.getMethod("getName");
		getType = dominoClass.getMethod("getType");
		// lotus.domino.RichTextItem
		richTextItemClass = classManager
				.getClassForName("lotus.domino.RichTextItem");
		getEmbeddedObjects = richTextItemClass.getMethod("getEmbeddedObjects");
	}

	@Override
	public String getDominoClassName() {
		return "lotus.domino.Item";
	}

	public String getName() throws IllegalArgumentException,
			IllegalAccessException, InvocationTargetException {
		return (String) getName.invoke(targetInstance);
	}

	public ItemType getType() throws IllegalArgumentException,
			IllegalAccessException, InvocationTargetException {
		return ItemType.parse((Integer) getType.invoke(targetInstance));
	}

	public List<WolfEmbeddedObject> getEmbeddedObjects()
			throws IllegalArgumentException, IllegalAccessException,
			InvocationTargetException, MalformedURLException,
			SecurityException, ClassNotFoundException, NoSuchMethodException {
		Vector instance = (Vector) getEmbeddedObjects.invoke(targetInstance);
		if (instance == null) {
			return Collections.EMPTY_LIST;
		}
		List<WolfEmbeddedObject> retList = new ArrayList<WolfEmbeddedObject>();
		for (Object o : instance) {
			retList.add(new WolfEmbeddedObject(classManager, o));
		}

		return retList;
	}

	public void saveAttachment(File outDir) throws Exception {
		try {
			for (WolfEmbeddedObject obj : getEmbeddedObjects()) {
				if (obj.getType() == WolfEmbeddedObject.EMBED_ATTACHMENT) {
					outDir.mkdirs();
					File to = new File(outDir, obj.getSource().replaceAll(
							StringUtil.TAB_STRING, StringUtil.EMPTY_STRING));
					obj.extractFile(to.getAbsolutePath());
				}
			}
		} catch (Exception e) {
			e.printStackTrace();
		}
	}

	@Override
	public String toString() {
		try {
			return String.format("WolfItem %s [%s]", getName(), getType()
					.name());
		} catch (Exception e) {
			e.printStackTrace();
		}
		return "WolfItem";
	}

	public boolean isRichText() {
		return richTextItemClass.isInstance(targetInstance);
	}
}
