package hiro.yoshioka.sql.notes.reflect;

import hiro.yoshioka.classmanager.ClassManager;

import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.net.MalformedURLException;

public class WolfDxlExporter extends AbsWolfDominoReflection {
	Method setOutputDOCTYPE;
	Method exportDxl;
	Method setConvertNotesBitmapsToGIF;

	public WolfDxlExporter(ClassManager classManager, Object targetInstance)
			throws MalformedURLException, ClassNotFoundException,
			SecurityException, NoSuchMethodException {
		super(classManager, targetInstance);

		setOutputDOCTYPE = dominoClass.getMethod("setOutputDOCTYPE",
				boolean.class);
		setConvertNotesBitmapsToGIF = dominoClass.getMethod(
				"setConvertNotesBitmapsToGIF", boolean.class);
		exportDxl = dominoClass.getMethod("exportDxl", new WolfNoteCollection(
				classManager, null).getDominoClass());

	}

	@Override
	public String getDominoClassName() {
		return "lotus.domino.DxlExporter";
	}

	public void setOutputDOCTYPE(boolean outputDocType)
			throws IllegalArgumentException, IllegalAccessException,
			InvocationTargetException, MalformedURLException {
		setOutputDOCTYPE.invoke(targetInstance, outputDocType);

	}

	public void setConvertNotesBitmapsToGIF(boolean doGif)
			throws IllegalArgumentException, IllegalAccessException,
			InvocationTargetException, MalformedURLException {
		setConvertNotesBitmapsToGIF.invoke(targetInstance, doGif);

	}

	public String exportDxl(WolfNoteCollection collection)
			throws IllegalArgumentException, IllegalAccessException,
			InvocationTargetException, MalformedURLException {
		return (String) exportDxl.invoke(targetInstance,
				collection.getTargetInstance());
	}
}
