package hiro.yoshioka.sql.notes.reflect;

import hiro.yoshioka.classmanager.ClassManager;

import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.net.MalformedURLException;
import java.util.Vector;

public class WolfACLEntry extends AbsWolfDominoReflection {
	Method getName;
	Method getRoles;
	Method getUserType;
	Method getLevel;
	Method isAdminReaderAuthor;
	Method isAdminServer;
	Method isCanCreateDocuments;
	Method isCanCreateLSOrJavaAgent;
	Method isCanCreatePersonalAgent;
	Method isCanCreatePersonalFolder;
	Method isCanCreateSharedFolder;
	Method isCanDeleteDocuments;
	Method isCanReplicateOrCopyDocuments;
	Method isGroup;
	Method isPerson;
	Method isPublicReader;
	Method isPublicWriter;
	Method isRoleEnabled;
	Method isServer;

	public WolfACLEntry(ClassManager classManager)
			throws MalformedURLException, ClassNotFoundException,
			SecurityException, NoSuchMethodException {
		super(classManager);
		getName = dominoClass.getMethod("getName");
		getRoles = dominoClass.getMethod("getRoles");
		getUserType = dominoClass.getMethod("getUserType");
		getLevel = dominoClass.getMethod("getLevel");

		isAdminReaderAuthor = dominoClass.getMethod("isAdminReaderAuthor");
		isAdminServer = dominoClass.getMethod("isAdminServer");
		isCanCreateDocuments = dominoClass.getMethod("isCanCreateDocuments");
		isCanCreateLSOrJavaAgent = dominoClass
				.getMethod("isCanCreateLSOrJavaAgent");
		isCanCreatePersonalAgent = dominoClass
				.getMethod("isCanCreatePersonalAgent");
		isCanCreatePersonalFolder = dominoClass
				.getMethod("isCanCreatePersonalFolder");
		isCanCreateSharedFolder = dominoClass
				.getMethod("isCanCreateSharedFolder");
		isCanDeleteDocuments = dominoClass.getMethod("isCanDeleteDocuments");
		isCanReplicateOrCopyDocuments = dominoClass
				.getMethod("isCanReplicateOrCopyDocuments");
		isGroup = dominoClass.getMethod("isGroup");
		isPerson = dominoClass.getMethod("isPerson");
		isPublicReader = dominoClass.getMethod("isPublicReader");
		isPublicWriter = dominoClass.getMethod("isPublicWriter");
		isRoleEnabled = dominoClass.getMethod("isRoleEnabled", String.class);
		isServer = dominoClass.getMethod("isServer");
	}

	@Override
	public String getDominoClassName() {
		return "lotus.domino.ACLEntry";
	}

	public String getName() throws IllegalArgumentException,
			IllegalAccessException, InvocationTargetException {
		return (String) getName.invoke(targetInstance);
	}

	public Vector<String> getRoles() throws IllegalArgumentException,
			IllegalAccessException, InvocationTargetException {
		return (Vector<String>) getRoles.invoke(targetInstance);
	}

	public UserType getUserType() throws IllegalArgumentException,
			IllegalAccessException, InvocationTargetException {
		return UserType.parse((Integer) getUserType.invoke(targetInstance));
	}

	public LevelType getLevel() throws IllegalArgumentException,
			IllegalAccessException, InvocationTargetException {
		return LevelType.parse((Integer) getLevel.invoke(targetInstance));
	}

	public boolean isAdminReaderAuthor() throws IllegalArgumentException,
			IllegalAccessException, InvocationTargetException {
		return (Boolean) isAdminReaderAuthor.invoke(targetInstance);
	}

	public boolean isAdminServer() throws IllegalArgumentException,
			IllegalAccessException, InvocationTargetException {
		return (Boolean) isAdminServer.invoke(targetInstance);
	}

	public boolean isCanCreateDocuments() throws IllegalArgumentException,
			IllegalAccessException, InvocationTargetException {
		return (Boolean) isCanCreateDocuments.invoke(targetInstance);
	}

	public boolean isCanCreateLSOrJavaAgent() throws IllegalArgumentException,
			IllegalAccessException, InvocationTargetException {
		return (Boolean) isCanCreateLSOrJavaAgent.invoke(targetInstance);
	}

	public boolean isCanCreatePersonalAgent() throws IllegalArgumentException,
			IllegalAccessException, InvocationTargetException {
		return (Boolean) isCanCreatePersonalAgent.invoke(targetInstance);
	}

	public boolean isCanCreatePersonalFolder() throws IllegalArgumentException,
			IllegalAccessException, InvocationTargetException {
		return (Boolean) isCanCreatePersonalFolder.invoke(targetInstance);
	}

	public boolean isCanCreateSharedFolder() throws IllegalArgumentException,
			IllegalAccessException, InvocationTargetException {
		return (Boolean) isCanCreateSharedFolder.invoke(targetInstance);
	}

	public boolean isCanDeleteDocuments() throws IllegalArgumentException,
			IllegalAccessException, InvocationTargetException {
		return (Boolean) isCanDeleteDocuments.invoke(targetInstance);
	}

	public boolean isCanReplicateOrCopyDocuments()
			throws IllegalArgumentException, IllegalAccessException,
			InvocationTargetException {
		return (Boolean) isCanReplicateOrCopyDocuments.invoke(targetInstance);
	}

	public boolean isGroup() throws IllegalArgumentException,
			IllegalAccessException, InvocationTargetException {
		return (Boolean) isGroup.invoke(targetInstance);
	}

	public boolean isPerson() throws IllegalArgumentException,
			IllegalAccessException, InvocationTargetException {
		return (Boolean) isPerson.invoke(targetInstance);
	}

	public boolean isPublicReader() throws IllegalArgumentException,
			IllegalAccessException, InvocationTargetException {
		return (Boolean) isPublicReader.invoke(targetInstance);
	}

	public boolean isPublicWriter() throws IllegalArgumentException,
			IllegalAccessException, InvocationTargetException {
		return (Boolean) isPublicWriter.invoke(targetInstance);
	}

	public boolean isRoleEnabled(String roleName)
			throws IllegalArgumentException, IllegalAccessException,
			InvocationTargetException {
		return (Boolean) isRoleEnabled.invoke(targetInstance, roleName);
	}

	public boolean isServer() throws IllegalArgumentException,
			IllegalAccessException, InvocationTargetException {
		return (Boolean) isServer.invoke(targetInstance);
	}

	@Override
	public String toString() {
		StringBuilder buf = new StringBuilder();
		try {
			buf.append(String.format("ACL Entry[%s] UserType[%s]%n", getName(),
					getUserType().getName()));

			buf.append(String
					.format("   AdminReaderAuthor[%b] CanReplicateOrCopyDocuments[%b] %n",
							isAdminReaderAuthor(),
							isCanReplicateOrCopyDocuments()));
			buf.append(String.format(
					"   CanCreateDocuments[%b] CanCreateLSOrJavaAgent[%b] %n",
					isCanCreateDocuments(), isCanCreateLSOrJavaAgent()));
			buf.append(String.format(
					"   CanCreatePersonalAgent[%b] CanDeleteDocuments[%b] %n",
					isCanCreatePersonalAgent(), isCanDeleteDocuments()));
			buf.append(String
					.format("   CanCreateSharedFolder[%b] CanCreatePersonalFolder[%b] %n",
							isCanCreateSharedFolder(),
							isCanCreatePersonalFolder()));
			buf.append(String.format("   AdminServer[%b] Server[%b] %n",
					isAdminServer(), isServer()));
			buf.append(String.format("   Group[%b] Person[%b] %n", isGroup(),
					isPerson()));
			buf.append(String.format("   PublicReader[%b] PublicWriter[%b] %n",
					isPublicReader(), isPublicWriter()));
			buf.append(String.format("    Roles%n"));
			for (String roleName : getRoles()) {
				buf.append(String.format("      [%s][%b] %n", roleName,
						isRoleEnabled(roleName)));
			}
		} catch (Exception e) {
			e.printStackTrace();
		}
		return buf.toString();
	}
}
