package hiro.yoshioka.sql.notes.reflect;

public enum UserType {

	TYPE_MIXED_GROUP(3, "݃O[v"),

	TYPE_PERSON(1, "[U["),

	TYPE_PERSON_GROUP(4, "[U[O[v"),

	TYPE_SERVER(2, "T[o["),

	TYPE_SERVER_GROUP(5, "T[o[O[v"),

	TYPE_UNSPECIFIED(0, "wȂ"), UNKOWN(-99999999, "s");

	private int typeId;
	private String name;

	private UserType(int typeId, String name) {
		this.typeId = typeId;
		this.name = name;
	}

	public String getName() {
		return name;
	}

	public static UserType parse(int typeId) {
		for (UserType target : values()) {
			if (target.typeId == typeId) {
				return target;
			}
		}
		return UNKOWN;
	}

	public int getTypeId() {
		return typeId;
	}

}
