package hiro.yoshioka.sql.notes.ddl;

import hiro.yoshioka.sdh.ResultSetDataHolder;
import hiro.yoshioka.util.StringUtil;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Properties;

import org.w3c.dom.DOMException;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class Form implements Serializable {
	private static final long serialVersionUID = -6342467648865199103L;
	private Map<Integer, Pardef> pardefMap = new LinkedHashMap<Integer, Pardef>();
	private List<Par> parList = new ArrayList<Par>();
	String name;
	String alias;
	String bgcolor;
	Boolean nocompose;
	Boolean publicaccess;
	Boolean defaultVal;
	Database parent;

	public Form(Database parent, Node atts) {
		this.parent = parent;
		NamedNodeMap names = atts.getAttributes();
		name = getAttrValueString(names, "name");
		alias = getAttrValueString(names, "alias");
		bgcolor = getAttrValueString(names, "bgcolor");
		nocompose = getAttrValueBoolean(names, "nocompose");
		publicaccess = getAttrValueBoolean(names, "publicaccess");
		defaultVal = getAttrValueBoolean(names, "default");
	}

	public String toCssString() {
		StringBuilder buf = new StringBuilder();
		for (Integer i : pardefMap.keySet()) {
			Pardef def = pardefMap.get(i);
			buf.append(String.format(".par_%d{ %s }%n", i,
					def.toCssString(false)));
		}
		return buf.toString();
	}

	public String toHtmlString(ResultSetDataHolder rdh, int row) {
		StringBuilder buf = new StringBuilder();
		for (Par par : parList) {
			buf.append(par.toHtmlString(rdh, row));
		}
		return buf.toString();
	}

	public String getName() {
		return name;
	}

	public void setName(String name) {
		this.name = name;
	}

	public String getAlias() {
		return alias;
	}

	public void setAlias(String alias) {
		this.alias = alias;
	}

	public String getBgcolor() {
		return bgcolor;
	}

	public void setBgcolor(String bgcolor) {
		this.bgcolor = bgcolor;
	}

	public Boolean getNocompose() {
		return nocompose;
	}

	public void setNocompose(Boolean nocompose) {
		this.nocompose = nocompose;
	}

	public Boolean getPublicaccess() {
		return publicaccess;
	}

	public void setPublicaccess(Boolean publicaccess) {
		this.publicaccess = publicaccess;
	}

	public Boolean getDefaultVal() {
		return defaultVal;
	}

	public void setDefaultVal(Boolean defaultVal) {
		this.defaultVal = defaultVal;
	}

	public static Boolean getAttrValueBoolean(NamedNodeMap names, String key) {
		Node n = names.getNamedItem(key);
		if (n == null) {
			return null;
		}
		try {
			return Boolean.valueOf(n.getNodeValue());
		} catch (DOMException e) {
		}
		return null;
	}

	public static int getAttrValueInt(NamedNodeMap names, String key) {
		Node n = names.getNamedItem(key);
		if (n == null) {
			return 0;
		}
		return StringUtil.parseIntNoneException(n.getNodeValue(), 0);
	}

	public static void putAttrValueString(NamedNodeMap names, String key,
			Properties putProperties) {
		String val = Form.getAttrValueString(names, key);
		if (val != null) {
			putProperties.setProperty(key, val);
		}
	}

	public static String getAttrValueString(NamedNodeMap names, String key) {
		Node n = names.getNamedItem(key);
		if (n == null) {
			return null;
		}
		return n.getNodeValue();
	}

	public void putParDef(Pardef pardef) {
		pardefMap.put(pardef.getId(), pardef);
	}

	public void addPar(Par par) {
		parList.add(par);
	}

	public void parseBody(Node formNode) {
		NodeList list = formNode.getChildNodes();
		for (int i = 0; i < list.getLength(); i++) {
			Node child = list.item(i);

			if ("body".equals(child.getNodeName())) {
				System.out.println(" in Bodyyyyyyyyyyyyyyyyyy");
				parseFormBody(child);
			} else if ("item".equals(child.getNodeName())) {
				if (child.getAttributes().getLength() > 0) {
					Node attrName = child.getAttributes().getNamedItem("name");
					if (attrName != null) {
						if ("name".equals(attrName.getNodeName())) {
							// TODO:
							// フォームを作成し、文書を作成できるユーザーを指定する場合は、それらの名前が
							// [$FormUsers]
							// フィールドに格納されます。
							// attrName.getNodeValue()
						}
					}
				}

			} else {
				System.out.println("   ??parseForm#child="
						+ child.getNodeName());
			}
		}

	}

	private void parseFormBody(Node body) {
		NodeList list0 = body.getChildNodes();
		NodeList list = null;

		for (int i = 0; i < list0.getLength(); i++) {
			Node child = list0.item(i);
			if ("richtext".equals(child.getNodeName())) {
				list = child.getChildNodes();
				break;
			}
		}
		if (list == null) {
			return;
		}
		for (int i = 0; i < list.getLength(); i++) {
			Node child = list.item(i);
			// System.out.println("parseForm#child=" + child.getClass() +
			// "//"
			// + child.getLocalName() + "/" + child.getNodeName());

			if ("pardef".equals(child.getNodeName())) {
				Pardef pardef = new Pardef(child);
				putParDef(pardef);

			} else if ("table".equals(child.getNodeName())) {
				addPar(new Table(this, child));
			} else if ("par".equals(child.getNodeName())) {
				Par par = new Par(this, child);
				addPar(par);

			} else if (Node.TEXT_NODE == child.getNodeType()) {
				if (child.getTextContent().replaceAll("[\r\n]", "").trim()
						.length() > 0) {
					System.out.println("     ??parseFormBody#textNode["
							+ child.getTextContent() + "]");
				}
			} else {
				System.out.println("     ??parseFormBody#child="
						+ child.getNodeName());
			}
		}
	}
}
