package hiro.yoshioka.sql.notes.ddl;

import hiro.yoshioka.sdh.ResultSetDataHolder;
import hiro.yoshioka.util.StringUtil;

import java.io.Serializable;

import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;

public class Font extends PardefElement implements Serializable {
	private static final long serialVersionUID = -5200604478654470486L;
	String name, pitch, truetype, familyid, color;

	public Font(Node atts) {
		NamedNodeMap names = atts.getAttributes();
		name = Form.getAttrValueString(names, "name");
		pitch = Form.getAttrValueString(names, "pitch");
		truetype = Form.getAttrValueString(names, "truetype");
		familyid = Form.getAttrValueString(names, "familyid");
		color = Form.getAttrValueString(names, "color");
	}

	public String toHtmlString(ResultSetDataHolder rdh, int row) {
		StringBuilder buf = new StringBuilder();
		buf.append("<font ");
		if (!StringUtil.isEmpty(name)) {
			buf.append(" name='").append(name).append("'");
		}
		if (!StringUtil.isEmpty(pitch)) {
			buf.append(" pitch='").append(pitch).append("'");
		}
		if (!StringUtil.isEmpty(truetype)) {
			buf.append(" truetype='").append(truetype).append("'");
		}
		if (!StringUtil.isEmpty(familyid)) {
			buf.append(" familyid='").append(familyid).append("'");
		}
		if (!StringUtil.isEmpty(color)) {
			buf.append(" color='").append(color).append("'");
		}
		buf.append(" />");
		if (!StringUtil.isEmpty(charactors)) {
			buf.append(charactors);
		}
		return buf.toString();
	}

}
