package hiro.yoshioka.sql.notes;

import hiro.yoshioka.classmanager.ClassManager;
import hiro.yoshioka.sdh.StringRecordData;
import hiro.yoshioka.sdh2.ResultSetDataHolder2;
import hiro.yoshioka.sql.notes.reflect.WolfDatabase;
import hiro.yoshioka.sql.notes.reflect.WolfDocument;
import hiro.yoshioka.sql.notes.reflect.WolfDocumentCollection;
import hiro.yoshioka.sql.notes.reflect.WolfItem;
import hiro.yoshioka.sql.notes.reflect.WolfView;
import hiro.yoshioka.sql.params.ConnectionProperties;
import hiro.yoshioka.sql.params.DBResourceCapturingFilter;
import hiro.yoshioka.sql.params.DBUserPass;
import hiro.yoshioka.sql.resource.DBRoot;
import hiro.yoshioka.sql.resource.DBSchema;
import hiro.yoshioka.sql.resource.DBTable;
import hiro.yoshioka.sql.resource.IDBSchema;
import hiro.yoshioka.sql.resource.IDBTable;
import hiro.yoshioka.util.StringUtil;

import java.io.File;
import java.lang.reflect.InvocationTargetException;
import java.net.MalformedURLException;
import java.util.ArrayList;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import java.util.Vector;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;

public class NotesRunnerSelection extends AbsNotesRunner implements
		Callable<ResultSetDataHolder2> {
	IDBTable table;
	ConnectionProperties properties;
	int maxRowNum;
	Set<String> unidSet;
	ResultSetDataHolder2 rdh2;

	public NotesRunnerSelection(ClassManager manager,
			ConnectionProperties properties, IDBTable table, int maxRowNum) {
		super(manager, properties);
		this.table = table;
		this.properties = properties;
		this.maxRowNum = maxRowNum;
	}

	public NotesRunnerSelection(ClassManager manager,
			ConnectionProperties properties, IDBTable table, Set<String> unidSet) {
		super(manager, properties);
		this.table = table;
		this.properties = properties;
		this.unidSet = unidSet;
		if (unidSet != null) {
			this.maxRowNum = unidSet.size();
		}
	}

	public static void main(java.lang.String[] args) {
		ConnectionProperties p = new ConnectionProperties();

		// dom
		p.setHost("192.188.0.4");
		p.setAuthenticate(new DBUserPass("admin", "password"));

		p.setCaptureWithDDL(true);
		p.setCaptureWithColumnInfo(false);
		p.setCaptureWithViewInfo(false);

		p.setCapturingFilter(DBResourceCapturingFilter.MATCHES);
		p.addTitleRegrex(".*hoge.*");
		ClassManager cm = new ClassManager();
		try {
			DBRoot root = new DBRoot();
			IDBSchema sc = new DBSchema(root);
			sc.setName("piyo");
			root.putResource(sc.getName(), sc);
			IDBTable tbl = new DBTable(sc);
			tbl.setName("0_2：rep");
			tbl.addAlias("Response");
			cm.add_lib(new File(
					"C:/tools/eclipse/wk/WolfSQLParser/ext_lib/NCSO.jar"));
			NotesRunnerSelection sjd = new NotesRunnerSelection(cm, p, tbl, 20);
			ExecutorService ex = Executors.newSingleThreadExecutor();
			Future<ResultSetDataHolder2> future = ex.submit(sjd);
			System.out.println(future.get());
			ex.shutdown();
		} catch (Exception e1) {
			// TODO Auto-generated catch block
			e1.printStackTrace();
		}
	}

	@Override
	public ResultSetDataHolder2 call() throws Exception {
		initClass();
		createSession();

		try {
			System.out.println("server =" + server);
			System.out.println("table.getName() =" + table.getName());
			if (table.isView()) {
				return callView();
			} else {
				return callTable();
			}
		} finally {
			wolf_session.recycle();
		}
	}

	private void doclist2Rdh(WolfDocument doc) throws IllegalArgumentException,
			MalformedURLException, SecurityException, IllegalAccessException,
			InvocationTargetException, ClassNotFoundException,
			NoSuchMethodException {
		if (doc == null) {
			return;
		}
		Set<String> allKeySets = new LinkedHashSet<String>();
		for (WolfItem item : doc.getItems()) {
			allKeySets.add(item.getName());
		}
		if (rdh2 == null) {
			rdh2 = new ResultSetDataHolder2(
					allKeySets.toArray(new String[allKeySets.size()]), null);
		}

		for (WolfItem item : doc.getItems()) {
			if (!allKeySets.contains(item.getName())) {
				allKeySets.add(item.getName());
				rdh2.addColumn(item.getName(), null);
			}
		}
		int iCol = 0;
		StringRecordData[] record = new StringRecordData[allKeySets.size()];
		for (String key : allKeySets) {
			// Object o = obj.getItemValueString(key);
			// if (o != null) {
			// System.out.println(o.getClass());
			// }
			try {
				if (doc.hasItem(key)) {
					WolfItem item = doc.getFirstItem(key);
					record[iCol] = getItemValue(doc, key);
					// if (item.isRichText()) {
					// item.saveAttachment(new File("C:/tmp"));
					// }
					item.recycle();
				} else {
					record[iCol] = new StringRecordData(null);
				}
				iCol++;
			} catch (Exception e) {
				e.printStackTrace();
			}
		}

		rdh2.addRow(record);
		// System.out.println(obj.generateXML());

	}

	public ResultSetDataHolder2 callTable() throws Exception {

		WolfDatabase database = getDatabaseByTable(table);

		System.out.println("database =" + database);
		if (!database.isOpen()) {
			database.open();
		}
		try {
			if (unidSet == null) {
				String query = String.format("Form=\"%s\"", table.getAlias());
				System.out.println("query=" + query);
				WolfDocumentCollection docs = database.search(query);
				System.err.println("--------------------");
				System.out.println("result count=" + docs.getCount());
				WolfDocument doc = docs.getFirstDocument();
				doclist2Rdh(doc);
				while (doc != null) {
					doc = docs.getNextDocument();
					doclist2Rdh(doc);
					System.out.println(rdh2.getRowCount() + "/" + maxRowNum);
					if (rdh2.getRowCount() >= maxRowNum) {
						System.out
								.println("break [" + rdh2.getRowCount() + "]");
						break;
					}
					if (rdh2.getRowCount() >= 20) {
						System.out.println("break 20[" + rdh2.getRowCount()
								+ "]");
						break;
					}
				}

			} else {
				for (String unid : unidSet) {
					WolfDocument doc = database.getDocumentByUNID(unid);
					System.out.println("unid=" + unid + "  doc=" + doc);
					doclist2Rdh(doc);

					System.out.println(rdh2.getRowCount() + "/" + maxRowNum);
					if (rdh2.getRowCount() >= maxRowNum) {
						System.out
								.println("break [" + rdh2.getRowCount() + "]");
						break;
					}
					if (rdh2.getRowCount() >= 20) {
						System.out.println("break 20[" + rdh2.getRowCount()
								+ "]");
						break;
					}

				}
				System.out.println();
				System.out.println();
			}
		} catch (Exception ne) {
			ne.printStackTrace();
			System.out.println(ne.getLocalizedMessage());
		} finally {
		}
		System.out.println("return " + rdh2);

		return rdh2;

	}

	public ResultSetDataHolder2 callView() throws Exception {
		ResultSetDataHolder2 rdh = null;

		WolfView view = getView(table);

		try {
			WolfDocument doc = view.getFirstDocument();
			Set<String> allKeySets = new LinkedHashSet<String>();
			List<WolfDocument> docList = new ArrayList<WolfDocument>();
			while (doc != null) {
				for (WolfItem item : doc.getItems()) {
					allKeySets.add(item.getName());
					item.recycle();
				}
				docList.add(doc);
				doc = view.getNextDocument(doc);
			}
			rdh = new ResultSetDataHolder2(
					allKeySets.toArray(new String[allKeySets.size()]), null);
			for (WolfDocument obj : docList) {
				System.out.println("hereaaaaaaaaaaa-------------["
						+ obj.getUniversalID() + "]");
				StringRecordData[] record = new StringRecordData[allKeySets
						.size()];
				int iCol = 0;
				for (String key : allKeySets) {
					// Object o = obj.getItemValueString(key);
					// if (o != null) {
					// System.out.println(o.getClass());
					// }
					System.out.println(key);
					if (obj.hasItem(key)) {
						WolfItem item = obj.getFirstItem(key);
						record[iCol] = getItemValue(obj, key);
						if (item.isRichText()) {
							item.saveAttachment(new File("C:/tmp"));
						}
						item.recycle();
					} else {
						record[iCol] = new StringRecordData(null);
					}
					iCol++;
				}

				rdh.addRow(record);
				if (rdh.getRowCount() >= maxRowNum) {
					break;
				}
				// System.out.println(obj.generateXML());
			}
			System.out.println(rdh);
		} catch (Exception ne) {
			ne.printStackTrace();
			System.out.println(ne.getLocalizedMessage());
		} finally {
		}

		return rdh;

	}

	private StringRecordData getItemValue(WolfDocument obj, String key)
			throws IllegalArgumentException, IllegalAccessException,
			InvocationTargetException {
		Vector v = obj.getItemValue(key);
		if (v == null || v.size() == 0) {
			return new StringRecordData(null);
		}
		StringBuilder buf = new StringBuilder();
		buf.append(v.get(0));
		for (int i = 1; i < v.size(); i++) {
			buf.append(StringUtil.LINE_SEPARATOR).append(v.get(i));
		}
		if ("$FILE".equals(key)) {
			System.out.println("vec=" + obj.getItemValue(key));
			System.out.println("str=" + obj.getItemValueString(key));
		}
		return new StringRecordData(buf.toString());
	}

}
