package hiro.yoshioka.sql.notes;

import hiro.yoshioka.classmanager.ClassManager;
import hiro.yoshioka.sql.notes.ddl.Database;
import hiro.yoshioka.sql.notes.ddl.Form;
import hiro.yoshioka.sql.notes.ddl.NotesDXLParser2;
import hiro.yoshioka.sql.notes.reflect.WolfACL;
import hiro.yoshioka.sql.notes.reflect.WolfDBDirectory;
import hiro.yoshioka.sql.notes.reflect.WolfDatabase;
import hiro.yoshioka.sql.notes.reflect.WolfDocument;
import hiro.yoshioka.sql.notes.reflect.WolfDxlExporter;
import hiro.yoshioka.sql.notes.reflect.WolfForm;
import hiro.yoshioka.sql.notes.reflect.WolfItem;
import hiro.yoshioka.sql.notes.reflect.WolfNoteCollection;
import hiro.yoshioka.sql.notes.reflect.WolfView;
import hiro.yoshioka.sql.params.ConnectionProperties;
import hiro.yoshioka.sql.resource.DBRoot;
import hiro.yoshioka.sql.resource.DBSchema;
import hiro.yoshioka.sql.resource.DBTable;
import hiro.yoshioka.sql.resource.IDBSchema;
import hiro.yoshioka.sql.resource.IDBTable;
import hiro.yoshioka.sql.resource.notes.ItemType;
import hiro.yoshioka.sql.resource.notes.NotesDBColumn;
import hiro.yoshioka.sql.resource.notes.NotesDBTable;
import hiro.yoshioka.util.FileUtil;
import hiro.yoshioka.util.StringUtil;

import java.io.File;
import java.lang.reflect.InvocationTargetException;
import java.net.MalformedURLException;
import java.util.LinkedHashSet;
import java.util.Properties;
import java.util.Set;
import java.util.Vector;
import java.util.concurrent.Callable;

public class NotesRunnerMeta extends AbsNotesRunner implements Callable<DBRoot> {
	ConnectionProperties connectionProperties;
	IDBTable onlyTable;

	public NotesRunnerMeta(ClassManager manager, ConnectionProperties properties) {
		this(manager, properties, null);
	}

	public NotesRunnerMeta(ClassManager manager,
			ConnectionProperties properties, IDBTable table) {
		super(manager, properties);
		this.connectionProperties = properties;
		this.onlyTable = table;
	}

	@Override
	public DBRoot call() throws Exception {
		initClass();
		createSession();

		DBRoot root = null;

		try {
			String p = wolf_session.getPlatform();
			String nv = wolf_session.getNotesVersion();

			System.out.println("Current Platform : " + p);
			System.out.println("Current Domino Version: " + nv);

			if (this.onlyTable == null) {
				WolfDBDirectory wolf_directory = wolf_session
						.getDbDirectory(StringUtil.EMPTY_STRING);

				WolfDatabase wolf_database = wolf_directory
						.getFirstDatabase(WolfDBDirectory.dbDirectory_database_type);

				root = new DBRoot(userid);
				if (StringUtil.isEmpty(userid)) {
					root.setName("lotus.domino.Database");
				} else {
					root.setName("lotus.domino.Database[" + userid + "]");
				}
				root.setPropertyValue("DatabaseProductName", "Lotus");
				int total = 0;
				out: while (wolf_database != null) {
					DBSchema schema = null;
					try {
						String categories = wolf_database.getCategories();
						String title = wolf_database.getTitle();
						String filePath = wolf_database.getFilePath();
						String templateName = wolf_database.getTemplateName();
						String url = wolf_database.getURL();
						Integer currentAccessLevel = wolf_database
								.getCurrentAccessLevel();
						String fileName = wolf_database.getFileName();
						String server = wolf_database.getServer();

						if (!connectionProperties.isCapturingTarget(categories,
								filePath, title)) {
							continue;
						}
						schema = (DBSchema) root.getResource(title);
						if (schema == null) {
							schema = new DBSchema(root);
							schema.setName(title);
							schema.setComment(filePath);
							root.putResource(title, schema);
						}

						System.out.println("CAT[" + categories + "]");
						System.out.println("TITLE[" + title + "]");
						System.out.println("    " + templateName);
						System.out.println("    " + url);
						System.out.println("FPATH[" + filePath + "]");
						System.out.println("    getCurrentAccessLevel:"
								+ currentAccessLevel);

						Properties prop = new Properties();
						prop.setProperty("categories", categories);
						prop.setProperty("currentAccessLevel",
								String.valueOf(currentAccessLevel));
						prop.setProperty("fileName", fileName);
						prop.setProperty("filePath", filePath);
						prop.setProperty("server", server);
						prop.setProperty("templateName", templateName);
						schema.setProperties(prop);

						total++;

						if (!wolf_database.isOpen()) {
							try {
								wolf_database.open();
							} catch (Exception e) {
								schema.setComment("Out:" + e.getMessage());
								e.printStackTrace();

								continue;
							}
						}

						System.out.println("=== ACL");
						WolfACL wolf_acl = wolf_database.getACL();
						System.out.println(wolf_acl.toHtmlString());
						wolf_acl.recycle();

						for (WolfForm wolf_form : wolf_database.getForms()) {
							NotesDBTable table = new NotesDBTable(schema);
							table.setTableType(DBTable.TABLE_TYPE_TABLE);
							table.setName(wolf_form.getName());
							schema.putTable(table);

							prop = new Properties();
							Vector<String> readers = wolf_form.getReaders();
							System.out.println("Form readers=" + readers);
							if (readers == null || readers.size() == 0) {
								prop.setProperty("Readers", "Nothing");
							} else {
								prop.setProperty("Readers", readers.toString());
							}

							for (String alias : wolf_form.getAliases()) {
								table.addAlias(alias);
							}

							System.out
									.println("=====================================");
							System.out.println(table.getName());

							if (connectionProperties.isCaptureWithColumnInfo()) {
								for (String fieldName : wolf_form.getFields()) {
									NotesDBColumn col = new NotesDBColumn(table);
									col.setName(fieldName);
									ItemType type = wolf_form
											.getFieldType(fieldName);
									col.setItemType(type);
									System.out.println("  [" + fieldName + "] "
											+ type);
									table.putResource(fieldName, col);
								}
							}
							wolf_form.recycle();
						}
						if (connectionProperties.isCaptureWithDDL()) {
							setDDL(wolf_database, schema);
						}

						if (connectionProperties.isCaptureWithViewInfo()) {
							for (WolfView wolf_view : wolf_database.getViews()) {
								DBTable view = new DBTable(schema);
								view.setTableType(DBTable.TABLE_TYPE_VIEW);
								view.setName(wolf_view.getName());
								System.out.println("View" + view.getName()
										+ " Readers" + wolf_view.getReaders());
								view.setPropertyValue("database", title);
								schema.putTable(view);
								try {
									/*
									 * why raise Exception at column count 0?
									 */
									if (wolf_view.getColumnCount() <= 0) {
										continue;
									}
								} catch (Exception e) {
									continue;
								}
								setColumns(wolf_view.getFirstDocument(), view);
								setColumns(wolf_view.getLastDocument(), view);
								wolf_view.recycle();
							}
						}
					} catch (Exception e) {
						System.err.println(e.getMessage());
						e.printStackTrace();
					} finally {
						wolf_database.recycle();
						wolf_database = wolf_directory.getNextDatabase();
					}
					System.out.println("[" + total
							+ "]=========================================");
				}

				wolf_database = null;
			} else {
				root = onlyTable.getRoot();
				try {
					WolfDatabase wolf_database = getDatabaseByTable(onlyTable);
					if (!wolf_database.isOpen()) {
						try {
							wolf_database.open();
						} catch (Exception e) {
							onlyTable.getParent().setComment(
									"Out:" + e.getMessage());
							e.printStackTrace();
						}
					}
					for (WolfForm wolf_form : wolf_database.getForms()) {
						System.out.println("fn=" + wolf_form.getName()
								+ "/tar=" + onlyTable.getName());
						if (!wolf_form.getName().equals(onlyTable.getName())) {
							wolf_form.recycle();
							continue;
						}
						for (String fieldName : wolf_form.getFields()) {
							NotesDBColumn col = new NotesDBColumn(onlyTable);
							col.setName(fieldName);
							ItemType type = wolf_form.getFieldType(fieldName);
							col.setItemType(type);
							System.out.println("  [" + fieldName + "] " + type);
							onlyTable.putResource(fieldName, col);
						}
						wolf_form.recycle();
					}
				} catch (Exception e) {
					e.printStackTrace();
				}
			}

		} finally {
			System.out.println("session recycle");
			wolf_session.recycle();
			System.out.println("session recycled");
		}
		System.out.println("ret=" + root);
		return root;
	}

	private void setDDL(WolfDatabase wolf_database, IDBSchema schema)
			throws IllegalArgumentException, IllegalAccessException,
			InvocationTargetException {

		WolfNoteCollection wolf_noteCollection = null;
		WolfDxlExporter wolf_dxlExporter = null;
		try {
			wolf_noteCollection = wolf_database.createNoteCollection(false);

			// noteco
			wolf_noteCollection.selectAllDesignElements(true);
			wolf_noteCollection.setSelectHelpAbout(false);
			wolf_noteCollection.buildCollection();

			wolf_dxlExporter = wolf_session.createDxlExporter();
			wolf_dxlExporter.setOutputDOCTYPE(false);
			wolf_dxlExporter.setConvertNotesBitmapsToGIF(true);

			String dxl = wolf_dxlExporter.exportDxl(wolf_noteCollection);

			FileUtil.writeFile(new File("c:/hoho.dxl"), dxl, "UTF-8");
			Set<String> formSet = new LinkedHashSet<String>();
			for (IDBTable tbl : schema.getTables()) {
				formSet.add(tbl.getName());
				formSet.add(tbl.getAlias());
			}
			Database db = NotesDXLParser2.parseDxl(dxl, formSet);
			for (IDBTable tbl : schema.getTables()) {
				Form form = db.getFrom(tbl.getName());
				if (form == null) {
					form = db.getFrom(tbl.getAlias());
				}
				if (form != null) {
					((NotesDBTable) tbl).setForm(form);
				}
			}
		} catch (Exception e1) {
			e1.printStackTrace();
		} finally {
			wolf_noteCollection.recycle();
			if (wolf_dxlExporter != null) {
				wolf_dxlExporter.recycle();
			}
		}

	}

	private void setColumns(WolfDocument documentInstance, IDBTable table)
			throws IllegalArgumentException, IllegalAccessException,
			InvocationTargetException, MalformedURLException,
			SecurityException, ClassNotFoundException, NoSuchMethodException {
		if (documentInstance != null) {
			for (WolfItem itemInstance : documentInstance.getItems()) {
				String itemName = itemInstance.getName();
				if (table.getResource(itemName) != null) {
					continue;
				}
				NotesDBColumn col = new NotesDBColumn(table);
				col.setName(itemName);
				col.setItemType(itemInstance.getType());

				col.setRichText(itemInstance.isRichText());

				table.putResource(itemName, col);
			}
		}
	}
}
