package hiro.yoshioka.sql.engine;

import hiro.yoshioka.ast.sql.util.BindInfo;
import hiro.yoshioka.sdh2.ResultSetDataHolder2;
import hiro.yoshioka.sql.params.ConnectionProperties;
import hiro.yoshioka.sql.resource.DBRoot;
import hiro.yoshioka.sql.resource.IDBTable;
import hiro.yoshioka.sql.util.CommentAnalyzer;
import hiro.yoshioka.sql.util.CommentInfo;
import hiro.yoshioka.util.StringUtil;

import java.io.File;

import javax.script.Invocable;
import javax.script.ScriptEngine;

public class TransactionRequest extends Request {
	private CommentInfo commentInfo;
	protected String fSQLStatement;
	protected String[] fSQLStatements;
	public boolean requestForUpdatable;

	Object[] fBindObjects;

	ResultSetDataHolder2 fRdh;

	String fTitle;

	int timeOut;

	int maxRownum;

	long resultCount;

	IDBTable table;
	protected IDBTable[] tables;

	public CommentInfo getCommentInfo() {
		return commentInfo;
	}

	public int getMaxRownum() {
		return maxRownum;
	}

	public void setMaxRownum(int maxRownum) {
		this.maxRownum = maxRownum;
	}

	public TransactionRequest(SQLOperationType operation,
			ConnectionProperties properties, IDBTable table) {
		this(operation, properties, null, null, table);
	}

	public TransactionRequest(SQLOperationType operation,
			ConnectionProperties properties, String sql_statement,
			Object[] binds, IDBTable table) {
		super(operation, properties);
		this.fSQLStatement = sql_statement;
		this.fBindObjects = binds;
		this.table = table;
		this.commentInfo = CommentAnalyzer.parse(sql_statement);
	}

	public TransactionRequest(SQLOperationType operation,
			ConnectionProperties properties, String sql_statement) {
		super(operation, properties);
		fSQLStatement = sql_statement;
		this.commentInfo = CommentAnalyzer.parse(sql_statement);
	}

	public TransactionRequest(SQLOperationType operation,
			ConnectionProperties properties, String[] sql_statements) {
		super(operation, properties);
		fSQLStatements = sql_statements;
		if (sql_statements.length > 0) {
			this.commentInfo = CommentAnalyzer.parse(sql_statements[0]);
		}
	}

	public TransactionRequest(SQLOperationType operation,
			ConnectionProperties properties, IDBTable[] tables) {
		super(operation, properties);
		this.tables = tables;

	}

	public String getTitle() {
		return fTitle;
	}

	public int getTimeOut() {
		return timeOut;
	}

	public void setTimeOut(int timeOut) {
		this.timeOut = timeOut;
	}

	public void setRDH(ResultSetDataHolder2 rdh) {
		if (rdh != null) {
			log.debug("rdh size=" + rdh.getRowCount());
		}
		fRdh = rdh;
	}

	public ResultSetDataHolder2 getRdh() {
		return fRdh;
	}

	public void setSQLStatement(String sqlStatement) {
		this.fSQLStatement = sqlStatement;
	}

	public String getSQLStatement() {
		if (fSQLStatement == null) {
			if (fSQLStatements == null) {
				log.fatal("empty sqlStatement!!!!!!!!!!");
				return StringUtil.EMPTY_STRING;
			}
			StringBuffer buf = new StringBuffer();
			for (int i = 0; i < fSQLStatements.length; i++) {
				buf.append(String.format("%s;%n", fSQLStatements[i]));
			}
			return buf.toString();
		}
		return fSQLStatement;
	}

	public void setTable(IDBTable table) {
		this.table = table;
	}

	public IDBTable getIDBTable() {
		return table;
	}

	public String[] getSQLStatements() {
		if (fSQLStatements == null) {
			return new String[] { fSQLStatement };
		}
		return fSQLStatements;
	}

	public void setPartName(String title) {
		fTitle = title;
	}

	public Object[] getBindObjects() {
		if (fBindObjects == null) {
			return new Object[0];
		}
		return fBindObjects;
	}

	public void setResult(boolean b) {
		fRdh = new ResultSetDataHolder2(new String[] { "Result" }, null);
		fRdh.addRow(new String[] { String.valueOf(b) });
	}

	public boolean hasBlob() {
		if (fBindObjects == null) {
			return false;
		}
		for (int i = 0; i < fBindObjects.length; i++) {
			if (fBindObjects[i] instanceof BindInfo) {
				if (((BindInfo) fBindObjects[i]).isBlob()) {
					return true;
				}
			}
		}
		return false;
	}

	@Override
	protected void before() {
		for (ScriptEngine engine : this.engines) {
			try {
				Invocable inv = (Invocable) engine;
				String[] strs = getSQLStatements();
				String[] immutableStatements = new String[strs.length];
				for (int i = 0; i < immutableStatements.length; i++) {
					immutableStatements[i] = strs[i];
				}
				engine.put("CI", getCommentInfo());
				inv.invokeFunction("before", immutableStatements, fBindObjects);
			} catch (NoSuchMethodException e) {
			} catch (Exception e) {
				log.fatal(e);
			}
		}
	}

	@Override
	protected void after() {
		for (ScriptEngine engine : this.engines) {
			try {
				Invocable inv = (Invocable) engine;
				engine.put("CI", getCommentInfo());
				inv.invokeFunction("after", fRdh, table);
			} catch (NoSuchMethodException e) {
			} catch (Exception e) {
				log.fatal(e);
			}
		}
	}

	@Override
	public void done() {
		super.done();
		if (table != null) {
			DBRoot root = this.properties.getDBRoot();
			if (root != null) {
				root.addRecentryUsedTable(table);
			}
		}
	}

	public String[] getBindStrings() {
		if (fBindObjects == null) {
			return new String[0];
		}
		String[] ret = new String[fBindObjects.length];
		for (int i = 0; i < fBindObjects.length; i++) {
			if (fBindObjects[i] instanceof BindInfo) {
				ret[i] = StringUtil.nvl(((BindInfo) fBindObjects[i])
						.getStringValue());
			} else {
				ret[i] = StringUtil.EMPTY_STRING + fBindObjects[i];
			}
		}
		return ret;
	}

	public long getResultCount() {
		return resultCount;
	}

	public void setResultCount(long resultCount) {
		this.resultCount = resultCount;
	}

	public void setScription(String[] externalJars, File scriptFolder) {
		if (externalJars != null && externalJars.length > 0) {
			for (String jar : externalJars) {
				addExternalJar(new File(jar));
			}
		}
		if (commentInfo == null) {
			return;
		}
		for (String fileName : commentInfo.interceptorsList) {
			File file = new File(scriptFolder, fileName);
			if (file.exists() && file.isFile()) {
				addInterceptor(file);
			}
		}
	}

	@Override
	protected Object getDoneArgObject() {
		switch (operation) {
		case SELECT_ALL:
		case EXECUTE_BAT:
		case PREPARED_EXECUTE_QUERY:
		case CREATE_TRIG_FNC_PROC:
		case PREPARED_EXECUTE:
		case UNID_EXECUTE_QUERY:
		case COUNTS:
			if (getRdh() == null) {
				log.info("rdh  is null");
			} else {
				log.info("rdh#count=" + getRdh().getRowCount());
			}
			return getRdh();
		case COUNT:
			return resultCount;
		}
		return super.getDoneArgObject();
	}

	public IDBTable[] getIDBTables() {
		if (tables == null) {
			return new IDBTable[] { table };
		}
		return tables;
	}

	public long getReturnedRowCount() {
		switch (operation) {
		case SELECT_ALL:
		case EXECUTE_BAT:
		case PREPARED_EXECUTE_QUERY:
		case CREATE_TRIG_FNC_PROC:
		case PREPARED_EXECUTE:
		case COUNTS:
			if (getRdh() == null) {
				log.info("rdh  is null");
				return -1;
			} else {
				log.info("rdh#count=" + getRdh().getRowCount());
				return getRdh().getRowCount();
			}
		case COUNT:
			return resultCount;
		}
		return -1;
	}
}