package hiro.yoshioka.sql.engine;

import hiro.yoshioka.sql.params.ConnectionProperties;
import hiro.yoshioka.sql.resource.IDBResource;

public class ResourceCaptionRequest extends Request {
	private boolean canceled;

	private boolean fGetComment;

	private boolean fGetIndex;

	private boolean fExportedKeys;

	public boolean grabOnlyTableResource = false;

	public boolean fCaptionForignKey;

	public IDBResource selectionResource;

	public ResourceCaptionRequest(ConnectionProperties connection) {
		super(SQLOperationType.RESOURCE_CAPTION, connection);
	}

	public boolean doGetComment() {
		return fGetComment;
	}

	public void setFGetComment(boolean getComment) {
		fGetComment = getComment;
	}

	public void setExportedKeys(boolean getForignKey) {
		fExportedKeys = getForignKey;
	}

	public boolean doGetIndex() {
		return fGetIndex;
	}

	public void setFGetIndex(boolean getIndex) {
		fGetIndex = getIndex;
	}

	public String toString() {
		StringBuffer buf = new StringBuffer();
		buf.append("PATTERN [S/T/P] [");
		// buf.append(getSchemaP()).append("/");
		// buf.append(getTableP()).append("/");
		// buf.append(getProcedureP());
		buf.append("]");
		return buf.toString();
	}

	@Override
	protected void endOperation(boolean operationResult) {
		super.endOperation(operationResult);
		if (operationResult) {
			properties.setDBRoot(SQLServerThread.getSQLServer()
					.getTransactionSQL(properties).getRoot());
		}
	}

	@Override
	protected Object getDoneArgObject() {
		return SQLServerThread.getSQLServer().getTransactionSQL(properties)
				.getRoot();
	}

	public boolean doGetExportedKeys() {
		return fExportedKeys;
	}

	public synchronized void cancel() {
		canceled = true;
	}

	public synchronized boolean canceld() {
		return canceled;
	}

}