package hiro.yoshioka.sql.engine;

import hiro.yoshioka.sql.IRequestListener;
import hiro.yoshioka.sql.ITransactionSQL;
import hiro.yoshioka.sql.params.ConnectionProperties;
import hiro.yoshioka.util.FileUtil;

import java.io.File;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLClassLoader;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;

import javax.script.ScriptEngine;
import javax.script.ScriptEngineManager;
import javax.script.ScriptException;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class Request extends Thread {
	public enum SCRIPTING_CONST {
		FILE_NAME, FILES, LOG
	};

	public static final int DONE = 2;

	public static final int PRE = 0;

	public static final int EXECUTE = 1;

	public final SQLOperationType operation;

	int fFase = PRE;

	Throwable e;
	/** Classloader to be used when running the script. */
	private ClassLoader scriptLoader;

	List<File> interceptorsList;

	Set<URL> externalJarSet;

	List<IRequestListener> fListener;

	public boolean result;

	protected ConnectionProperties properties;

	protected Log log = LogFactory.getLog(getClass());

	protected ScriptEngine[] engines;
	protected static final ScriptEngine[] EMPTY_ENGINES = new ScriptEngine[0];

	public Request(SQLOperationType operation) {
		this.operation = operation;
	}

	public Request(SQLOperationType operation, ConnectionProperties properties) {
		this.operation = operation;
		this.properties = properties;
	}

	public void addInterceptor(File script) {
		if (interceptorsList == null) {
			interceptorsList = new ArrayList<File>();
		}
		interceptorsList.add(script);
	}

	public void addExternalJar(File externalJarFile) {
		if (externalJarSet == null) {
			externalJarSet = new HashSet<URL>();
		}
		try {
			externalJarSet.add(externalJarFile.toURL());
		} catch (MalformedURLException e) {
		}
	}

	public static void main(String[] args) {
		Thread currentThread = Thread.currentThread();
		ClassLoader originalLoader = currentThread.getContextClassLoader();
		File ff = new File("/Users/yonsama/tmp/piyo.jar");
		URLClassLoader loader = null;
		try {
			loader = new URLClassLoader(new URL[] { ff.toURL() });
			// Class clsss = loader.loadClass("piyo.PiyoPiyo");
			// System.out.println("cl=" + clsss);
		} catch (Exception e1) {
			e1.printStackTrace();
		}
		currentThread.setContextClassLoader(loader);

		ScriptEngineManager manager = new ScriptEngineManager();
		ScriptEngine engine = manager.getEngineByName("JavaScript");
		// engine.getContext().
		try {
			engine.eval("print('hoge  ');");
			engine.eval("print('piyo  ');");
			engine.eval("print('' + new Packages.piyo.PiyoPiyo() );");
		} catch (ScriptException e) {
			// TODO Auto-generated catch block
			e.printStackTrace();
		}

	}

	protected void createScriptEngines() {
		if (interceptorsList == null) {
			this.engines = EMPTY_ENGINES;
			return;
		}
		this.engines = new ScriptEngine[this.interceptorsList.size()];
		for (int i = 0; i < this.interceptorsList.size(); i++) {
			ScriptEngineManager manager = new ScriptEngineManager();
			this.engines[i] = manager.getEngineByName("JavaScript");
			try {

				this.engines[i].eval(FileUtil.getText(interceptorsList.get(i)));
				this.engines[i].put(SCRIPTING_CONST.FILE_NAME.name(),
						interceptorsList.get(i).getName());
				this.engines[i].put(SCRIPTING_CONST.FILES.name(),
						interceptorsList.toArray(new File[interceptorsList
								.size()]));
				this.engines[i].put(SCRIPTING_CONST.LOG.name(), log);
			} catch (Exception e) {
				log.fatal(e);
			}
		}
	}

	public void addListener(IRequestListener listerner) {
		if (fListener == null) {
			fListener = new ArrayList<IRequestListener>();
		}
		fListener.add(listerner);
	}

	public int getFase() {
		return fFase;
	}

	public String toString() {
		return getClass().getName() + super.toString();
	}

	public Throwable getException() {
		return e;
	}

	public boolean hasException() {
		return e != null;
	}

	public void run() {
		execute();
	}

	public void begtinTask(String taskName, int row) {
		if (fListener != null) {
			for (Iterator<IRequestListener> ite = fListener.iterator(); ite
					.hasNext();) {
				IRequestListener obj = ite.next();
				obj.begtinTask(taskName, row);
			}
		}
	}

	public void subTask(String subTaskName) {
		if (fListener != null) {
			for (Iterator<IRequestListener> ite = fListener.iterator(); ite
					.hasNext();) {
				IRequestListener obj = ite.next();
				obj.subTask(subTaskName);
			}
		}
	}

	public void worked(int i) {
		if (fListener != null) {
			for (Iterator<IRequestListener> ite = fListener.iterator(); ite
					.hasNext();) {
				IRequestListener obj = ite.next();
				obj.worked(i);
			}
		}
	}

	public void pre() {
		if (fListener != null) {
			for (IRequestListener listener : fListener) {
				try {
					System.out.println("listener=" + listener);
					listener.called_pre(this, operation);
				} catch (Exception e) {
					e.printStackTrace();
				}
			}
		}
	}

	final public boolean execute() {
		ITransactionSQL sql = SQLServerThread.getSQLServer().getTransactionSQL(
				properties);
		if (sql == null) {
			log.debug("cant execute sql request");
			return false;
		}
		pre();
		Thread currentThread = Thread.currentThread();
		ClassLoader originalLoader = currentThread.getContextClassLoader();
		if (externalJarSet != null && externalJarSet.size() > 0) {
			try {
				URLClassLoader loader = new URLClassLoader(
						externalJarSet.toArray(new URL[externalJarSet.size()]));
				currentThread.setContextClassLoader(loader);
			} catch (Exception e1) {
			}
		}

		createScriptEngines();
		if (engines.length > 0) {
			before();
		}
		currentThread.setContextClassLoader(originalLoader);
		try {
			fFase = EXECUTE;
			result = sql.doOperation(operation, this);
		} catch (Throwable e) {
			log.fatal("Operation error", e);
			if (e instanceof SQLException) {
				SQLException e2 = ((SQLException) e).getNextException();
				if (e2 != null) {
					log.fatal("Operation error", e2);
				}
			}
			this.e = e;
		}
		endOperation(result);
		if (engines.length > 0) {
			if (externalJarSet != null && externalJarSet.size() > 0) {
				try {
					URLClassLoader loader = new URLClassLoader(
							externalJarSet.toArray(new URL[externalJarSet
									.size()]));
					currentThread.setContextClassLoader(loader);
				} catch (Exception e1) {
				}
			}
			after();
			currentThread.setContextClassLoader(originalLoader);
		}
		fFase = DONE;
		done();
		return result;
	}

	protected void endOperation(boolean operationResult) {
	}

	protected void before() {
	}

	protected void after() {
	}

	protected Object getDoneArgObject() {
		return null;
	}

	public void done() {
		if (fListener != null) {
			Object o = getDoneArgObject();
			for (Iterator<IRequestListener> ite = fListener.iterator(); ite
					.hasNext();) {
				IRequestListener obj = ite.next();
				obj.called_done(this, operation, properties, o);
			}
		}
	}

	public ConnectionProperties getConnectionProperties() {
		return properties;
	}
}