package hiro.yoshioka.sql;

import hiro.yoshioka.ast.sql.oracle.WolfSQLParserConstants;
import hiro.yoshioka.sdh.ResultSetDataHolder;
import hiro.yoshioka.sdh2.ResultSetDataHolder2;
import hiro.yoshioka.sql.engine.Request;
import hiro.yoshioka.sql.engine.ResourceCaptionRequest;
import hiro.yoshioka.sql.engine.SQLOperationType;
import hiro.yoshioka.sql.engine.TransactionRequest;
import hiro.yoshioka.sql.resource.DBTable;
import hiro.yoshioka.sql.resource.IDBSchema;
import hiro.yoshioka.sql.resource.IDBTable;

import java.io.File;
import java.sql.DatabaseMetaData;
import java.sql.Driver;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class MySQL extends AbsTransactionSQL implements IMYSQLDBConst {
	Pattern COMMENT_PATTERN = Pattern.compile("COMMENT=\'(.*)\'");

	public static String getSuggestURL() {
		return JDBC_URL_EXAMPLE;
	}

	protected MySQL(Driver ds) {
		super(ds);
	}

	protected String getSupportToken() {
		StringBuffer buf = new StringBuffer();
		Pattern p = Pattern.compile("\"(\\w+)\"");
		String[] str = WolfSQLParserConstants.tokenImage;
		for (int i = 0; i < str.length; i++) {
			Matcher m = p.matcher(str[i]);
			if (m.matches()) {
				buf.append(m.group(1)).append(",");
			}
		}
		if (buf.length() > 0) {
			buf.setLength(buf.length() - 1);
		}
		return buf.toString();
	}

	public boolean load(File f) {
		boolean ret = super.load(f);
		_root.setDefaultSchema((IDBSchema) _root.getResource(""));
		return ret;
	}

	public boolean doOperation(SQLOperationType operation, Request request)
			throws SQLException {
		boolean retCode = true;
		switch (operation) {
		case SELECT_SESSION:
			((TransactionRequest) request).setRDH(getSessionInfo());
			break;
		default:
			retCode = super.doOperation(operation, request);
			break;
		}
		return retCode;
	}

	/**
	 * @param operationCode
	 * @return
	 */
	public boolean canDoOperation(SQLOperationType operation) {
		switch (operation) {
		case SELECT_SESSION:
			return connected();
		case SELECT_LOCK:
			return false;
		default:
			return super.canDoOperation(operation);
		}
	}

	protected void setComments(ResourceCaptionRequest request)
			throws SQLException {
		ResultSetDataHolder rsC = null;
		int row = DEFAULT_ROW_NUM;

		request.begtinTask("Grab Remarks", row);

		IDBSchema schema = _root.getCurrentSchema();
		IDBTable[] tables = schema.getTables();
		for (int i = 0; i < tables.length; i++) {
			if (!tables[i].isTable()) {
				continue;
			}
			rsC = executePrepareQuery(SHOW_CREATE_TABLE + tables[i].getName(),
					new String[0]);
			String comment = rsC.getStringData()[0][2];
			Matcher m = COMMENT_PATTERN.matcher(comment);
			if (m.find()) {
				comment = m.group(1);
			} else {
				comment = "";
			}
			tables[i].setComment(comment);
			request.subTask(comment);
			request.worked(1);
		}

	}

	// --
	public ResultSetDataHolder2 getSessionInfo() throws SQLException {
		return executePrepareQuery(_extra_con, SELECT_SESSION_INFO,
				(String[]) null);
	}

	public ResultSetDataHolder2 getLockInfo() throws SQLException {
		return null;
	}

	public ResultSetDataHolder getSchemas() {
		try {
			return executePrepareQuery(
					_extra_con,
					"SELECT DISTINCT TABLE_SCHEMA AS TABLE_SCHEM FROM INFORMATION_SCHEMA.TABLES",
					new String[] {});
		} catch (Exception e) {
			fLogger.error(e);
			return null;
		} finally {
		}
	}

	protected ArrayList<String> getTablePrimaryKeys(String schema, String table)
			throws SQLException {

		ArrayList<String> items = new ArrayList<String>();

		try {
			DatabaseMetaData dbMetaData = _con.getMetaData();
			String field;

			ResultSetDataHolder rdh = RS2RDH(
					dbMetaData.getPrimaryKeys("", schema, table), true, null,
					null);

			for (int i = 0; i < rdh.getRowCount(); i++, items.add(field)) {
				field = rdh.getStringData(i, "COLUMN_NAME");
			}
		} catch (Throwable e) {
			e.printStackTrace();
		}

		return items;
	}

	protected ResultSetDataHolder createDBTableDef(
			ResourceCaptionRequest request) throws SQLException {
		try {
			ResultSetDataHolder rdh = null;

			request.begtinTask("Grab table defenitions",
					_root.getSchemas().length);
			for (IDBSchema mschema : _root.getSchemas()) {

				rdh = executePrepareQuery(_extra_con, SELECT_TABLE_LIST,
						new String[] { mschema.getName() });
				for (int i = 0; i < rdh.getRowCount(); i++) {
					String tableName = rdh.getStringData(i, "TABLE_NAME");
					String type = rdh.getStringData(i, "TABLE_TYPE")
							.toUpperCase();
					// TODO: add grab condition

					DBTable dbTable = new DBTable(mschema);
					dbTable.setName(tableName);
					dbTable.setTableType(type);
					if (_info.isCaptureWithColumnInfo()) {
						setTableColumns(mschema.getName(), dbTable);
					}
					mschema.putTable(dbTable);

					request.subTask(dbTable.toString());

					setResourceProperties(dbTable, i, rdh);
					if (request.canceld()) {
						return null;
					}
				}
				request.worked(1);
			}

			return rdh;
		} catch (RuntimeException e) {
			// TODO Auto-generated catch block
			e.printStackTrace();
			return null;
		}
	}

	public ResultSetDataHolder getTables(String text) {
		try {
			return executePrepareQuery(
					_extra_con,
					"SELECT TABLE_NAME,TABLE_TYPE FROM INFORMATION_SCHEMA.TABLES WHERE TABLE_SCHEMA = ?",
					new String[] { text });
		} catch (Exception e) {
			fLogger.error(e);
			return null;
		} finally {
		}
	}

	@Override
	protected void setTableText(ResourceCaptionRequest request)
			throws SQLException {
	}

	@Override
	protected void getTrigger() throws SQLException {
	}

	public static String getLimitString() {
		return "LIMIT 0, 30";
	}

	@Override
	protected void getSequence() throws SQLException {
	}

}